/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data.instructions;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.LineMapData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.instructions.ClassInstructions;
import com.intellij.rt.coverage.data.instructions.LineInstructions;
import com.intellij.rt.coverage.util.LineMapper;
import com.intellij.rt.coverage.util.classFinder.ClassFilter;
import java.util.Map;

public class InstructionsUtil {
    public static void merge(ProjectData source, ProjectData target, ClassFilter classFilter) {
        Object object;
        if (!target.isInstructionsCoverageEnabled()) {
            return;
        }
        Map<String, ClassInstructions> instructions = target.getInstructions();
        for (Map.Entry entry : ((ProjectData)object).getInstructions().entrySet()) {
            ClassData classData;
            String className = (String)entry.getKey();
            if (classFilter != null && !classFilter.shouldInclude(className) || (classData = target.getClassData(className)) == null) continue;
            ClassInstructions classInstructions = (ClassInstructions)entry.getValue();
            ClassInstructions classInstructions2 = instructions.get(className);
            if (classInstructions2 == null) {
                classInstructions2 = new ClassInstructions();
                instructions.put(className, classInstructions2);
            }
            classInstructions2.merge(classInstructions);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void applyInstructionsSMAP(ProjectData projectData, LineMapData[] linesMap, ClassData sourceClass, ClassData targetClass) {
        void var1_1;
        void var2_2;
        ProjectData projectData2;
        void var3_3;
        if (!projectData.isInstructionsCoverageEnabled()) {
            return;
        }
        InstructionsLineMapper instructionsLineMapper = new InstructionsLineMapper(projectData);
        LineInstructions[] lines = (LineInstructions[])instructionsLineMapper.mapLines(linesMap, sourceClass, (ClassData)var3_3);
        projectData2.getInstructions().put(var2_2.getName(), new ClassInstructions((LineInstructions[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static void dropMappedLines(ProjectData projectData, String className, FileMapData[] mappings) {
        void var1_1;
        Object object;
        void var2_2;
        if (!projectData.isInstructionsCoverageEnabled()) {
            return;
        }
        Object classInstructions = projectData.getInstructions().get(className);
        if (classInstructions == null) {
            return;
        }
        Object instructions = classInstructions.getlines();
        LineMapper.dropMappedLines((FileMapData[])var2_2, object, (String)var1_1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstructionsLineMapper
    extends LineMapper<LineInstructions> {
        private final ProjectData projectData;

        /*
         * WARNING - void declaration
         */
        public InstructionsLineMapper(ProjectData projectData) {
            void var1_1;
            this.projectData = var1_1;
        }

        @Override
        protected LineInstructions createNewLine(LineInstructions targetLine, int line) {
            return new LineInstructions();
        }

        protected LineInstructions[] createArray(int size) {
            return new LineInstructions[size];
        }

        /*
         * WARNING - void declaration
         */
        protected LineInstructions[] getLines(ClassData classData) {
            void var1_1;
            ClassInstructions classInstructions = this.projectData.getInstructions().get(classData.getName());
            if (classInstructions == null) {
                return null;
            }
            return var1_1.getlines();
        }
    }
}

