/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.runner;

import java.io.File;
import java.io.FileFilter;
import java.lang.invoke.LambdaMetafactory;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0002\u001a\u0016\u0010\b\u001a\u0004\u0018\u00010\u00022\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0000\u001a\u001e\u0010\n\u001a\u0004\u0018\u00010\u00072\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\f\u001a\u00020\u0007H\u0002\u001a\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0002\u001a\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0002*\u00020\u0013H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0007H\u0002\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"findCompilerJar", "", "Ljava/io/File;", "classFromJarInTheSameLocation", "Ljava/lang/Class;", "kotlinHome", "COMPILER_JARS", "", "tryGetResourcePathForClass", "aClass", "getResourceRoot", "context", "path", "JAR_PROTOCOL", "FILE_PROTOCOL", "JAR_SEPARATOR", "SCHEME_SEPARATOR", "extractRoot", "resourceURL", "Ljava/net/URL;", "resourcePath", "splitJarUrl", "Lkotlin/Pair;", "url", "toFileOrNull", "matchMaybeVersionedFile", "", "baseName", "kotlin-runner"})
@SourceDebugExtension(value={"SMAP\nfindCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 findCompiler.kt\norg/jetbrains/kotlin/runner/FindCompilerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1#2:114\n1755#3,3:115\n*S KotlinDebug\n*F\n+ 1 findCompiler.kt\norg/jetbrains/kotlin/runner/FindCompilerKt\n*L\n16#1:115,3\n*E\n"})
public final class FindCompilerKt {
    @NotNull
    private static final List<String> COMPILER_JARS;
    @NotNull
    private static final String JAR_PROTOCOL = "jar";
    @NotNull
    private static final String FILE_PROTOCOL = "file";
    @NotNull
    private static final String JAR_SEPARATOR = "!/";
    @NotNull
    private static final String SCHEME_SEPARATOR = "://";

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final List<File> findCompilerJar(@NotNull Class<?> classFromJarInTheSameLocation, @NotNull File kotlinHome) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter(classFromJarInTheSameLocation, (String)"classFromJarInTheSameLocation");
                Intrinsics.checkNotNullParameter((Object)kotlinHome, (String)"kotlinHome");
                v0 /* !! */  = FindCompilerKt.tryGetResourcePathForClass(classFromJarInTheSameLocation);
                if (v0 /* !! */  == null) break block7;
                it = var6_2 = v0 /* !! */ ;
                $i$a$-takeUnless-FindCompilerKt$findCompilerJar$baseDir$1 = false;
                v0 /* !! */  = it.isDirectory() == false ? var6_2 : null;
                if (v0 /* !! */  != null && (v0 /* !! */  = v0 /* !! */ .getParentFile()) != null) break block8;
            }
            v0 /* !! */  = kotlinHome;
        }
        it = var4_7 = v0 /* !! */ ;
        $i$a$-takeIf-FindCompilerKt$findCompilerJar$baseDir$2 = false;
        v1 /* !! */  = it.isDirectory() != false ? var4_7 : null;
        if (v1 /* !! */  == null) {
            return CollectionsKt.emptyList();
        }
        baseDir = v1 /* !! */ ;
        var4_7 = baseDir.listFiles((FileFilter)LambdaMetafactory.metafactory(null, null, null, (Ljava/io/File;)Z, findCompilerJar$lambda$3(java.io.File ), (Ljava/io/File;)Z)());
        if (var4_7 == null) ** GOTO lbl-1000
        it = var6_4 = var4_7;
        $i$a$-takeIf-FindCompilerKt$findCompilerJar$compilerJars$2 = false;
        v2 /* !! */  = var5_8 = it.length >= FindCompilerKt.COMPILER_JARS.size() != false ? var6_4 : null;
        if (var5_8 != null) {
            v3 = ArraysKt.toList((Object[])var5_8);
        } else lbl-1000:
        // 2 sources

        {
            v3 = null;
        }
        if ((v4 = (compilerJars = v3)) == null) {
            v4 = CollectionsKt.emptyList();
        }
        return v4;
    }

    @Nullable
    public static final File tryGetResourcePathForClass(@NotNull Class<?> aClass) {
        File file;
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        StringBuilder stringBuilder = new StringBuilder().append('/');
        String string = aClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String path = stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null)).append(".class").toString();
        String string2 = FindCompilerKt.getResourceRoot(aClass, path);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            file = new File(it).getAbsoluteFile();
        } else {
            file = null;
        }
        return file;
    }

    private static final String getResourceRoot(Class<?> context, String path) {
        URL url = context.getResource(path);
        if (url == null) {
            String string = path.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            url = ClassLoader.getSystemResource(string);
        }
        URL uRL = url;
        return uRL != null ? FindCompilerKt.extractRoot(uRL, path) : null;
    }

    private static final String extractRoot(URL resourceURL, String resourcePath) {
        String string;
        if (!StringsKt.startsWith$default((CharSequence)resourcePath, (char)'/', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)resourcePath, (char)'\\', (boolean)false, (int)2, null)) {
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if (Intrinsics.areEqual((Object)protocol, (Object)FILE_PROTOCOL)) {
            File file = FindCompilerKt.toFileOrNull(resourceURL);
            Intrinsics.checkNotNull((Object)file);
            String path = file.getPath();
            Intrinsics.checkNotNull((Object)path);
            String testPath = StringsKt.replace$default((String)path, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            String testResourcePath = StringsKt.replace$default((String)resourcePath, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            if (StringsKt.endsWith((String)testPath, (String)testResourcePath, (boolean)true)) {
                String string2 = path.substring(0, path.length() - resourcePath.length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                resultPath = string2;
            }
        } else if (Intrinsics.areEqual((Object)protocol, (Object)JAR_PROTOCOL)) {
            Pair<String, String> paths;
            String string3 = resourceURL.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFile(...)");
            Pair<String, String> pair = paths = FindCompilerKt.splitJarUrl(string3);
            if ((pair != null ? (String)pair.getFirst() : null) != null) {
                resultPath = new File((String)paths.getFirst()).getCanonicalPath();
            }
        }
        String string4 = resultPath;
        if (string4 != null) {
            char[] cArray = new char[]{File.separatorChar};
            string = StringsKt.trimEnd(string4, (char[])cArray);
        } else {
            string = null;
        }
        return string;
    }

    private static final Pair<String, String> splitJarUrl(String url) {
        String jarPath;
        String resourcePath;
        block6: {
            Integer n = StringsKt.indexOf$default((CharSequence)url, (String)JAR_SEPARATOR, (int)0, (boolean)false, (int)6, null);
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = it >= 0 ? n : null;
            if (n2 == null) {
                return null;
            }
            int pivot = n2;
            String string = url.substring(pivot + 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            resourcePath = string;
            String string2 = url.substring(0, pivot);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            jarPath = string2;
            if (StringsKt.startsWith$default((String)jarPath, (String)"jar:", (boolean)false, (int)2, null)) {
                String string3 = jarPath.substring(4);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                jarPath = string3;
            }
            if (StringsKt.startsWith$default((String)jarPath, (String)FILE_PROTOCOL, (boolean)false, (int)2, null)) {
                try {
                    File file = FindCompilerKt.toFileOrNull(new URL(jarPath));
                    Intrinsics.checkNotNull((Object)file);
                    String string4 = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
                    jarPath = StringsKt.replace$default((String)string4, (char)'\\', (char)'/', (boolean)false, (int)4, null);
                }
                catch (Exception e) {
                    String string5 = jarPath.substring(4);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    jarPath = string5;
                    if (StringsKt.startsWith$default((String)jarPath, (String)SCHEME_SEPARATOR, (boolean)false, (int)2, null)) {
                        String string6 = jarPath.substring(3);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                        jarPath = string6;
                    }
                    if (!StringsKt.startsWith$default((CharSequence)jarPath, (char)':', (boolean)false, (int)2, null)) break block6;
                    String string7 = jarPath.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                    jarPath = string7;
                }
            }
        }
        return new Pair((Object)jarPath, (Object)resourcePath);
    }

    private static final File toFileOrNull(URL $this$toFileOrNull) {
        File file;
        File file2;
        try {
            file2 = new File($this$toFileOrNull.toURI());
        }
        catch (IllegalArgumentException e) {
            file2 = null;
        }
        catch (URISyntaxException e) {
            file2 = null;
        }
        if ((file = file2) == null) {
            URL $this$toFileOrNull_u24lambda_u247 = $this$toFileOrNull;
            boolean bl = false;
            file = !Intrinsics.areEqual((Object)$this$toFileOrNull_u24lambda_u247.getProtocol(), (Object)FILE_PROTOCOL) ? null : new File($this$toFileOrNull_u24lambda_u247.getFile());
        }
        return file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean matchMaybeVersionedFile(File $this$matchMaybeVersionedFile, String baseName) {
        if (Intrinsics.areEqual((Object)$this$matchMaybeVersionedFile.getName(), (Object)baseName)) return true;
        if (Intrinsics.areEqual((Object)$this$matchMaybeVersionedFile.getName(), (Object)StringsKt.removeSuffix((String)baseName, (CharSequence)".jar"))) return true;
        Regex regex = new Regex(Regex.Companion.escape(StringsKt.removeSuffix((String)baseName, (CharSequence)".jar")) + "(-\\d.*)?\\.jar");
        String string = $this$matchMaybeVersionedFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!regex.matches((CharSequence)string)) return false;
        return true;
    }

    private static final boolean findCompilerJar$lambda$3(File f) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)f, (String)"f");
            Iterable $this$any$iv = COMPILER_JARS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String expected = (String)element$iv;
                    boolean bl2 = false;
                    if (!(FindCompilerKt.matchMaybeVersionedFile(f, expected) && Intrinsics.areEqual((Object)FilesKt.getExtension((File)f), (Object)JAR_PROTOCOL))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    static {
        Object[] objectArray = new String[]{"kotlin-compiler", "kotlin-stdlib", "kotlin-reflect"};
        COMPILER_JARS = CollectionsKt.listOf((Object[])objectArray);
    }
}

