/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.runner;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.runner.AbstractRunner;
import org.jetbrains.kotlin.runner.RunnerException;
import org.jetbrains.kotlin.runner.RunnersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/runner/JarRunner;", "Lorg/jetbrains/kotlin/runner/AbstractRunner;", "path", "", "<init>", "(Ljava/lang/String;)V", "className", "getClassName", "()Ljava/lang/String;", "createClassLoader", "Ljava/lang/ClassLoader;", "classpath", "", "Ljava/net/URL;", "kotlin-runner"})
public final class JarRunner
extends AbstractRunner {
    @NotNull
    private final String path;
    @NotNull
    private final String className;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public JarRunner(@NotNull String path) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        JarRunner jarRunner = this;
        try {
            String string;
            object = new JarFile(this.path);
            JarRunner jarRunner2 = jarRunner;
            Throwable throwable = null;
            try {
                JarFile jar = (JarFile)object;
                boolean bl = false;
                string = jar.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            JarRunner jarRunner3 = jarRunner2;
            object = string;
        }
        catch (IOException iOException) {
            void e;
            JarRunner jarRunner4 = jarRunner;
            throw new RunnerException("could not read manifest from " + this.path + ": " + e.getMessage(), null, 2, null);
        }
        Object object2 = object;
        if (object2 == null) {
            throw new RunnerException("no Main-Class entry found in manifest in " + this.path, null, 2, null);
        }
        jarRunner3.className = object2;
    }

    @Override
    @NotNull
    protected String getClassName() {
        return this.className;
    }

    @Override
    @NotNull
    protected ClassLoader createClassLoader(@NotNull List<URL> classpath) {
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        URL[] uRLArray = new URL[]{new File(this.path).toURI().toURL()};
        return new URLClassLoader(uRLArray, RunnersKt.access$getPlatformClassLoader());
    }
}

