/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.runner.ExpressionRunner;
import org.jetbrains.kotlin.runner.FindCompilerKt;
import org.jetbrains.kotlin.runner.JarRunner;
import org.jetbrains.kotlin.runner.MainClassRunner;
import org.jetbrains.kotlin.runner.ReplRunner;
import org.jetbrains.kotlin.runner.Runner;
import org.jetbrains.kotlin.runner.RunnerException;
import org.jetbrains.kotlin.runner.RunnerWithCompiler;
import org.jetbrains.kotlin.runner.ScriptRunner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\f\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u001b\u0010\u0010\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0007H\u0002J\b\u0010\u0012\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/runner/Main;", "", "<init>", "()V", "KOTLIN_HOME", "Ljava/io/File;", "run", "", "args", "", "", "([Ljava/lang/String;)V", "addPath", "", "Ljava/net/URL;", "path", "main", "printUsageAndExit", "printVersionAndExit", "HowToRun", "kotlin-runner"})
@SourceDebugExtension(value={"SMAP\nMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Main.kt\norg/jetbrains/kotlin/runner/Main\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n774#2:246\n865#2,2:247\n774#2:249\n865#2,2:250\n1863#2,2:252\n*S KotlinDebug\n*F\n+ 1 Main.kt\norg/jetbrains/kotlin/runner/Main\n*L\n82#1:246\n82#1:247,2\n87#1:249\n87#1:250,2\n178#1:252,2\n*E\n"})
public final class Main {
    @NotNull
    public static final Main INSTANCE = new Main();
    @NotNull
    private static final File KOTLIN_HOME;

    private Main() {
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void run(String[] args) {
        classpath = new ArrayList<E>();
        compilerClasspath = new ArrayList<URL>();
        runner = new Ref.ObjectRef();
        arguments = new ArrayList<String>();
        compilerArguments = new ArrayList<String>();
        noStdLib = false;
        noReflect = false;
        howtorun = HowToRun.GUESS;
        i = new Ref.IntRef();
        while (i.element < args.length) {
            block23: {
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                block27: {
                                    block26: {
                                        block25: {
                                            block24: {
                                                block22: {
                                                    arg = args[i.element];
                                                    if (!Intrinsics.areEqual((Object)"-help", (Object)arg) && !Intrinsics.areEqual((Object)"-h", (Object)arg)) break block22;
                                                    this.printUsageAndExit();
                                                    break block23;
                                                }
                                                if (!Intrinsics.areEqual((Object)"-version", (Object)arg)) break block24;
                                                this.printVersionAndExit();
                                                break block23;
                                            }
                                            if (!Intrinsics.areEqual((Object)"-classpath", (Object)arg) && !Intrinsics.areEqual((Object)"-cp", (Object)arg)) break block25;
                                            var13_18 = new String[]{File.pathSeparator};
                                            $this$filter$iv = StringsKt.split$default((CharSequence)Main.run$next(i, args, arg), (String[])var13_18, (boolean)false, (int)0, (int)6, null);
                                            $i$f$filter = false;
                                            var15_23 = $this$filter$iv;
                                            destination$iv$iv = new ArrayList<E>();
                                            $i$f$filterTo = false;
                                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                                p0 = (String)element$iv$iv;
                                                $i$a$-filter-Main$run$1 = false;
                                                if (!(((CharSequence)p0).length() > 0)) continue;
                                                destination$iv$iv.add(element$iv$iv);
                                            }
                                            for (String[] path : (List)destination$iv$iv) {
                                                this.addPath((List<URL>)classpath, (String)path /* !! */ );
                                            }
                                            break block23;
                                        }
                                        if (!Intrinsics.areEqual((Object)"-compiler-path", (Object)arg)) break block26;
                                        path /* !! */  = new String[]{File.pathSeparator};
                                        $this$filter$iv = StringsKt.split$default((CharSequence)Main.run$next(i, args, arg), (String[])path /* !! */ , (boolean)false, (int)0, (int)6, null);
                                        $i$f$filter = false;
                                        $this$filterTo$iv$iv = $this$filter$iv;
                                        destination$iv$iv = new ArrayList<E>();
                                        $i$f$filterTo = false;
                                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                                            p0 = (String)element$iv$iv;
                                            $i$a$-filter-Main$run$2 = false;
                                            if (!(((CharSequence)p0).length() > 0)) continue;
                                            destination$iv$iv.add(element$iv$iv);
                                        }
                                        for (String[] path : (List)destination$iv$iv) {
                                            this.addPath((List<URL>)compilerClasspath, (String)path /* !! */ );
                                        }
                                        break block23;
                                    }
                                    if (!Intrinsics.areEqual((Object)"-howtorun", (Object)arg)) break block27;
                                    if (howtorun != HowToRun.GUESS) {
                                        throw new RunnerException("-howtorun is already set to " + howtorun.getArgName(), null, 2, null);
                                    }
                                    howToRunArg = Main.run$next(i, args, arg);
                                    if (StringsKt.startsWith$default((String)howToRunArg, (String)".", (boolean)false, (int)2, null)) {
                                        howtorun = HowToRun.SCRIPT;
                                        compilerArguments.add("-Xdefault-script-extension=" + howToRunArg);
                                    } else if (HowToRun.Companion.fromArg(howToRunArg) == null) {
                                        throw new RunnerException("invalid argument to the option -howtorun " + howToRunArg + ", valid arguments are: " + HowToRun.Companion.getValidValues(), null, 2, null);
                                    }
                                    break block23;
                                }
                                if (Intrinsics.areEqual((Object)"-expression", (Object)arg) || Intrinsics.areEqual((Object)"-e", (Object)arg)) {
                                    if (howtorun != HowToRun.GUESS && howtorun != HowToRun.SCRIPT) {
                                        throw new RunnerException("expression evaluation is not compatible with -howtorun argument " + howtorun.getArgName(), null, 2, null);
                                    }
                                    Main.run$setRunner((Ref.ObjectRef<Runner>)runner, new ExpressionRunner(Main.run$next(i, args, arg)));
                                    Main.run$restAsArguments(arguments, args, i);
                                    break;
                                }
                                if (!Intrinsics.areEqual((Object)"-no-stdlib", (Object)arg)) break block28;
                                noStdLib = true;
                                compilerArguments.add(arg);
                                break block23;
                            }
                            if (!Intrinsics.areEqual((Object)"-no-reflect", (Object)arg)) break block29;
                            noReflect = true;
                            compilerArguments.add(arg);
                            break block23;
                        }
                        if (!StringsKt.startsWith$default((String)arg, (String)"-X", (boolean)false, (int)2, null)) break block30;
                        compilerArguments.add(arg);
                        break block23;
                    }
                    if (Intrinsics.areEqual((Object)"-language-version", (Object)arg)) break block31;
                    if (StringsKt.startsWith$default((String)arg, (String)"-", (boolean)false, (int)2, null)) {
                        throw new RunnerException("unknown option: " + arg, null, 2, null);
                    }
                    if (howtorun == HowToRun.JAR || howtorun == HowToRun.GUESS && StringsKt.endsWith$default((String)arg, (String)".jar", (boolean)false, (int)2, null)) {
                        Main.run$setRunner((Ref.ObjectRef<Runner>)runner, new JarRunner(arg));
                        Main.run$restAsArguments(arguments, args, i);
                        break;
                    }
                    if (howtorun == HowToRun.SCRIPT || howtorun == HowToRun.GUESS && StringsKt.endsWith$default((String)arg, (String)".kts", (boolean)false, (int)2, null)) {
                        Main.run$setRunner((Ref.ObjectRef<Runner>)runner, new ScriptRunner(arg));
                        Main.run$restAsArguments(arguments, args, i);
                        break;
                    }
                    workingDir = new File(".");
                    classFile = new File(arg);
                    if (!StringsKt.endsWith$default((String)arg, (String)".class", (boolean)false, (int)2, null) || !classFile.exists()) ** GOTO lbl-1000
                    v0 = classFile.getCanonicalPath();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getCanonicalPath(...)");
                    v1 = v0;
                    v2 = workingDir.getCanonicalPath();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getCanonicalPath(...)");
                    if (StringsKt.contains$default((CharSequence)v1, (CharSequence)v2, (boolean)false, (int)2, null)) {
                        v3 = classFile.getCanonicalFile();
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getCanonicalFile(...)");
                        v4 = workingDir.getCanonicalFile();
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getCanonicalFile(...)");
                        v5 = StringsKt.replace$default((String)StringsKt.removeSuffix((String)FilesKt.toRelativeString((File)v3, (File)v4), (CharSequence)".class"), (char)File.separatorChar, (char)'.', (boolean)false, (int)4, null);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = arg;
                    }
                    className = v5;
                    Main.run$setRunner((Ref.ObjectRef<Runner>)runner, new MainClassRunner(className));
                    Main.run$restAsArguments(arguments, args, i);
                    break;
                }
                compilerArguments.add(arg);
                compilerArguments.add(Main.run$next(i, args, arg));
            }
            workingDir = i.element;
            i.element = workingDir + 1;
        }
        if (classpath.isEmpty()) {
            this.addPath((List<URL>)classpath, ".");
        }
        if (!noStdLib) {
            this.addPath((List<URL>)classpath, Main.KOTLIN_HOME + "/lib/kotlin-stdlib.jar");
        }
        if (!noReflect) {
            this.addPath((List<URL>)classpath, Main.KOTLIN_HOME + "/lib/kotlin-reflect.jar");
        }
        if (runner.element == null) {
            Main.run$setRunner((Ref.ObjectRef<Runner>)runner, new ReplRunner());
        }
        if (runner.element instanceof RunnerWithCompiler && compilerClasspath.isEmpty()) {
            $this$forEach$iv = FindCompilerKt.findCompilerJar(this.getClass(), FilesKt.resolve((File)Main.KOTLIN_HOME, (String)"lib"));
            $i$f$forEach = false;
            for (E element$iv : $this$forEach$iv) {
                it = (File)element$iv;
                $i$a$-forEach-Main$run$3 = false;
                compilerClasspath.add(it.getAbsoluteFile().toURI().toURL());
            }
        }
        v6 = runner.element;
        Intrinsics.checkNotNull((Object)v6);
        ((Runner)v6).run((List<URL>)classpath, (List<String>)compilerArguments, (List<String>)arguments, (List<URL>)compilerClasspath);
    }

    private final void addPath(List<URL> $this$addPath, String path) {
        URL uRL = new File(path).getAbsoluteFile().toURI().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        $this$addPath.add(uRL);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        try {
            INSTANCE.run(args);
        }
        catch (RunnerException e) {
            System.err.println("error: " + e.getMessage());
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void printUsageAndExit() {
        System.out.println((Object)("kotlin: run Kotlin programs, scripts or REPL.\n\nUsage: kotlin <options> <command> [<arguments>]\nwhere possible options include:\n  -howtorun <value>          How to run the supplied command with arguments, \n                             valid values: " + HowToRun.Companion.getValidValues() + "\n  -classpath (-cp) <path>    Paths where to find user class files\n  -Dname=value               Set a system JVM property\n  -J<option>                 Pass an option directly to JVM\n  -no-stdlib                 Don't include Kotlin standard library into classpath\n  -no-reflect                Don't include Kotlin reflection implementation into classpath\n  -compiler-path             Kotlin compiler classpath for compiling script or expression or running REPL \n                             If not specified, try to find the compiler in the environment\n  -X<flag>[=value]           Pass -X argument to the compiler\n  -version                   Display Kotlin version\n  -help (-h)                 Print a synopsis of options\nand command is interpreted according to the -howtorun option argument \nor, in case of guess, according to the following rules:\n  foo.Bar                    Runs the 'main' function from the class with the given qualified name\n                             (compiler arguments are ignored) \n  app.jar                    Runs the given JAR file as 'java -jar' would do\n                             (compiler arguments are ignored and no Kotlin stdlib is added to the classpath)\n  script.kts                 Compiles and runs the given script, passing <arguments> to it\n  -expression (-e) '2+2'     Evaluates the expression and prints the result, passing <arguments> to it\n  <no command>               Runs Kotlin REPL\narguments are passed to the main function when running class or jar file, and for standard script definitions\nas the 'args' parameter when running script or expression\n"));
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private final void printVersionAndExit() {
        String string;
        try {
            string = new Scanner(new File(KOTLIN_HOME, "build.txt")).nextLine();
        }
        catch (FileNotFoundException e) {
            throw new RunnerException("no build.txt was found at home=" + KOTLIN_HOME, null, 2, null);
        }
        String version = string;
        System.out.println((Object)("Kotlin version " + version + " (JRE " + System.getProperty("java.runtime.version") + ')'));
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private static final void run$setRunner(Ref.ObjectRef<Runner> runner, Runner newRunner) {
        if (runner.element != null) {
            throw new AssertionError((Object)"conflicting runner settings");
        }
        runner.element = newRunner;
    }

    private static final String run$next(Ref.IntRef i, String[] $args, String arg) {
        ++i.element;
        if (i.element == $args.length) {
            throw new RunnerException("argument expected to " + arg, null, 2, null);
        }
        return $args[i.element];
    }

    private static final void run$restAsArguments(ArrayList<String> arguments, String[] $args, Ref.IntRef i) {
        Object[] objectArray = $args;
        int n = i.element + 1;
        int n2 = $args.length;
        CollectionsKt.addAll((Collection)arguments, (Object[])ArraysKt.copyOfRange((Object[])objectArray, (int)n, (int)n2));
    }

    static {
        String home = System.getProperty("kotlin.home");
        if (home == null) {
            System.err.println("error: no kotlin.home system property was passed");
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        KOTLIN_HOME = new File(home);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/runner/Main$HowToRun;", "", "argName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getArgName", "()Ljava/lang/String;", "GUESS", "CLASSFILE", "JAR", "SCRIPT", "Companion", "kotlin-runner"})
    public static final class HowToRun
    extends Enum<HowToRun> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String argName;
        @NotNull
        private static final String validValues;
        public static final /* enum */ HowToRun GUESS;
        public static final /* enum */ HowToRun CLASSFILE;
        public static final /* enum */ HowToRun JAR;
        public static final /* enum */ HowToRun SCRIPT;
        private static final /* synthetic */ HowToRun[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private HowToRun(String argName) {
            this.argName = argName;
        }

        @NotNull
        public final String getArgName() {
            return this.argName;
        }

        public static HowToRun[] values() {
            return (HowToRun[])$VALUES.clone();
        }

        public static HowToRun valueOf(String value) {
            return Enum.valueOf(HowToRun.class, value);
        }

        @NotNull
        public static EnumEntries<HowToRun> getEntries() {
            return $ENTRIES;
        }

        static {
            GUESS = new HowToRun("guess");
            CLASSFILE = new HowToRun("classfile");
            JAR = new HowToRun("jar");
            SCRIPT = new HowToRun("script");
            $VALUES = howToRunArray = new HowToRun[]{HowToRun.GUESS, HowToRun.CLASSFILE, HowToRun.JAR, HowToRun.SCRIPT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            validValues = HowToRun.GUESS.argName + " (default), " + HowToRun.CLASSFILE.argName + ", " + HowToRun.JAR.argName + ", " + HowToRun.SCRIPT.argName + " (or .<script filename extension>)";
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/runner/Main$HowToRun$Companion;", "", "<init>", "()V", "validValues", "", "getValidValues", "()Ljava/lang/String;", "fromArg", "Lorg/jetbrains/kotlin/runner/Main$HowToRun;", "name", "kotlin-runner"})
        @SourceDebugExtension(value={"SMAP\nMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Main.kt\norg/jetbrains/kotlin/runner/Main$HowToRun$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,245:1\n1#2:246\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String getValidValues() {
                return validValues;
            }

            @Nullable
            public final HowToRun fromArg(@NotNull String name) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Iterable iterable = (Iterable)HowToRun.getEntries();
                    for (Object t : iterable) {
                        HowToRun it = (HowToRun)((Object)t);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getArgName(), (Object)name)) continue;
                        v0 = t;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

