/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ApkProjectFolder {
    private static final String APK_PROJECTS = "ApkProjects";
    private static final String DIALOG_TITLE = "APK Import";

    @NotNull
    public File getDefaultProjectFolder(@NotNull VirtualFile apkFile) {
        File userHomePath = new File(SystemProperties.getUserHome());
        return this.getDefaultProjectFolder(apkFile, userHomePath);
    }

    @VisibleForTesting
    @NotNull
    File getDefaultProjectFolder(@NotNull VirtualFile apkFile, @NotNull File userHomePath) {
        assert (userHomePath.isDirectory());
        String projectName = apkFile.getNameWithoutExtension();
        File apkProjectsFolderPath = new File(userHomePath, APK_PROJECTS);
        return new File(apkProjectsFolderPath, projectName);
    }

    @NotNull
    public VirtualFile createNewProjectFolder(@NotNull VirtualFile apkFile) throws IOException {
        File userHomePath = new File(SystemProperties.getUserHome());
        assert (userHomePath.isDirectory());
        String projectName = apkFile.getNameWithoutExtension();
        return this.createNewProjectFolder(projectName, userHomePath);
    }

    @VisibleForTesting
    @NotNull
    VirtualFile createNewProjectFolder(@NotNull String projectName, @NotNull File userHomePath) throws IOException {
        File apkProjectsFolderPath = new File(userHomePath, APK_PROJECTS);
        FileUtil.ensureExists((File)apkProjectsFolderPath);
        File projectFolderPath = new File(apkProjectsFolderPath, projectName);
        if (projectFolderPath.isDirectory()) {
            projectFolderPath = FileUtil.findSequentNonexistentFile((File)apkProjectsFolderPath, (String)projectName, (String)"");
        }
        FileUtil.ensureExists((File)projectFolderPath);
        VirtualFile newProjectFolder = VfsUtil.findFileByIoFile((File)projectFolderPath, (boolean)true);
        assert (newProjectFolder != null);
        return newProjectFolder;
    }

    public void deleteExistingProjectFolder(@NotNull File projectFolderPath) throws IOException {
        VirtualFile projectFolder;
        assert (projectFolderPath.isDirectory());
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        if (projects.length > 0) {
            for (Project project : projects) {
                if (!FileUtil.pathsEqual((String)projectFolderPath.getPath(), (String)project.getBasePath())) continue;
                String message = String.format("APK project '%1$s' will be closed and recreated", project.getName());
                Messages.showWarningDialog((Project)project, (String)message, (String)DIALOG_TITLE);
                ProjectUtil.closeAndDispose((Project)project);
                WelcomeFrame.showIfNoProjectOpened();
                break;
            }
        }
        if ((projectFolder = VfsUtil.findFileByIoFile((File)projectFolderPath, (boolean)true)) != null) {
            ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<Void, IOException>(){

                public Void compute() throws IOException {
                    projectFolder.delete((Object)this);
                    return null;
                }
            });
        }
        FileUtil.delete((File)projectFolderPath);
    }

    @NotNull
    public Project getOrOpenProject(@NotNull VirtualFile projectFolder) throws Exception {
        Project[] projects;
        assert (projectFolder.exists());
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            if (!projectFolder.getPath().equals(project.getBasePath())) continue;
            return project;
        }
        return this.openProject(projectFolder.getPath());
    }

    @VisibleForTesting
    @NotNull
    Project openProject(@NotNull String path) throws Exception {
        Project project = ProjectManager.getInstance().loadAndOpenProject(path);
        if (project == null) {
            throw new Exception(String.format("The project at '%1$s' cannot be opened by this version of Android Studio", path));
        }
        return project;
    }

    public ImportApkDialogOption showImportApkDialog(@NotNull String projectName) {
        String[] options = new String[ImportApkDialogOption.values().length];
        for (ImportApkDialogOption option : ImportApkDialogOption.values()) {
            options[option.index] = option.text;
        }
        String text = String.format("Project '%1$s' already exists. If you choose to reload the APK in the existing project, your project settings will be preserved.", projectName);
        int answer = Messages.showDialog((Project)null, (String)text, (String)DIALOG_TITLE, (String[])options, (int)ImportApkDialogOption.RELOAD_EXISTING_PROJECT.index, (Icon)Messages.getQuestionIcon());
        if (answer == -1) {
            return null;
        }
        return ImportApkDialogOption.values()[answer];
    }

    public static enum ImportApkDialogOption {
        RELOAD_EXISTING_PROJECT(0, "Reload APK in Existing Project"),
        OVERWRITE_EXISTING_PROJECT(1, "Overwrite Existing Project"),
        USE_NEW_PROJECT(2, "Use New Project");

        private final int index;
        private final String text;

        private ImportApkDialogOption(int index, String text) {
            this.index = index;
            this.text = text;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

