/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.ApkFileWatcher;
import com.android.tools.idea.apk.reload.Util;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileWatcherService {
    @NotNull
    private Project myProject;
    @NotNull
    private ApkFileWatcher myWatcher;

    public FileWatcherService(@NotNull Project project) {
        this.myProject = project;
        this.myWatcher = new ApkFileWatcher();
        Disposer.register((Disposable)this.myProject, (Disposable)this.myWatcher);
    }

    public void setApkPathToWatch(@NotNull String watchedPath) {
        if (!((Boolean)StudioFlags.APK_DEBUG_RELOAD.get()).booleanValue()) {
            return;
        }
        this.myWatcher.stopWatching();
        this.myWatcher.startWatching(watchedPath, () -> this.onFileModified());
        VirtualFileManager.getInstance().refreshWithoutFileWatcher(true);
    }

    private void onFileModified() {
        final VirtualFile apkFileInProject = this.getApkFileInProject();
        assert (apkFileInProject != null);
        EditorNotifications.getInstance((Project)this.myProject).updateNotifications(apkFileInProject);
        AndroidNotification.getInstance((Project)this.myProject).showBalloon("New APK detected", "Android Studio detected that " + apkFileInProject.getName() + " has changed", NotificationType.WARNING, AndroidNotification.BALLOON_GROUP, true, new NotificationHyperlink[]{new NotificationHyperlink("reload-url", "Open APK Analyzer"){

            protected void execute(@NotNull Project project) {
                VirtualFile refreshedFile = LocalFileSystem.getInstance().findFileByPath(apkFileInProject.getPath());
                if (refreshedFile != null) {
                    OpenFileAction.openFile((VirtualFile)refreshedFile, (Project)project);
                }
            }
        }});
    }

    @Nullable
    private VirtualFile getApkFileInProject() {
        VirtualFile projectBaseDir = this.myProject.getBaseDir();
        assert (projectBaseDir != null);
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            VirtualFile file;
            ApkFacet apkFacet = ApkFacet.getInstance((Module)module);
            if (apkFacet == null || (file = LocalFileSystem.getInstance().findFileByPath(((ApkFacetConfiguration)apkFacet.getConfiguration()).APK_PATH)) == null || !Util.isFileInDir(projectBaseDir, file)) continue;
            return file;
        }
        return null;
    }
}

