/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor;

import com.android.tools.idea.apk.editor.PathMappingNode;
import com.android.tools.idea.apk.symbols.ui.FilePathCellRenderer;
import com.android.tools.idea.apk.symbols.ui.FolderPathCellEditor;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.ColumnInfo;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LocalPathColumnInfo
extends ColumnInfo<PathMappingNode, String> {
    @NotNull
    private final Project myProject;

    LocalPathColumnInfo(@NotNull Project project) {
        super("Local Paths");
        this.myProject = project;
    }

    @Nullable
    public String valueOf(@NotNull PathMappingNode node) {
        return node.getPathMapping().getSelectedPath();
    }

    public boolean isCellEditable(PathMappingNode node) {
        return true;
    }

    @Nullable
    public TableCellEditor getEditor(@NotNull PathMappingNode node) {
        return new FolderPathCellEditor(this.myProject, node.getPathMapping().getOriginalPath());
    }

    @Nullable
    public TableCellRenderer getRenderer(PathMappingNode mapping) {
        return new FilePathCellRenderer(5);
    }

    public void setValue(@NotNull PathMappingNode node, String value) {
        node.getPathMapping().setSelectedPath(value);
    }
}

