/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.setup.module;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.ApkSetupContext;
import com.android.tools.idea.apk.debugging.DebuggableSharedObjectFile;
import com.android.tools.idea.apk.debugging.LibraryFolder;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.setup.module.ApkModuleSetupStep;
import com.android.tools.idea.apk.setup.module.NativeLibraryCollector;
import com.android.tools.idea.apk.symbols.DebugSymbolNotifications;
import com.android.tools.idea.apk.symbols.DebugSymbolsUpdater;
import com.android.tools.idea.apk.symbols.SharedObjectFile;
import com.android.tools.idea.apk.symbols.SharedObjectFileFinder;
import com.android.tools.idea.project.AndroidNotification;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NativeCodeSetupStep
extends ApkModuleSetupStep {
    @NotNull
    private final NativeLibraryCollector myNativeLibraryCollector;
    @NotNull
    private final SharedObjectFileFinder mySharedObjectFileFinder;
    @NotNull
    private final DebugSymbolsUpdater myDebugSymbolsUpdater;

    public NativeCodeSetupStep() {
        this(new NativeLibraryCollector(), new SharedObjectFileFinder(), new DebugSymbolsUpdater());
    }

    @VisibleForTesting
    NativeCodeSetupStep(@NotNull NativeLibraryCollector nativeLibraryCollector, @NotNull SharedObjectFileFinder sharedObjectFileFinder, @NotNull DebugSymbolsUpdater debugSymbolsUpdater) {
        this.myNativeLibraryCollector = nativeLibraryCollector;
        this.mySharedObjectFileFinder = sharedObjectFileFinder;
        this.myDebugSymbolsUpdater = debugSymbolsUpdater;
    }

    @Override
    public void setUpModule(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ApkSetupContext context) {
        File libFolderPath = new File(context.getProjectRootFolderPath(), LibraryFolder.getName());
        if (!libFolderPath.isDirectory()) {
            return;
        }
        VirtualFile libFolder = VfsUtil.findFileByIoFile((File)libFolderPath, (boolean)true);
        assert (libFolder != null);
        ContentEntry contentEntry = context.getContentEntry();
        assert (contentEntry != null);
        contentEntry.addExcludeFolder(libFolder);
        final ApkFacet facet = context.getApkFacet();
        assert (facet != null);
        ApkFacetConfiguration configuration = (ApkFacetConfiguration)facet.getConfiguration();
        configuration.NATIVE_LIBRARIES.clear();
        final List<NativeLibrary> libraries = this.myNativeLibraryCollector.collectNativeLibraries(libFolder);
        configuration.NATIVE_LIBRARIES.addAll(libraries);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(context.getModule().getProject(), "Searching for symbols"){

            public void run(@NotNull ProgressIndicator indicator) {
                ArrayList<DebuggableSharedObjectFile> autoAddedSymbolFiles = new ArrayList<DebuggableSharedObjectFile>();
                for (NativeLibrary library : libraries) {
                    Collection soFilesFromApk = library.sharedObjectFilesByAbi.values();
                    try {
                        indicator.setIndeterminate(false);
                        List<SharedObjectFile> soFiles = NativeCodeSetupStep.this.mySharedObjectFileFinder.findSharedObjectFilesIn(soFilesFromApk.toArray(new VirtualFile[0]), library, indicator);
                        DebugSymbolsUpdater.UpdateResult result = NativeCodeSetupStep.this.myDebugSymbolsUpdater.updateDebugSymbolsInLibrary(soFiles, library, facet, indicator);
                        if (result.addedFiles.isEmpty()) continue;
                        autoAddedSymbolFiles.addAll(result.addedFiles);
                        ApplicationManager.getApplication().invokeLater(() -> DebugSymbolNotifications.getInstance().notifyLibraryUpdated(facet, library));
                    }
                    catch (IOException iOException) {}
                }
                if (!autoAddedSymbolFiles.isEmpty()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("The following files from the APK were automatically used as symbol files:").append("\n");
                    for (DebuggableSharedObjectFile file : autoAddedSymbolFiles) {
                        builder.append(file.path).append("\n");
                    }
                    AndroidNotification.getInstance((Project)this.myProject).showBalloon("Added symbol files", builder.toString(), NotificationType.INFORMATION);
                }
                ApplicationManager.getApplication().invokeLater(() -> DebugSymbolNotifications.getInstance().notifyIfDebugSymbolsAreMissing(facet, libraries));
            }
        });
    }
}

