/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.actions.AndroidStudioGradleAction;
import com.android.tools.idea.gradle.actions.LinkExternalCppProjectDialog;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkExternalCppProjectAction
extends AndroidStudioGradleAction {
    public LinkExternalCppProjectAction() {
        super("Link C++ Project with Gradle", "Link an external C/C++ project (cmake or ndk-build) with Gradle", null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    protected void doUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        DataContext dataContext = e.getDataContext();
        boolean enable = LinkExternalCppProjectAction.isValidAndroidGradleModuleSelected(dataContext) && (Boolean)StudioFlags.NPW_NEW_NATIVE_MODULE.get() == false;
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(enable);
    }

    protected void doPerform(@NotNull AnActionEvent e, @NotNull Project project) {
        DataContext dataContext = e.getDataContext();
        Module module = LinkExternalCppProjectAction.getSelectedModule(dataContext);
        assert (module != null);
        new LinkExternalCppProjectDialog(module).show();
    }

    private static boolean isValidAndroidGradleModuleSelected(@NotNull DataContext dataContext) {
        Module module = LinkExternalCppProjectAction.getSelectedModule(dataContext);
        if (module == null) {
            return false;
        }
        GradleAndroidModel androidModel = GradleAndroidModel.get((Module)module);
        if (androidModel == null) {
            return false;
        }
        NdkModuleModel ndkModuleModel = NdkModuleModel.get((Module)module);
        return ndkModuleModel == null;
    }

    @Nullable
    private static Module getSelectedModule(@NotNull DataContext dataContext) {
        Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        if (modules != null && modules.length == 1) {
            return modules[0];
        }
        return (Module)LangDataKeys.MODULE.getData(dataContext);
    }
}

