/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.configuration;

import com.android.repository.Revision;
import com.android.tools.idea.gradle.model.ndk.v1.IdeNativeFile;
import com.android.tools.idea.gradle.model.ndk.v1.IdeNativeToolchain;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.VariantAbi;
import com.android.tools.idea.ndk.ModuleVariantAbi;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.sync.NativeDataService;
import com.android.tools.ndk.sync.NativeWorkspaceClientType;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCVariant;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfoCache;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u00a8\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u000f0\u000e\u001a,\u0010\u0010\u001a\u0004\u0018\u00010\u0011\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0012\u001a\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u001a8\u0010\u0010\u001a\u0004\u0018\u00010\u0011\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0012\u001a\u00020\n2\u001e\u0010\r\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00170\u00160\u0015H\u0007\u001a\u001e\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u0019\u001a\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 \u001a\u0016\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%\u001a\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0011\u001a\u000e\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0019\u001a\u0010\u0010+\u001a\u00020,2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0019\u001a\u001c\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020\u00192\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001100\u001a\u0018\u00101\u001a\u0004\u0018\u00010'2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001100H\u0002\u001a\u001a\u00102\u001a\u0004\u0018\u00010\u0011*\b\u0012\u0004\u0012\u00020\u0011002\u0006\u00103\u001a\u00020\u0011\u001a\f\u0010:\u001a\u0004\u0018\u00010;*\u00020<\u001a.\u0010=\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u001e\u0010>\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020@0?00\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u00104\u001a\u0004\u0018\u000105*\u0002068F\u00a2\u0006\u0006\u001a\u0004\b7\u00108\"\u000e\u00109\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"CXX_CONFIGURATION_NOTIFICATION", "Lcom/intellij/notification/NotificationGroup;", "kotlin.jvm.PlatformType", "Lcom/intellij/notification/NotificationGroup;", "showMessagesBalloon", "", "K", "project", "Lcom/intellij/openapi/project/Project;", "type", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Message$Type;", "level", "Lcom/intellij/notification/NotificationType;", "messages", "Lcom/intellij/util/containers/MultiMap;", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Message;", "buildConsoleMessagesBalloonText", "", "messageType", "REMOVE_CONSOLE_COLORS_REGEX", "Lkotlin/text/Regex;", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "", "findNdkFolderFromFileInNdk", "Ljava/io/File;", "Lcom/android/repository/Revision;", "fileInNdk", "compilerExecutable", "lang", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "toolchain", "Lcom/android/tools/idea/gradle/model/ndk/v1/IdeNativeToolchain;", "workingDirectory", "model", "Lcom/android/tools/idea/gradle/project/model/NdkModuleModel;", "nativeFile", "Lcom/android/tools/idea/gradle/model/ndk/v1/IdeNativeFile;", "cxxLanguageKindFromExtension", "Lcom/jetbrains/cidr/lang/CLanguageKind;", "extension", "cxxLanguageKindFromFile", "file", "cxxCompilerKindFromExeFilename", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "cxxLanguageKind", "sourceFile", "switches", "", "cxxLanguageKindFromSwitches", "getSwitchValueOrNull", "switchName", "moduleVariantAbi", "Lcom/android/tools/idea/ndk/ModuleVariantAbi;", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "getModuleVariantAbi", "(Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;)Lcom/android/tools/idea/ndk/ModuleVariantAbi;", "abiRegex", "toVariantAbi", "Lcom/android/tools/idea/gradle/project/model/VariantAbi;", "Lcom/jetbrains/cidr/lang/workspace/OCVariant;", "establishResolveConfigurationDefaults", "exemplars", "Lkotlin/Triple;", "Lcom/intellij/openapi/vfs/VirtualFile;", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nCxxSyncUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CxxSyncUtils.kt\ncom/android/tools/ndk/configuration/CxxSyncUtilsKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,338:1\n607#2:339\n2642#3:340\n2642#3:342\n1557#3:344\n1628#3,3:345\n774#3:348\n865#3,2:349\n1557#3:351\n1628#3,3:352\n1557#3:355\n1628#3,3:356\n1863#3,2:359\n1#4:341\n1#4:343\n*S KotlinDebug\n*F\n+ 1 CxxSyncUtils.kt\ncom/android/tools/ndk/configuration/CxxSyncUtilsKt\n*L\n92#1:339\n129#1:340\n131#1:342\n299#1:344\n299#1:345,3\n99#1:348\n99#1:349,2\n107#1:351\n107#1:352,3\n120#1:355\n120#1:356,3\n312#1:359,2\n129#1:341\n131#1:343\n*E\n"})
public final class CxxSyncUtilsKt {
    private static final NotificationGroup CXX_CONFIGURATION_NOTIFICATION = NotificationGroupManager.getInstance().getNotificationGroup("Resolve C/C++ Configurations");
    @NotNull
    private static final Regex REMOVE_CONSOLE_COLORS_REGEX = new Regex("\u001b?\\[\\d[;\\d]*[ -/]*[@-~]");
    @NotNull
    private static final Regex abiRegex = new Regex("([-a-z_0-9]+)( \\(\\d+\\))?");

    public static final <K> void showMessagesBalloon(@NotNull Project project, @NotNull CompilerInfoCache.Message.Type type, @NotNull NotificationType level, @NotNull MultiMap<K, CompilerInfoCache.Message> messages) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        String message = CxxSyncUtilsKt.buildConsoleMessagesBalloonText(type, messages);
        if (message != null) {
            CXX_CONFIGURATION_NOTIFICATION.createNotification("C/C++ Configuration Problem", message, level).notify(project);
        }
    }

    private static final <K> String buildConsoleMessagesBalloonText(CompilerInfoCache.Message.Type messageType, MultiMap<K, CompilerInfoCache.Message> messages) {
        Set set = messages.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
        return CxxSyncUtilsKt.buildConsoleMessagesBalloonText(messageType, SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), CxxSyncUtilsKt::buildConsoleMessagesBalloonText$lambda$0));
    }

    @VisibleForTesting
    @Nullable
    public static final <K> String buildConsoleMessagesBalloonText(@NotNull CompilerInfoCache.Message.Type messageType, @NotNull Sequence<? extends Pair<? extends K, ? extends Collection<? extends CompilerInfoCache.Message>>> messages) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)messageType, (String)"messageType");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Sequence<? extends Pair<? extends K, ? extends Collection<? extends CompilerInfoCache.Message>>> $this$sortedBy$iv = messages;
        boolean $i$f$sortedBy = false;
        Sequence sortedByKey = SequencesKt.sortedWith($this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)String.valueOf(it.getFirst()));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)String.valueOf(it.getFirst()))));
            }
        });
        Sequence filteredByType = SequencesKt.map((Sequence)sortedByKey, arg_0 -> CxxSyncUtilsKt.buildConsoleMessagesBalloonText$lambda$3(messageType, arg_0));
        Sequence emptyGroupsRemoved = SequencesKt.filter((Sequence)filteredByType, CxxSyncUtilsKt::buildConsoleMessagesBalloonText$lambda$4);
        Sequence textMessages = SequencesKt.map((Sequence)emptyGroupsRemoved, CxxSyncUtilsKt::buildConsoleMessagesBalloonText$lambda$6);
        Sequence distinctMessages = SequencesKt.map((Sequence)textMessages, CxxSyncUtilsKt::buildConsoleMessagesBalloonText$lambda$7);
        Sequence consoleColorsRemoved = SequencesKt.map((Sequence)distinctMessages, CxxSyncUtilsKt::buildConsoleMessagesBalloonText$lambda$9);
        List finalMessages = SequencesKt.toList((Sequence)consoleColorsRemoved);
        if (finalMessages.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterable $this$onEach$iv = finalMessages;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2419$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2419$iv) {
            Iterable iterable2;
            Pair pair = (Pair)element$iv;
            boolean bl2 = false;
            Object key = pair.component1();
            List lines = (List)pair.component2();
            sb.append("<b>" + key + "</b><br/>");
            Iterable $this$onEach$iv2 = lines;
            boolean $i$f$onEach2 = false;
            Iterable $this$onEach_u24lambda_u2419$iv2 = iterable2 = $this$onEach$iv2;
            $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv = false;
            for (Object element$iv2 : $this$onEach_u24lambda_u2419$iv2) {
                String line = (String)element$iv2;
                boolean bl3 = false;
                sb.append(line + "<br/>");
            }
        }
        return sb.toString();
    }

    @Nullable
    public static final Pair<File, Revision> findNdkFolderFromFileInNdk(@Nullable File fileInNdk) {
        for (File current = fileInNdk; current != null; current = current.getParentFile()) {
            if (!new File(current, "source.properties").isFile() && !new File(current, "RELEASE.TXT").isFile()) continue;
            try {
                Revision version = Revision.parseRevision((String)NdkHelper.getNdkVersion(current));
                return new Pair((Object)current, (Object)version);
            }
            catch (Exception e) {
                Logger.getInstance(NativeDataService.class).warn("Failed to detect NDK root and version from file " + fileInNdk + ".", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static final File compilerExecutable(@NotNull OCLanguageKind lang, @NotNull IdeNativeToolchain toolchain) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Intrinsics.checkNotNullParameter((Object)toolchain, (String)"toolchain");
        return lang == CLanguageKind.C ? toolchain.getCCompilerExecutable() : toolchain.getCppCompilerExecutable();
    }

    @NotNull
    public static final File workingDirectory(@NotNull NdkModuleModel model, @NotNull IdeNativeFile nativeFile) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)nativeFile, (String)"nativeFile");
        if (model.getFeatures().isWorkingDirectorySupported()) {
            File file = nativeFile.getWorkingDirectory();
            if (file == null) {
                file = model.getRootDirPath();
            }
            return file;
        }
        return model.getRootDirPath();
    }

    @NotNull
    public static final CLanguageKind cxxLanguageKindFromExtension(@NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        String string = extension;
        return Intrinsics.areEqual((Object)string, (Object)"c") || Intrinsics.areEqual((Object)string, (Object)"C") ? CLanguageKind.C : CLanguageKind.CPP;
    }

    @NotNull
    public static final CLanguageKind cxxLanguageKindFromFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return CxxSyncUtilsKt.cxxLanguageKindFromExtension(FilesKt.getExtension((File)file));
    }

    @NotNull
    public static final OCCompilerKind cxxCompilerKindFromExeFilename(@Nullable File compilerExecutable) {
        block4: {
            block7: {
                block6: {
                    block5: {
                        if (compilerExecutable == null) break block4;
                        String string = compilerExecutable.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        if (StringsKt.endsWith$default((String)string, (String)"clang++", (boolean)false, (int)2, null)) break block5;
                        String string2 = compilerExecutable.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        if (StringsKt.endsWith$default((String)string2, (String)"clang", (boolean)false, (int)2, null)) break block5;
                        String string3 = compilerExecutable.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                        if (!StringsKt.endsWith$default((String)string3, (String)"clang.exe", (boolean)false, (int)2, null)) break block6;
                    }
                    return (OCCompilerKind)ClangCompilerKind.INSTANCE;
                }
                String string = compilerExecutable.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (StringsKt.endsWith$default((String)string, (String)"gcc", (boolean)false, (int)2, null)) break block7;
                String string4 = compilerExecutable.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string4, (String)"gcc.exe", (boolean)false, (int)2, null)) break block4;
            }
            return (OCCompilerKind)GCCCompilerKind.INSTANCE;
        }
        return (OCCompilerKind)UnknownCompilerKind.INSTANCE;
    }

    @NotNull
    public static final CLanguageKind cxxLanguageKind(@NotNull File sourceFile, @NotNull List<String> switches) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter(switches, (String)"switches");
        CLanguageKind cLanguageKind = CxxSyncUtilsKt.cxxLanguageKindFromSwitches(switches);
        if (cLanguageKind == null) {
            cLanguageKind = CxxSyncUtilsKt.cxxLanguageKindFromExtension(FilesKt.getExtension((File)sourceFile));
        }
        return cLanguageKind;
    }

    /*
     * Unable to fully structure code
     */
    private static final CLanguageKind cxxLanguageKindFromSwitches(List<String> switches) {
        block24: {
            v0 = CxxSyncUtilsKt.getSwitchValueOrNull(switches, "-std");
            if (v0 == null) {
                return null;
            }
            std = v0;
            switch (std.hashCode()) {
                case 92752486: {
                    if (!std.equals("c++14")) {
                        break;
                    }
                    ** GOTO lbl48
                }
                case 92752483: {
                    if (!std.equals("c++11")) {
                        break;
                    }
                    ** GOTO lbl48
                }
                case 182181182: {
                    if (!std.equals("gnu++2b")) {
                        break;
                    }
                    ** GOTO lbl48
                }
                case 182181102: {
                    if (!std.equals("gnu++11")) {
                        break;
                    }
                    ** GOTO lbl48
                }
                case 92752562: {
                    if (!std.equals("c++2a")) {
                        break;
                    }
                    ** GOTO lbl48
                }
                case 92752738: {
                    if (!std.equals("c++98")) {
                        break;
                    }
                    ** GOTO lbl48
                }
                case 182181181: {
                    if (!std.equals("gnu++2a")) {
                        break;
                    }
                    ** GOTO lbl48
                }
                case 92752513: {
                    if (!std.equals("c++20")) {
                        break;
                    }
                    ** GOTO lbl48
                }
                case 182181132: {
                    if (!std.equals("gnu++20")) {
                        break;
                    }
                    ** GOTO lbl48
                }
                case 92752489: {
                    if (!std.equals("c++17")) {
                        break;
                    }
                    ** GOTO lbl48
                }
                case 182181108: {
                    if (!std.equals("gnu++17")) break;
lbl48:
                    // 11 sources

                    v1 = CLanguageKind.CPP;
                    break block24;
                }
            }
            v1 = StringsKt.contains$default((CharSequence)std, (CharSequence)"++", (boolean)false, (int)2, null) != false ? CLanguageKind.CPP : CLanguageKind.C;
        }
        return v1;
    }

    @Nullable
    public static final String getSwitchValueOrNull(@NotNull List<String> $this$getSwitchValueOrNull, @NotNull String switchName) {
        Intrinsics.checkNotNullParameter($this$getSwitchValueOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)switchName, (String)"switchName");
        boolean takeNext = false;
        String result = null;
        for (String value : $this$getSwitchValueOrNull) {
            if (takeNext) {
                result = value;
                takeNext = false;
                continue;
            }
            if (Intrinsics.areEqual((Object)value, (Object)switchName)) {
                takeNext = true;
                continue;
            }
            if (!StringsKt.startsWith$default((String)value, (String)(switchName + "="), (boolean)false, (int)2, null)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)value.substring(switchName.length() + 1), (String)"substring(...)");
        }
        return result;
    }

    @Nullable
    public static final ModuleVariantAbi getModuleVariantAbi(@NotNull OCResolveConfiguration $this$moduleVariantAbi) {
        Intrinsics.checkNotNullParameter((Object)$this$moduleVariantAbi, (String)"<this>");
        OCVariant oCVariant = $this$moduleVariantAbi.getVariant();
        if (oCVariant == null || (oCVariant = CxxSyncUtilsKt.toVariantAbi(oCVariant)) == null) {
            return null;
        }
        OCVariant oCVariant2 = oCVariant;
        String variant = oCVariant2.component1();
        String abi = oCVariant2.component2();
        String string = $this$moduleVariantAbi.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new ModuleVariantAbi(string, variant, abi);
    }

    @Nullable
    public static final VariantAbi toVariantAbi(@NotNull OCVariant $this$toVariantAbi) {
        Intrinsics.checkNotNullParameter((Object)$this$toVariantAbi, (String)"<this>");
        if ($this$toVariantAbi.getParts().size() != 2) {
            return null;
        }
        List list = $this$toVariantAbi.getParts();
        String variant = (String)list.get(0);
        String abiWithDifferentiator = (String)list.get(1);
        MatchResult matchResult = abiRegex.matchEntire((CharSequence)abiWithDifferentiator);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        return new VariantAbi(variant, (String)match.getGroupValues().get(1));
    }

    /*
     * WARNING - void declaration
     */
    public static final void establishResolveConfigurationDefaults(@NotNull Project project, @NotNull List<? extends Triple<String, ? extends OCLanguageKind, ? extends VirtualFile>> exemplars) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(exemplars, (String)"exemplars");
        boolean bl = false;
        OCWorkspace oCWorkspace = OCWorkspace.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)oCWorkspace, (String)"getInstance(...)");
        OCWorkspace readonly = oCWorkspace;
        Iterable $this$map$iv = exemplars;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            OCCompilerSettings settings;
            OCResolveConfiguration readOnlyConfiguration;
            Triple triple = (Triple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String key = (String)triple.component1();
            OCLanguageKind languageKind = (OCLanguageKind)triple.component2();
            VirtualFile sourceUrl = (VirtualFile)triple.component3();
            Intrinsics.checkNotNull((Object)readonly.getConfigurationById(key));
            Intrinsics.checkNotNullExpressionValue((Object)readOnlyConfiguration.getCompilerSettings(languageKind, sourceUrl), (String)"getCompilerSettings(...)");
            collection.add(new Triple((Object)readOnlyConfiguration, (Object)languageKind, (Object)settings));
        }
        List readonlySettings = (List)destination$iv$iv;
        ApplicationManager.getApplication().executeOnPooledThread(() -> CxxSyncUtilsKt.establishResolveConfigurationDefaults$lambda$18(project, readonlySettings));
    }

    private static final Pair buildConsoleMessagesBalloonText$lambda$0(Map.Entry it) {
        return new Pair(it.getKey(), it.getValue());
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair buildConsoleMessagesBalloonText$lambda$3(CompilerInfoCache.Message.Type $messageType, Pair it) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable iterable = (Iterable)it.getSecond();
        Object object = it.getFirst();
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CompilerInfoCache.Message message = (CompilerInfoCache.Message)element$iv$iv;
            boolean bl = false;
            if (!(message.type == $messageType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Object object2 = object;
        return new Pair(object2, (Object)list);
    }

    private static final boolean buildConsoleMessagesBalloonText$lambda$4(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !((Collection)it.getSecond()).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair buildConsoleMessagesBalloonText$lambda$6(Pair it) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable iterable = (Iterable)it.getSecond();
        Object object = it.getFirst();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void message;
            CompilerInfoCache.Message message2 = (CompilerInfoCache.Message)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(message.text);
        }
        List list = (List)destination$iv$iv;
        Object object2 = object;
        return new Pair(object2, (Object)list);
    }

    private static final Pair buildConsoleMessagesBalloonText$lambda$7(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Pair(it.getFirst(), (Object)CollectionsKt.distinct((Iterable)((Iterable)it.getSecond())));
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair buildConsoleMessagesBalloonText$lambda$9(Pair it) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable iterable = (Iterable)it.getSecond();
        Object object = it.getFirst();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void text;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)text);
            CharSequence charSequence = (CharSequence)text;
            Regex regex = REMOVE_CONSOLE_COLORS_REGEX;
            String string2 = "";
            collection.add(regex.replace(charSequence, string2));
        }
        List list = (List)destination$iv$iv;
        Object object2 = object;
        return new Pair(object2, (Object)list);
    }

    private static final void establishResolveConfigurationDefaults$lambda$18$lambda$17$lambda$16(OCWorkspace.ModifiableModel $workspace) {
        $workspace.commit();
    }

    private static final void establishResolveConfigurationDefaults$lambda$18$lambda$17(OCWorkspace.ModifiableModel $workspace) {
        WriteAction.run(() -> CxxSyncUtilsKt.establishResolveConfigurationDefaults$lambda$18$lambda$17$lambda$16($workspace));
    }

    private static final void establishResolveConfigurationDefaults$lambda$18(Project $project, List $readonlySettings) {
        OCWorkspace.ModifiableModel modifiableModel = OCWorkspace.getInstance((Project)$project).getModifiableModel(NativeWorkspaceClientType.ANDROID_STUDIO.getCidrClientKey(), false);
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"getModifiableModel(...)");
        OCWorkspace.ModifiableModel workspace = modifiableModel;
        Iterable $this$forEach$iv = $readonlySettings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OCResolveConfiguration.ModifiableModel configuration;
            OCCompilerSettings.ModifiableModel modifiableModel2;
            Triple triple = (Triple)element$iv;
            boolean bl = false;
            OCResolveConfiguration readOnlyConfiguration = (OCResolveConfiguration)triple.component1();
            OCLanguageKind languageKind = (OCLanguageKind)triple.component2();
            OCCompilerSettings settings = (OCCompilerSettings)triple.component3();
            if (workspace.getConfigurationById(readOnlyConfiguration.getUniqueId()) == null) continue;
            OCCompilerSettings.ModifiableModel $this$establishResolveConfigurationDefaults_u24lambda_u2418_u24lambda_u2415_u24lambda_u2414 = modifiableModel2 = configuration.getLanguageCompilerSettings(languageKind);
            boolean bl2 = false;
            $this$establishResolveConfigurationDefaults_u24lambda_u2418_u24lambda_u2415_u24lambda_u2414.setCompiler(settings.getCompilerKind(), settings.getCompilerExecutable(), settings.getCompilerWorkingDir());
            $this$establishResolveConfigurationDefaults_u24lambda_u2418_u24lambda_u2415_u24lambda_u2414.setCompilerSwitches(settings.getCompilerSwitches());
            $this$establishResolveConfigurationDefaults_u24lambda_u2418_u24lambda_u2415_u24lambda_u2414.setImplicitIncludes(settings.getImplicitIncludes());
            $this$establishResolveConfigurationDefaults_u24lambda_u2418_u24lambda_u2415_u24lambda_u2414.setCompilerFeatures(settings.getCompilerFeatures());
            $this$establishResolveConfigurationDefaults_u24lambda_u2418_u24lambda_u2415_u24lambda_u2414.setPreprocessorDefines(settings.getPreprocessorDefines());
            $this$establishResolveConfigurationDefaults_u24lambda_u2418_u24lambda_u2415_u24lambda_u2414.setHeadersSearchPaths(settings.getHeadersSearchPaths());
        }
        workspace.preCommit();
        ApplicationManager.getApplication().invokeLater(() -> CxxSyncUtilsKt.establishResolveConfigurationDefaults$lambda$18$lambda$17(workspace));
    }
}

