/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.editors;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystem;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewCppSourceNotificationProvider
implements EditorNotificationProvider {
    @Nullable
    public Function<FileEditor, EditorNotificationPanel> collectNotificationData(@NotNull Project myProject, @NotNull VirtualFile file) {
        if (!(ProjectSystemUtil.getProjectSystem((Project)myProject) instanceof GradleProjectSystem)) {
            return null;
        }
        if (OCWorkspace.getInstance((Project)myProject).getConfigurations().isEmpty()) {
            return null;
        }
        if (file.getFileType() != OCFileType.INSTANCE) {
            return null;
        }
        if (OCFileTypeHelpers.isHeaderFile((String)file.getName())) {
            return null;
        }
        if (ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)myProject) == null) {
            return null;
        }
        if (OCWorkspace.getInstance((Project)myProject).getConfigurationsForFile(file).isEmpty()) {
            return fileEditor -> new StaleCppProjectNotificationPanel(myProject, "This file is not part of the project. Please include it in the appropriate build file (build.gradle, CMakeLists.txt or Android.mk etc.) and sync the project.");
        }
        return null;
    }

    private static class StaleCppProjectNotificationPanel
    extends EditorNotificationPanel {
        StaleCppProjectNotificationPanel(Project myProject, String message) {
            this.setText(message);
            this.createActionLabel("Sync Now", () -> GradleSyncInvoker.getInstance().requestProjectSync(myProject, new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_CPP_EXTERNAL_PROJECT_LINKED), null));
        }
    }
}

