/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.cosmetics;

import com.android.tools.ndk.jni.model.JniNativeMethodId;
import com.android.tools.ndk.jni.service.JniEditorSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCLanguageUtilsBase;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J+\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/ndk/jni/cosmetics/JniMangledFunctionNameFoldingBuilder;", "Lcom/intellij/lang/folding/FoldingBuilderEx;", "<init>", "()V", "getPlaceholderText", "", "node", "Lcom/intellij/lang/ASTNode;", "buildFoldRegions", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Document;Z)[Lcom/intellij/lang/folding/FoldingDescriptor;", "isCollapsedByDefault", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniMangledFunctionNameFoldingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniMangledFunctionNameFoldingBuilder.kt\ncom/android/tools/ndk/jni/cosmetics/JniMangledFunctionNameFoldingBuilder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,60:1\n37#2,2:61\n*S KotlinDebug\n*F\n+ 1 JniMangledFunctionNameFoldingBuilder.kt\ncom/android/tools/ndk/jni/cosmetics/JniMangledFunctionNameFoldingBuilder\n*L\n55#1:61,2\n*E\n"})
public final class JniMangledFunctionNameFoldingBuilder
extends FoldingBuilderEx {
    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        String string;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String string2 = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        JniNativeMethodId jniNativeMethodId = JniNativeMethodId.Companion.fromJniMethodName(string2);
        if (jniNativeMethodId != null) {
            JniNativeMethodId $this$getPlaceholderText_u24lambda_u240 = jniNativeMethodId;
            boolean bl = false;
            string = $this$getPlaceholderText_u24lambda_u240.getClassName().getShortName() + "." + $this$getPlaceholderText_u24lambda_u240.getMethodName();
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (OCLanguageUtilsBase.isCppSupportDisabled((Project)root.getProject())) {
            return new FoldingDescriptor[0];
        }
        if (!(root instanceof OCFile)) {
            return new FoldingDescriptor[0];
        }
        if (!FileSymbolTablesCache.areSymbolsLoaded((Project)((OCFile)root).getProject())) {
            return new FoldingDescriptor[0];
        }
        List result = new ArrayList();
        ((OCFile)root).processSymbolsRecursively(arg_0 -> JniMangledFunctionNameFoldingBuilder.buildFoldRegions$lambda$1(root, result, arg_0));
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new FoldingDescriptor[0]);
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return JniEditorSettings.Companion.getInstance().getFoldJniMangledFunctionName();
    }

    private static final boolean buildFoldRegions$lambda$1(PsiElement $root, List $result, OCSymbol it) {
        if (it instanceof OCFunctionSymbol) {
            String string = ((OCFunctionSymbol)it).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (JniNativeMethodId.Companion.fromJniMethodName(string) == null) {
                return true;
            }
            PsiElement psiElement = ((OCFunctionSymbol)it).locateDefinition(((OCFile)$root).getProject());
            OCDeclarator oCDeclarator = psiElement instanceof OCDeclarator ? (OCDeclarator)psiElement : null;
            if (oCDeclarator == null || (oCDeclarator = oCDeclarator.getIdentifyingElement()) == null) {
                return true;
            }
            OCDeclarator ocFunctionIdentifier = oCDeclarator;
            TextRange textRange = ocFunctionIdentifier.getTextRange();
            if (!textRange.isEmpty()) {
                $result.add(new FoldingDescriptor((PsiElement)ocFunctionIdentifier, textRange));
            }
        }
        return true;
    }
}

