/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.InspectionUtilsKt;
import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.model.CallMethodCall;
import com.android.tools.ndk.jni.model.JniCall;
import com.android.tools.ndk.jni.model.JniCallKt;
import com.android.tools.ndk.jni.model.JvmMethodCall;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.JvmPrimitiveType;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.service.JniInfoInferencer;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010\u000f\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/ndk/jni/inspections/JniCallMethodInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "inspectReceiver", "", "Lcom/android/tools/ndk/jni/service/JniInfoInferencer;", "call", "Lcom/android/tools/ndk/jni/model/CallMethodCall;", "inspectVariation", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniCallMethodInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniCallMethodInspection.kt\ncom/android/tools/ndk/jni/inspections/JniCallMethodInspection\n+ 2 JniInspectionTool.kt\ncom/android/tools/ndk/jni/inspections/JniInspectionTool\n*L\n1#1,59:1\n51#2,9:60\n*S KotlinDebug\n*F\n+ 1 JniCallMethodInspection.kt\ncom/android/tools/ndk/jni/inspections/JniCallMethodInspection\n*L\n36#1:60,9\n*E\n"})
public final class JniCallMethodInspection
extends JniInspectionTool {
    public JniCallMethodInspection() {
        super(JniInspectionEvent.JniInspectionType.CALL_METHOD_INSPECTION_EVENT);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        JniInspectionTool this_$iv = this;
        boolean $i$f$visitJniCall$android_ndk = false;
        return (PsiElementVisitor)new OCVisitor(this_$iv, this, holder){
            final /* synthetic */ JniInspectionTool this$0$inline_fun;
            final /* synthetic */ JniCallMethodInspection this$0;
            final /* synthetic */ ProblemsHolder $holder$inlined;
            {
                this.this$0$inline_fun = $receiver;
                this.this$0 = jniCallMethodInspection;
                this.$holder$inlined = problemsHolder;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitCallExpression(OCCallExpression expression) {
                void inspectionType$iv$iv;
                void $this$reportJniPerf$iv$iv;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                JniCall jniCall = JniCallKt.toJniCall(expression);
                if (!(jniCall instanceof CallMethodCall)) {
                    jniCall = null;
                }
                JniCall jniCall2 = (CallMethodCall)jniCall;
                if (jniCall2 == null) {
                    return;
                }
                JniCall call = jniCall2;
                JniInspectionTool this_$iv = this.this$0$inline_fun;
                boolean $i$f$reportPerf$android_ndk = false;
                Project project = ((PsiElement)expression).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p(this_$iv);
                int n = 100;
                boolean $i$f$reportJniPerf = false;
                JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                Instant startTime$iv$iv = Instant.now();
                try {
                    void call2;
                    JniUsageEventReporter $this$reportPerf_u24lambda_u240$iv = reporter$iv$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    Project project3 = expression.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                    JniInfoInferencer inferencer = JniInfoInferencer.Companion.getInstance(project3);
                    CallMethodCall callMethodCall = (CallMethodCall)call;
                    JniInfoInferencer $this$buildVisitor_u24lambda_u240 = inferencer;
                    boolean bl3 = false;
                    JniCallMethodInspection.access$inspectReceiver(this.this$0, $this$buildVisitor_u24lambda_u240, (CallMethodCall)call2, this.$holder$inlined);
                    InspectionUtilsKt.inspectCallArgs($this$buildVisitor_u24lambda_u240, (JvmMethodCall)call2, this.$holder$inlined);
                    JniCallMethodInspection.access$inspectVariation(this.this$0, $this$buildVisitor_u24lambda_u240, (CallMethodCall)call2, this.$holder$inlined);
                }
                finally {
                    void inverseSampleRate$iv$iv;
                    if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv$iv) == 0) {
                        Instant endTime$iv$iv = Instant.now();
                        JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, endTime$iv$iv).toMillis())));
                    }
                }
            }
        };
    }

    private final void inspectReceiver(JniInfoInferencer $this$inspectReceiver, CallMethodCall call, ProblemsHolder holder) {
        JvmMethodInfo jvmMethodInfo = $this$inspectReceiver.inferMethodInfo(call.getMethodIdExpression());
        if (jvmMethodInfo == null) {
            return;
        }
        JvmMethodInfo methodInfo = jvmMethodInfo;
        InspectionUtilsKt.inspectReceiverForMemberAccess$default($this$inspectReceiver, holder, call.getReceiverExpression(), methodInfo.isStatic(), methodInfo.getClassName(), "method '" + methodInfo.getDescription() + "' declared in class '" + methodInfo.getClassName().getShortName() + "'", false, 32, null);
    }

    private final void inspectVariation(JniInfoInferencer $this$inspectVariation, CallMethodCall call, ProblemsHolder holder) {
        JvmMethodInfo jvmMethodInfo = $this$inspectVariation.inferMethodInfo(call.getMethodIdExpression());
        if (jvmMethodInfo == null) {
            return;
        }
        JvmMethodInfo methodInfo = jvmMethodInfo;
        JvmType jvmType = methodInfo.getReturnType();
        JvmPrimitiveType expectedType = jvmType instanceof JvmPrimitiveType ? (JvmPrimitiveType)jvmType : null;
        InspectionUtilsKt.inspectVariation(this, holder, (JniCall)call, expectedType, "method '" + methodInfo.getReturnType().toShortJavaType() + " " + methodInfo.getDescription() + "'", methodInfo.isStatic());
    }

    public static final /* synthetic */ void access$inspectReceiver(JniCallMethodInspection $this, JniInfoInferencer $receiver, CallMethodCall call, ProblemsHolder holder) {
        $this.inspectReceiver($receiver, call, holder);
    }

    public static final /* synthetic */ void access$inspectVariation(JniCallMethodInspection $this, JniInfoInferencer $receiver, CallMethodCall call, ProblemsHolder holder) {
        $this.inspectVariation($receiver, call, holder);
    }
}

