/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.InspectionUtilsKt;
import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.inspections.JniLocalQuickFix;
import com.android.tools.ndk.jni.model.FindClassCall;
import com.android.tools.ndk.jni.model.JniCall;
import com.android.tools.ndk.jni.model.JniCallKt;
import com.android.tools.ndk.jni.model.JvmArrayType;
import com.android.tools.ndk.jni.model.JvmObjectType;
import com.android.tools.ndk.jni.model.JvmPrimitiveType;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.service.JniInfoInferencer;
import com.android.tools.ndk.jni.service.JniInfoInferencerKt;
import com.android.tools.ndk.jni.utils.DataSource;
import com.android.tools.ndk.jni.utils.DataSourceKt;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.android.tools.ndk.jni.utils.StringDataSource;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.cidr.lang.OCLanguageUtilsBase;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\u00020\u000b*\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/ndk/jni/inspections/JniFindClassInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "toProperFindClassArgument", "", "Lcom/android/tools/ndk/jni/model/JvmType;", "insideArray", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniFindClassInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniFindClassInspection.kt\ncom/android/tools/ndk/jni/inspections/JniFindClassInspection\n+ 2 JniInspectionTool.kt\ncom/android/tools/ndk/jni/inspections/JniInspectionTool\n*L\n1#1,97:1\n51#2,9:98\n*S KotlinDebug\n*F\n+ 1 JniFindClassInspection.kt\ncom/android/tools/ndk/jni/inspections/JniFindClassInspection\n*L\n42#1:98,9\n*E\n"})
public final class JniFindClassInspection
extends JniInspectionTool {
    public JniFindClassInspection() {
        super(JniInspectionEvent.JniInspectionType.FIND_CLASS_INSPECTION_EVENT);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (OCLanguageUtilsBase.isCppSupportDisabled((Project)holder.getProject())) {
            return new PsiElementVisitor(){};
        }
        JniInspectionTool this_$iv = this;
        boolean $i$f$visitJniCall$android_ndk = false;
        return (PsiElementVisitor)new OCVisitor(this_$iv, holder, this){
            final /* synthetic */ JniInspectionTool this$0$inline_fun;
            final /* synthetic */ ProblemsHolder $holder$inlined;
            final /* synthetic */ JniFindClassInspection this$0;
            {
                this.this$0$inline_fun = $receiver;
                this.$holder$inlined = problemsHolder;
                this.this$0 = jniFindClassInspection;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitCallExpression(OCCallExpression expression) {
                void inspectionType$iv$iv;
                void $this$reportJniPerf$iv$iv;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                JniCall jniCall = JniCallKt.toJniCall(expression);
                if (!(jniCall instanceof FindClassCall)) {
                    jniCall = null;
                }
                JniCall jniCall2 = (FindClassCall)jniCall;
                if (jniCall2 == null) {
                    return;
                }
                JniCall call = jniCall2;
                JniInspectionTool this_$iv = this.this$0$inline_fun;
                boolean $i$f$reportPerf$android_ndk = false;
                Project project = ((PsiElement)expression).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p(this_$iv);
                int n = 100;
                boolean $i$f$reportJniPerf = false;
                JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                Instant startTime$iv$iv = Instant.now();
                try {
                    void call2;
                    OCExpression classNameExpression;
                    JniUsageEventReporter $this$reportPerf_u24lambda_u240$iv = reporter$iv$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    Project project3 = expression.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                    JniInfoInferencer inferencer = JniInfoInferencer.Companion.getInstance(project3);
                    FindClassCall findClassCall = (FindClassCall)call;
                    JniInfoInferencer $this$buildVisitor_u24lambda_u240 = inferencer;
                    boolean bl3 = false;
                    OCExpression oCExpression = classNameExpression = call2.getClassNameExpression();
                    DataSource dataSource = oCExpression != null ? DataSourceKt.getDataSource((OCElement)oCExpression) : null;
                    StringDataSource stringDataSource = dataSource instanceof StringDataSource ? (StringDataSource)dataSource : null;
                    if (stringDataSource == null) {
                    } else {
                        ProblemHighlightType problemType;
                        StringDataSource classNameDataSource = stringDataSource;
                        JvmType classType = JniInfoInferencerKt.toJvmTypeAsClassName(classNameDataSource.getString());
                        ProblemHighlightType problemHighlightType = problemType = classNameExpression instanceof OCLiteralExpression ? ProblemHighlightType.ERROR : ProblemHighlightType.GENERIC_ERROR;
                        if (classType == null || classType instanceof JvmPrimitiveType) {
                            InspectionUtilsKt.registerOcProblem(this.$holder$inlined, (PsiElement)classNameExpression, "'" + classNameDataSource.getString() + "' is not a valid class name.", problemType, new JniLocalQuickFix[0]);
                        } else {
                            JvmType baseType = JniFindClassInspection.access$buildVisitor$lambda$0$getBaseType(classType);
                            if (!(baseType instanceof JvmPrimitiveType) && JniInfoInferencer.findPsiClass$default($this$buildVisitor_u24lambda_u240, baseType, false, 1, null) == null) {
                                InspectionUtilsKt.registerOcProblem(this.$holder$inlined, (PsiElement)classNameExpression, "Cannot find class '" + classNameDataSource.getString() + "' in project.", problemType, new JniLocalQuickFix[0]);
                            } else {
                                String properFindClassArg = JniFindClassInspection.toProperFindClassArgument$default(this.this$0, classType, false, 1, null);
                                if (!Intrinsics.areEqual((Object)properFindClassArg, (Object)classNameDataSource.getString())) {
                                    JniLocalQuickFix[] jniLocalQuickFixArray = new JniLocalQuickFix[]{this.this$0.quickFix("Fix JNI FindClass argument format", "Replace '" + properFindClassArg + "'", (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)new Function2<Project, ProblemDescriptor, Boolean>(properFindClassArg){
                                        final /* synthetic */ String $properFindClassArg;
                                        {
                                            this.$properFindClassArg = $properFindClassArg;
                                        }

                                        public final Boolean invoke(Project project, ProblemDescriptor descriptor) {
                                            Intrinsics.checkNotNullParameter((Object)project, (String)"<unused var>");
                                            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                                            String[] stringArray = new String[]{JniUtilsKt.quoted(this.$properFindClassArg)};
                                            return InspectionUtilsKt.replaceAtHighlighted(descriptor, stringArray);
                                        }
                                    }))};
                                    InspectionUtilsKt.registerOcProblem(this.$holder$inlined, (PsiElement)classNameExpression, "'" + classNameDataSource.getString() + "' is not a valid way to specify class name.", ProblemHighlightType.GENERIC_ERROR, jniLocalQuickFixArray);
                                }
                            }
                        }
                    }
                }
                finally {
                    void inverseSampleRate$iv$iv;
                    if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv$iv) == 0) {
                        Instant endTime$iv$iv = Instant.now();
                        JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, endTime$iv$iv).toMillis())));
                    }
                }
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String toProperFindClassArgument(JvmType $this$toProperFindClassArgument, boolean insideArray) {
        Object object;
        JvmType jvmType = $this$toProperFindClassArgument;
        if (jvmType instanceof JvmPrimitiveType) {
            if (!insideArray) throw new AssertionError((Object)"impossible since previous logic has eliminated this code path");
            object = ((JvmPrimitiveType)$this$toProperFindClassArgument).toJvmType();
            return object;
        } else if (jvmType instanceof JvmArrayType) {
            object = "[" + this.toProperFindClassArgument(((JvmArrayType)$this$toProperFindClassArgument).getType(), true);
            return object;
        } else {
            if (!(jvmType instanceof JvmObjectType)) throw new NoWhenBranchMatchedException();
            object = insideArray ? "L" + ((JvmObjectType)$this$toProperFindClassArgument).getName().getJvm() + ";" : ((JvmObjectType)$this$toProperFindClassArgument).getName().getJvm();
        }
        return object;
    }

    static /* synthetic */ String toProperFindClassArgument$default(JniFindClassInspection jniFindClassInspection, JvmType jvmType, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return jniFindClassInspection.toProperFindClassArgument(jvmType, bl);
    }

    private static final JvmType buildVisitor$lambda$0$getBaseType(JvmType $this$buildVisitor_u24lambda_u240_u24getBaseType) {
        return $this$buildVisitor_u24lambda_u240_u24getBaseType instanceof JvmArrayType ? JniFindClassInspection.buildVisitor$lambda$0$getBaseType(((JvmArrayType)$this$buildVisitor_u24lambda_u240_u24getBaseType).getType()) : $this$buildVisitor_u24lambda_u240_u24getBaseType;
    }

    public static final /* synthetic */ JvmType access$buildVisitor$lambda$0$getBaseType(JvmType $receiver) {
        return JniFindClassInspection.buildVisitor$lambda$0$getBaseType($receiver);
    }
}

