/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.NdkConstants;
import com.android.tools.ndk.jni.model.JvmPrimitiveType;
import com.android.tools.ndk.jni.model.JvmPrimitiveTypeSymbol;
import com.android.tools.ndk.jni.model.SimpleParameterDeclaration;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u001a$\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\tH\u0002\u00a8\u0006\u000b"}, d2={"isCompatibleWithJniType", "", "Lcom/jetbrains/cidr/lang/types/OCType;", "containingFile", "Lcom/intellij/psi/PsiFile;", "jniType", "", "isCpp", "unify", "", "Lcom/android/tools/ndk/jni/model/SimpleParameterDeclaration;", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniFunctionSignatureInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniFunctionSignatureInspection.kt\ncom/android/tools/ndk/jni/inspections/JniFunctionSignatureInspectionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,260:1\n1485#2:261\n1510#2,2:262\n1557#2:264\n1628#2,3:265\n1512#2:268\n1513#2,3:276\n1872#2,2:279\n1557#2:281\n1628#2,3:282\n1557#2:285\n1628#2,3:286\n1874#2:289\n381#3,7:269\n*S KotlinDebug\n*F\n+ 1 JniFunctionSignatureInspection.kt\ncom/android/tools/ndk/jni/inspections/JniFunctionSignatureInspectionKt\n*L\n239#1:261\n239#1:262,2\n240#1:264\n240#1:265,3\n239#1:268\n239#1:276,3\n249#1:279,2\n250#1:281\n250#1:282,3\n252#1:285\n252#1:286,3\n249#1:289\n239#1:269,7\n*E\n"})
public final class JniFunctionSignatureInspectionKt {
    public static final boolean isCompatibleWithJniType(@NotNull OCType $this$isCompatibleWithJniType, @NotNull PsiFile containingFile, @NotNull String jniType, boolean isCpp) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isCompatibleWithJniType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        Intrinsics.checkNotNullParameter((Object)jniType, (String)"jniType");
        if (Intrinsics.areEqual((Object)$this$isCompatibleWithJniType.getName(), (Object)jniType)) {
            return true;
        }
        if ($this$isCompatibleWithJniType instanceof OCNumericType) {
            Object object = JniUtilsKt.resolvePrimitiveJniType((OCNumericType)$this$isCompatibleWithJniType, containingFile);
            if (object == null || (object = ((JvmPrimitiveType)object).getSymbol()) == null) {
                return false;
            }
            return switch (WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()]) {
                case 1 -> false;
                case 2 -> Intrinsics.areEqual((Object)jniType, (Object)"jboolean");
                case 3 -> Intrinsics.areEqual((Object)jniType, (Object)"jbyte");
                case 4 -> Intrinsics.areEqual((Object)jniType, (Object)"jchar");
                case 5 -> Intrinsics.areEqual((Object)jniType, (Object)"jshort");
                case 6 -> Intrinsics.areEqual((Object)jniType, (Object)"jint");
                case 7 -> Intrinsics.areEqual((Object)jniType, (Object)"jlong");
                case 8 -> Intrinsics.areEqual((Object)jniType, (Object)"jfloat");
                case 9 -> Intrinsics.areEqual((Object)jniType, (Object)"jdouble");
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        if (!($this$isCompatibleWithJniType instanceof OCPointerType)) {
            return false;
        }
        OCType oCType = ((OCPointerType)$this$isCompatibleWithJniType).getRefType();
        Intrinsics.checkNotNullExpressionValue((Object)oCType, (String)"getRefType(...)");
        String realTypeName = JniUtilsKt.resolveRealTypeName(oCType);
        if (Intrinsics.areEqual((Object)jniType, (Object)"JNIEnv *")) {
            bl = isCpp ? Intrinsics.areEqual((Object)realTypeName, (Object)"_JNIEnv") : Intrinsics.areEqual((Object)realTypeName, (Object)"*JNINativeInterface");
        } else if (isCpp) {
            bl = Intrinsics.areEqual((Object)realTypeName, (Object)("_" + jniType));
        } else {
            Object[] objectArray = new String[]{"jobject", "jthrowable", "jclass", "jobjectArray"};
            bl = SetsKt.setOf((Object[])objectArray).contains(jniType) ? Intrinsics.areEqual((Object)realTypeName, (Object)"void") : false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<List<SimpleParameterDeclaration>> unify(List<? extends List<SimpleParameterDeclaration>> $this$unify) {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = $this$unify;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$mapTo$iv$iv;
            List signature = (List)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = signature;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SimpleParameterDeclaration simpleParameterDeclaration = (SimpleParameterDeclaration)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(NdkConstants.JOBJECT_VARIATION.contains(it.getType()) ? "jobject" : it.getType());
            }
            List key$iv$iv = (List)destination$iv$iv2;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map indexedByNormalizedTypes = destination$iv$iv;
        List result = new ArrayList();
        indexedByNormalizedTypes.forEach((arg_0, arg_1) -> JniFunctionSignatureInspectionKt.unify$lambda$6((arg_0, arg_1) -> JniFunctionSignatureInspectionKt.unify$lambda$5(result, arg_0, arg_1), arg_0, arg_1));
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit unify$lambda$5(List $result, List unifiedTypes, List compatibleSignatures) {
        Intrinsics.checkNotNullParameter((Object)unifiedTypes, (String)"unifiedTypes");
        Intrinsics.checkNotNullParameter((Object)compatibleSignatures, (String)"compatibleSignatures");
        if (compatibleSignatures.size() == 1) {
            CollectionsKt.addAll((Collection)$result, (Iterable)compatibleSignatures);
        } else {
            List unifiedSignature = new ArrayList();
            Iterable $this$forEachIndexed$iv = unifiedTypes;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void $this$mapTo$iv$iv;
                void $this$mapTo$iv$iv2;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int i = n;
                boolean bl = false;
                Iterable $this$map$iv = compatibleSignatures;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo22 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    List list = (List)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(((SimpleParameterDeclaration)it.get(i)).getName());
                }
                String unifiedArgName = CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)), (CharSequence)"_or_", null, null, (int)0, null, null, (int)62, null);
                Collection collection = unifiedSignature;
                Iterable $this$map$iv2 = compatibleSignatures;
                boolean $i$f$map2 = false;
                Iterable $i$f$mapTo22 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    List list = (List)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl3 = false;
                    collection2.add(((SimpleParameterDeclaration)it.get(i)).getType());
                }
                String string2 = (String)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv2)));
                if (string2 == null) {
                    void unifiedType;
                    string2 = unifiedType;
                }
                String string3 = unifiedArgName;
                String string4 = string2;
                collection.add(new SimpleParameterDeclaration(string4, string3));
            }
            ((Collection)$result).add(unifiedSignature);
        }
        return Unit.INSTANCE;
    }

    private static final void unify$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ List access$unify(List $receiver) {
        return JniFunctionSignatureInspectionKt.unify($receiver);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JvmPrimitiveTypeSymbol.values().length];
            try {
                nArray[JvmPrimitiveTypeSymbol.VOID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JvmPrimitiveTypeSymbol.BOOLEAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JvmPrimitiveTypeSymbol.BYTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JvmPrimitiveTypeSymbol.CHAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JvmPrimitiveTypeSymbol.SHORT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JvmPrimitiveTypeSymbol.INT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JvmPrimitiveTypeSymbol.LONG.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JvmPrimitiveTypeSymbol.FLOAT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JvmPrimitiveTypeSymbol.DOUBLE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

