/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.refactor;

import com.android.tools.ndk.jni.model.JniNativeMethodId;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.NativeMethodId;
import com.android.tools.ndk.jni.model.NativeMethodInfo;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenamer;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001cH\u0014J\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u0016*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0018\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/ndk/jni/refactor/JniInplaceCxxFunctionRenamer;", "Lcom/jetbrains/cidr/lang/refactoring/rename/OCInplaceRenamer;", "nativeMethodInfo", "Lcom/android/tools/ndk/jni/model/NativeMethodInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "symbol", "Lcom/jetbrains/cidr/lang/symbols/OCSymbol;", "<init>", "(Lcom/android/tools/ndk/jni/model/NativeMethodInfo;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/cidr/lang/symbols/OCSymbol;)V", "getNativeMethodInfo", "()Lcom/android/tools/ndk/jni/model/NativeMethodInfo;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getSymbol", "()Lcom/jetbrains/cidr/lang/symbols/OCSymbol;", "myJvmMethodInfos", "", "Lcom/android/tools/ndk/jni/model/JvmMethodInfo;", "isIdentifier", "", "newName", "", "language", "Lcom/intellij/lang/Language;", "performOnInvalidIdentifier", "", "nameSuggestions", "Ljava/util/LinkedHashSet;", "findIssueWhenRenamedFrom", "Lcom/android/tools/ndk/jni/model/JniNativeMethodId;", "oldNativeMethodId", "performRenameInner", "element", "Lcom/intellij/psi/PsiElement;", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniInplaceCxxFunctionRenamer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniInplaceCxxFunctionRenamer.kt\ncom/android/tools/ndk/jni/refactor/JniInplaceCxxFunctionRenamer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1863#2,2:97\n*S KotlinDebug\n*F\n+ 1 JniInplaceCxxFunctionRenamer.kt\ncom/android/tools/ndk/jni/refactor/JniInplaceCxxFunctionRenamer\n*L\n86#1:97,2\n*E\n"})
public final class JniInplaceCxxFunctionRenamer
extends OCInplaceRenamer {
    @NotNull
    private final NativeMethodInfo nativeMethodInfo;
    @NotNull
    private final Editor editor;
    @NotNull
    private final OCSymbol symbol;
    @NotNull
    private final List<JvmMethodInfo> myJvmMethodInfos;

    public JniInplaceCxxFunctionRenamer(@NotNull NativeMethodInfo nativeMethodInfo, @NotNull Editor editor, @NotNull OCSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)nativeMethodInfo, (String)"nativeMethodInfo");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        OCDeclarator oCDeclarator = nativeMethodInfo.getPsiElement().getDeclarator();
        Intrinsics.checkNotNull((Object)oCDeclarator);
        super((PsiNamedElement)oCDeclarator, symbol, editor, false, nativeMethodInfo.getPsiElement().getName(), nativeMethodInfo.getPsiElement().getName());
        this.nativeMethodInfo = nativeMethodInfo;
        this.editor = editor;
        this.symbol = symbol;
        Project project = this.nativeMethodInfo.getPsiElement().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.myJvmMethodInfos = JniMethodResolver.Companion.getInstance(project).resolveNativeMethod(this.nativeMethodInfo);
    }

    @NotNull
    public final NativeMethodInfo getNativeMethodInfo() {
        return this.nativeMethodInfo;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final OCSymbol getSymbol() {
        return this.symbol;
    }

    protected boolean isIdentifier(@NotNull String newName, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (!super.isIdentifier(newName, language)) {
            return false;
        }
        JniNativeMethodId jniNativeMethodId = JniNativeMethodId.Companion.fromJniMethodName(newName);
        if (jniNativeMethodId == null) {
            return false;
        }
        JniNativeMethodId nativeMethodId = jniNativeMethodId;
        NativeMethodId nativeMethodId2 = this.nativeMethodInfo.getNativeMethodId();
        Intrinsics.checkNotNull((Object)nativeMethodId2, (String)"null cannot be cast to non-null type com.android.tools.ndk.jni.model.JniNativeMethodId");
        return this.findIssueWhenRenamedFrom(nativeMethodId, (JniNativeMethodId)nativeMethodId2) == null;
    }

    protected void performOnInvalidIdentifier(@NotNull String newName, @NotNull LinkedHashSet<String> nameSuggestions) {
        String issue;
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(nameSuggestions, (String)"nameSuggestions");
        JniNativeMethodId jniNativeMethodId = JniNativeMethodId.Companion.fromJniMethodName(newName);
        if (jniNativeMethodId != null) {
            NativeMethodId nativeMethodId = this.nativeMethodInfo.getNativeMethodId();
            Intrinsics.checkNotNull((Object)nativeMethodId, (String)"null cannot be cast to non-null type com.android.tools.ndk.jni.model.JniNativeMethodId");
            v2 = this.findIssueWhenRenamedFrom(jniNativeMethodId, (JniNativeMethodId)nativeMethodId);
        } else {
            v2 = issue = null;
        }
        if (issue != null) {
            JniInplaceCxxFunctionRenamer.performOnInvalidIdentifier$showPopup(this, issue);
        } else {
            JniInplaceCxxFunctionRenamer.performOnInvalidIdentifier$showPopup(this, "Invalid JNI-mangled function name.");
        }
    }

    private final String findIssueWhenRenamedFrom(JniNativeMethodId $this$findIssueWhenRenamedFrom, JniNativeMethodId oldNativeMethodId) {
        if (!Intrinsics.areEqual((Object)$this$findIssueWhenRenamedFrom.getClassName(), (Object)oldNativeMethodId.getClassName())) {
            return "Cannot rename Java or Kotlin package and classes here. Please rename them in Java or Kotlin code instead.";
        }
        if (!Intrinsics.areEqual($this$findIssueWhenRenamedFrom.getArgTypes(), oldNativeMethodId.getArgTypes())) {
            return "Cannot change the mangled argument signature.";
        }
        return null;
    }

    public void performRenameInner(@NotNull PsiElement element, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        JniNativeMethodId jniNativeMethodId = JniNativeMethodId.Companion.fromJniMethodName(newName);
        Intrinsics.checkNotNull((Object)jniNativeMethodId);
        JniNativeMethodId newNativeMethodId = jniNativeMethodId;
        if (!((Collection)this.myJvmMethodInfos).isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> JniInplaceCxxFunctionRenamer.performRenameInner$lambda$2(this, newNativeMethodId));
        }
        super.performRenameInner(element, newName);
    }

    private static final void performOnInvalidIdentifier$showPopup(JniInplaceCxxFunctionRenamer this$0, String message) {
        JBPopupFactory.getInstance().createMessage(message).showInBestPositionFor(this$0.myEditor);
    }

    private static final void performRenameInner$lambda$2(JniInplaceCxxFunctionRenamer this$0, JniNativeMethodId $newNativeMethodId) {
        for (JvmMethodInfo methodInfo : this$0.myJvmMethodInfos) {
            RenamePsiElementProcessor renamePsiElementProcessor;
            PsiElement psiElement = methodInfo.getPsiElement();
            RenamePsiElementProcessor $this$performRenameInner_u24lambda_u242_u24lambda_u241 = renamePsiElementProcessor = RenamePsiElementProcessor.forElement((PsiElement)psiElement);
            boolean bl = false;
            Collection collection = $this$performRenameInner_u24lambda_u242_u24lambda_u241.findReferences(psiElement);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findReferences(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiReference it = (PsiReference)element$iv;
                boolean bl2 = false;
                it.handleElementRename($newNativeMethodId.getMethodName());
            }
            $this$performRenameInner_u24lambda_u242_u24lambda_u241.renameElement(psiElement, $newNativeMethodId.getMethodName(), new UsageInfo[0], null);
        }
    }
}

