/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.reference;

import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.MethodInfo;
import com.android.tools.ndk.jni.reference.JniReferencesSearchKt;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageUtilsBase;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/ndk/jni/reference/JniMethodReferencesSearch;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters;", "<init>", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "android-ndk"})
public final class JniMethodReferencesSearch
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public JniMethodReferencesSearch() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (OCLanguageUtilsBase.isCppSupportDisabled((Project)queryParameters.getProject())) {
            return;
        }
        if (!Registry.Companion.is("com.android.tools.ndk.jni.enableJniReferenceSearch")) {
            return;
        }
        if (ApplicationManager.getApplication().isDispatchThread() && !Registry.Companion.is("com.android.tools.ndk.jni.allowJniReferenceSearchOnEdt")) {
            return;
        }
        if (((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)queryParameters.getProject(), (Object)true)).booleanValue()) {
            return;
        }
        Project project = queryParameters.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        SearchScope searchScope = queryParameters.getEffectiveSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getEffectiveSearchScope(...)");
        SearchScope augmentedScope = JniReferencesSearchKt.access$augmentScopeForSearch(project, searchScope);
        PsiMethod psiMethod = queryParameters.getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"getMethod(...)");
        PsiMethod element = psiMethod;
        Object[] objectArray = MethodInfo.Companion.fromPsiElement((PsiElement)element, false);
        JvmMethodInfo jvmMethodInfo = objectArray instanceof JvmMethodInfo ? (JvmMethodInfo)objectArray : null;
        if (jvmMethodInfo == null) {
            return;
        }
        JvmMethodInfo methodInfo = jvmMethodInfo;
        Project project2 = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        objectArray = new String[]{methodInfo.getMethodName(), methodInfo.getMethodType()};
        SearchScope narrowedScope = JniUtilsKt.narrowDown$default(augmentedScope, project2, null, CollectionsKt.listOf((Object[])objectArray), 2, null);
        JniReferencesSearchKt.access$searchReferencesInGetMethodIdCalls(element, consumer, narrowedScope);
        JniReferencesSearchKt.access$searchReferencesInRegisterNativesCalls(element, consumer, narrowedScope);
    }
}

