/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.service;

import com.android.tools.ndk.jni.model.ClassTypeInfo;
import com.android.tools.ndk.jni.model.FullyQualifiedClassName;
import com.android.tools.ndk.jni.model.JniCall;
import com.android.tools.ndk.jni.model.JniCallKt;
import com.android.tools.ndk.jni.model.JvmMethodId;
import com.android.tools.ndk.jni.model.JvmObjectType;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.model.JvmTypeInfo;
import com.android.tools.ndk.jni.model.NativeMethodInfo;
import com.android.tools.ndk.jni.model.RegisterNativesCall;
import com.android.tools.ndk.jni.service.JniInfoInferencer;
import com.android.tools.ndk.jni.service.RegisteredNativesBundle;
import com.android.tools.ndk.jni.utils.CompoundInitializerDataSource;
import com.android.tools.ndk.jni.utils.DataSource;
import com.android.tools.ndk.jni.utils.DataSourceKt;
import com.android.tools.ndk.jni.utils.FunctionDeclarationDataSource;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.android.tools.ndk.jni.utils.StringDataSource;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializerMember;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0010*\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/ndk/jni/service/RegisterNativesProcessor;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "jniInfoInferencer", "Lcom/android/tools/ndk/jni/service/JniInfoInferencer;", "getJniInfoInferencer", "()Lcom/android/tools/ndk/jni/service/JniInfoInferencer;", "jniInfoInferencer$delegate", "Lkotlin/Lazy;", "getAllCallsToRegisterNatives", "", "Lcom/jetbrains/cidr/lang/psi/OCCallExpression;", "process", "Lcom/android/tools/ndk/jni/service/RegisteredNativesBundle;", "registerNativesCall", "call", "Lcom/android/tools/ndk/jni/model/RegisterNativesCall;", "processInner", "Companion", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nRegisterNativesProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegisterNativesProcessor.kt\ncom/android/tools/ndk/jni/service/RegisterNativesProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 JniUtils.kt\ncom/android/tools/ndk/jni/utils/JniUtilsKt\n*L\n1#1,148:1\n1#2:149\n453#3,7:150\n*S KotlinDebug\n*F\n+ 1 RegisterNativesProcessor.kt\ncom/android/tools/ndk/jni/service/RegisterNativesProcessor\n*L\n78#1:150,7\n*E\n"})
public final class RegisterNativesProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy jniInfoInferencer$delegate;

    private RegisterNativesProcessor(Project project) {
        this.project = project;
        this.jniInfoInferencer$delegate = LazyKt.lazy(() -> RegisterNativesProcessor.jniInfoInferencer_delegate$lambda$0(this));
    }

    private final JniInfoInferencer getJniInfoInferencer() {
        Lazy lazy = this.jniInfoInferencer$delegate;
        return (JniInfoInferencer)lazy.getValue();
    }

    @NotNull
    public final List<OCCallExpression> getAllCallsToRegisterNatives() {
        if (JniUtilsKt.isHandlingRegisterNative()) {
            return CollectionsKt.emptyList();
        }
        return JniUtilsKt.findAllJniCalls$default(this.project, "RegisterNatives", null, 2, null);
    }

    @Nullable
    public final RegisteredNativesBundle process(@NotNull OCCallExpression registerNativesCall) {
        RegisteredNativesBundle registeredNativesBundle;
        Intrinsics.checkNotNullParameter((Object)registerNativesCall, (String)"registerNativesCall");
        JniCall jniCall = JniCallKt.toJniCall(registerNativesCall);
        RegisterNativesCall registerNativesCall2 = jniCall instanceof RegisterNativesCall ? (RegisterNativesCall)jniCall : null;
        if (registerNativesCall2 != null) {
            RegisterNativesCall it = registerNativesCall2;
            boolean bl = false;
            registeredNativesBundle = this.process(it);
        } else {
            registeredNativesBundle = null;
        }
        return registeredNativesBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final RegisteredNativesBundle process(@NotNull RegisterNativesCall call) {
        RegisteredNativesBundle registeredNativesBundle;
        OCCallExpression oCCallExpression;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        OCCallExpression $this$process_u24lambda_u242 = oCCallExpression = call.getCallExpression();
        boolean bl = false;
        if (!$this$process_u24lambda_u242.isValid()) {
            return null;
        }
        OCCallExpression callExpression = oCCallExpression;
        boolean $i$f$handleRegisterNative = false;
        try {
            JniUtilsKt.getHandlingRegisterNative().set(true);
            boolean bl2 = false;
            registeredNativesBundle = (RegisteredNativesBundle)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)callExpression), JniUtilsKt.asJniFeatureKey("ANDROID_STUDIO_REGISTERED_NATIVES_BUNDLE"), () -> RegisterNativesProcessor.process$lambda$5$lambda$4(callExpression, this));
        }
        finally {
            JniUtilsKt.getHandlingRegisterNative().set(false);
        }
        return registeredNativesBundle;
    }

    private final RegisteredNativesBundle processInner(RegisterNativesCall $this$processInner) {
        List list;
        OCCompoundInitializer jniNativeMethodInitializer;
        JvmTypeInfo jvmTypeInfo = this.getJniInfoInferencer().inferTypeInfo((PsiElement)$this$processInner.getClassExpression());
        ClassTypeInfo classTypeInfo = jvmTypeInfo instanceof ClassTypeInfo ? (ClassTypeInfo)jvmTypeInfo : null;
        if (classTypeInfo == null) {
            return null;
        }
        ClassTypeInfo classInfo = classTypeInfo;
        JvmType jvmType = classInfo.getClassType();
        Object object = jvmType instanceof JvmObjectType ? (JvmObjectType)jvmType : null;
        if (object == null || (object = ((JvmObjectType)object).getName()) == null) {
            return null;
        }
        Object className = object;
        DataSource dataSource = DataSourceKt.getDataSource((OCElement)$this$processInner.getMethodsExpression());
        CompoundInitializerDataSource compoundInitializerDataSource = dataSource instanceof CompoundInitializerDataSource ? (CompoundInitializerDataSource)dataSource : null;
        OCCompoundInitializer oCCompoundInitializer = jniNativeMethodInitializer = compoundInitializerDataSource != null ? compoundInitializerDataSource.getCompoundInitializer() : null;
        Object object2 = oCCompoundInitializer != null ? oCCompoundInitializer.getParent() : null;
        OCDeclarator oCDeclarator = object2 instanceof OCDeclarator ? (OCDeclarator)object2 : null;
        if (oCDeclarator == null) {
            return null;
        }
        OCDeclarator jniNativeMethodDeclarator = oCDeclarator;
        OCType oCType = jniNativeMethodDeclarator.getResolvedType();
        Intrinsics.checkNotNullExpressionValue((Object)oCType, (String)"getResolvedType(...)");
        String string = JniUtilsKt.resolveRealTypeName(oCType);
        if (string == null) {
            return null;
        }
        object2 = string;
        if (Intrinsics.areEqual((Object)object2, (Object)"*JNINativeMethod")) {
            List list2 = jniNativeMethodInitializer.getInitializerExpressions();
            list = list2;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getInitializerExpressions(...)");
        } else if (Intrinsics.areEqual((Object)object2, (Object)"JNINativeMethod")) {
            list = CollectionsKt.listOf((Object)jniNativeMethodInitializer);
        } else {
            return null;
        }
        List methods = list;
        BidirectionalMultiMap jvmMethodIdToOcFunction = new BidirectionalMultiMap();
        BidirectionalMultiMap bindingToOcInitializer = new BidirectionalMultiMap();
        HashMultimap methodNameStringLiteralToBindingInitializer = HashMultimap.create();
        for (OCExpression methodInitializer : methods) {
            NativeMethodInfo nativeMethodInfo;
            StringDataSource methodNameDataSource;
            List bindingInitializerComponents;
            Intrinsics.checkNotNull((Object)methodInitializer);
            DataSource dataSource2 = DataSourceKt.getDataSource((OCElement)methodInitializer);
            CompoundInitializerDataSource compoundInitializerDataSource2 = dataSource2 instanceof CompoundInitializerDataSource ? (CompoundInitializerDataSource)dataSource2 : null;
            if (compoundInitializerDataSource2 == null || (compoundInitializerDataSource2 = compoundInitializerDataSource2.getCompoundInitializer()) == null) continue;
            CompoundInitializerDataSource bindingInitializer = compoundInitializerDataSource2;
            Intrinsics.checkNotNullExpressionValue((Object)bindingInitializer.getInitializers(), (String)"getInitializers(...)");
            OCCompoundInitializerMember oCCompoundInitializerMember = (OCCompoundInitializerMember)CollectionsKt.getOrNull((List)bindingInitializerComponents, (int)0);
            DataSource dataSource3 = oCCompoundInitializerMember != null ? DataSourceKt.getDataSource((OCElement)oCCompoundInitializerMember) : null;
            if ((dataSource3 instanceof StringDataSource ? (StringDataSource)dataSource3 : null) == null) continue;
            methodNameDataSource = methodNameDataSource;
            String methodName = methodNameDataSource.getString();
            OCCompoundInitializerMember oCCompoundInitializerMember2 = (OCCompoundInitializerMember)CollectionsKt.getOrNull((List)bindingInitializerComponents, (int)1);
            DataSource dataSource4 = oCCompoundInitializerMember2 != null ? DataSourceKt.getDataSource((OCElement)oCCompoundInitializerMember2) : null;
            Object object3 = dataSource4 instanceof StringDataSource ? (StringDataSource)dataSource4 : null;
            if (object3 == null || (object3 = ((StringDataSource)object3).getString()) == null) continue;
            Object methodType = object3;
            OCCompoundInitializerMember oCCompoundInitializerMember3 = (OCCompoundInitializerMember)CollectionsKt.getOrNull((List)bindingInitializerComponents, (int)2);
            DataSource dataSource5 = oCCompoundInitializerMember3 != null ? DataSourceKt.getDataSource((OCElement)oCCompoundInitializerMember3) : null;
            DataSource dataSource6 = dataSource4 = dataSource5 instanceof FunctionDeclarationDataSource ? (FunctionDeclarationDataSource)dataSource5 : null;
            if (dataSource4 != null && (dataSource5 = ((FunctionDeclarationDataSource)dataSource4).getFunctionDeclaration()) != null) {
                DataSource it = dataSource5;
                boolean bl = false;
                nativeMethodInfo = NativeMethodInfo.Companion.fromOcFunctionDeclaration((OCFunctionDeclaration)it);
            } else {
                nativeMethodInfo = null;
            }
            NativeMethodInfo nativeMethodInfo2 = nativeMethodInfo;
            JvmMethodId jvmMethodId = new JvmMethodId((FullyQualifiedClassName)className, methodName, (String)methodType);
            bindingToOcInitializer.put((Object)TuplesKt.to((Object)jvmMethodId, (Object)nativeMethodInfo2), (Object)bindingInitializer);
            methodNameStringLiteralToBindingInitializer.put((Object)methodNameDataSource.getSourceExpression(), (Object)bindingInitializer);
            if (nativeMethodInfo2 == null) continue;
            jvmMethodIdToOcFunction.put((Object)jvmMethodId, (Object)nativeMethodInfo2);
        }
        Intrinsics.checkNotNull((Object)methodNameStringLiteralToBindingInitializer);
        return new RegisteredNativesBundle((BidirectionalMultiMap<JvmMethodId, NativeMethodInfo>)jvmMethodIdToOcFunction, (BidirectionalMultiMap<Pair<JvmMethodId, NativeMethodInfo>, OCCompoundInitializer>)bindingToOcInitializer, (Multimap<OCLiteralExpression, OCCompoundInitializer>)((Multimap)methodNameStringLiteralToBindingInitializer));
    }

    private static final JniInfoInferencer jniInfoInferencer_delegate$lambda$0(RegisterNativesProcessor this$0) {
        return JniInfoInferencer.Companion.getInstance(this$0.project);
    }

    private static final RegisteredNativesBundle process$lambda$5$lambda$4$lambda$3(OCCallExpression $callExpression, RegisterNativesProcessor this$0) {
        JniCall jniCall = JniCallKt.toJniCall($callExpression);
        RegisterNativesCall registerNativesCall = jniCall instanceof RegisterNativesCall ? (RegisterNativesCall)jniCall : null;
        return registerNativesCall != null ? this$0.processInner(registerNativesCall) : null;
    }

    private static final CachedValueProvider.Result process$lambda$5$lambda$4(OCCallExpression $callExpression, RegisterNativesProcessor this$0) {
        return JniUtilsKt.createCacheResult((PsiElement)$callExpression, JniUtilsKt.asJniFeatureKey("ANDROID_STUDIO_REGISTERED_NATIVES_BUNDLE"), () -> RegisterNativesProcessor.process$lambda$5$lambda$4$lambda$3($callExpression, this$0));
    }

    @JvmStatic
    @NotNull
    public static final RegisterNativesProcessor getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/ndk/jni/service/RegisterNativesProcessor$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/ndk/jni/service/RegisterNativesProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "android-ndk"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RegisterNativesProcessor getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(RegisterNativesProcessor.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (RegisterNativesProcessor)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

