/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.jetbrains.cidr.lang.OCLanguageUtilsBase;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptimizedFileNotificationProvider
implements EditorNotificationProvider {
    private static final Key<Object> HIDE_KEY = Key.create((String)"android.tools.ndk.run.opt.hide");
    public static final Key<AndroidLLDBDriverConfiguration> WARNING_KEY = Key.create((String)"android.tools.ndk.run.opt.warning");

    @Nullable
    public Function<FileEditor, EditorNotificationPanel> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (OCLanguageUtilsBase.isCppSupportDisabled((Project)project) || NdkHelper.isNdkProject(project)) {
            return null;
        }
        return editor -> {
            if (editor.getUserData(HIDE_KEY) != null) {
                return null;
            }
            AndroidLLDBDriverConfiguration configuration = (AndroidLLDBDriverConfiguration)((Object)((Object)editor.getUserData(WARNING_KEY)));
            if (configuration == null || !configuration.isOptimizedWarningEnabled()) {
                return null;
            }
            return new Panel(file, (FileEditor)editor, project, configuration);
        };
    }

    private static class Panel
    extends EditorNotificationPanel {
        Panel(@NotNull VirtualFile file, @NotNull FileEditor editor, @NotNull Project project, @NotNull AndroidLLDBDriverConfiguration configuration) {
            this.setText("WARNING: This function was compiled with optimizations enabled. Some debugger features may not be available.");
            this.createActionLabel("Hide", () -> {
                editor.putUserData(HIDE_KEY, new Object());
                EditorNotifications.getInstance((Project)project).updateNotifications(file);
            });
            this.createActionLabel("Do not show this again", () -> {
                configuration.disableOptimizedWarning();
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
            });
            this.createActionLabel("Help", () -> BrowserUtil.browse((String)"https://developer.android.com/r/studio-ui/debugging-with-cpp-flags.html"));
        }
    }
}

