/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.crash;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.ndk.run.lldb.LLDBSdkPkgInstaller;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jetbrains.android.diagnostics.error.ErrorBean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NativeClientCrashReportingTask
extends Task.Backgroundable {
    private final ErrorBean myBean;
    private final Consumer<String> myCallback;
    private final Consumer<Exception> myErrorCallback;
    private final String mySignature;
    private final DeviceInfo myDeviceInfo;

    public NativeClientCrashReportingTask(@Nullable Project project, @NotNull String title, boolean canBeCancelled, @NotNull ErrorBean bean, @NotNull Consumer<String> callback, @NotNull Consumer<Exception> errorCallback, @Nullable DeviceInfo deviceInfo, @Nullable String signature) {
        super(project, title, canBeCancelled);
        this.myBean = bean;
        this.myCallback = callback;
        this.myErrorCallback = errorCallback;
        this.mySignature = signature;
        this.myDeviceInfo = deviceInfo;
    }

    public void run(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator) {
        indicator.setIndeterminate(true);
        try {
            CloseableHttpClient client = HttpClients.createDefault();
            HttpPost post = new HttpPost("https://clients2.google.com/cr/report");
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("product", "AndroidStudioNative");
            ApplicationInfoEx application = (ApplicationInfoEx)ApplicationInfo.getInstance();
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(((Object)((Object)this)).getClass());
            LocalPackage info = (LocalPackage)AndroidSdks.getInstance().tryToChooseSdkHandler().getSdkManager((ProgressIndicator)progress).getPackages().getLocalPackages().get(LLDBSdkPkgInstaller.COMPATIBLE_PKG_PATH);
            StringBuilder version = new StringBuilder();
            version.append(application.getFullVersion());
            if (info != null) {
                version.append('/');
                version.append(info.getVersion().toString());
            }
            builder.addTextBody("version", version.toString());
            if (this.myBean.getLastAction() != null) {
                builder.addTextBody("last_action", this.myBean.getLastAction());
            }
            if (this.myBean.getDescription() != null) {
                builder.addTextBody("comments", this.myBean.getDescription());
            }
            if (this.myBean.getStackTrace() != null) {
                builder.addTextBody("exception", this.myBean.getStackTrace());
            }
            if (this.mySignature != null) {
                builder.addTextBody("signature", this.mySignature);
            }
            if (this.myDeviceInfo != null) {
                if (this.myDeviceInfo.hasCpuAbi()) {
                    builder.addTextBody("cpu-abi", this.myDeviceInfo.getCpuAbi().name());
                }
                if (this.myDeviceInfo.hasModel()) {
                    builder.addTextBody("model", this.myDeviceInfo.getModel());
                }
                if (this.myDeviceInfo.hasBuildApiLevelFull()) {
                    builder.addTextBody("api-level", this.myDeviceInfo.getBuildApiLevelFull());
                }
                if (this.myDeviceInfo.hasBuildTags()) {
                    builder.addTextBody("build-tags", this.myDeviceInfo.getBuildTags());
                }
                if (this.myDeviceInfo.hasBuildType()) {
                    builder.addTextBody("build-type", this.myDeviceInfo.getBuildType());
                }
                if (this.myDeviceInfo.hasManufacturer()) {
                    builder.addTextBody("manufacturer", this.myDeviceInfo.getManufacturer());
                }
            }
            int file_no = 0;
            for (Attachment attachment : this.myBean.getAttachments()) {
                if (attachment == null || !attachment.isIncluded()) continue;
                Object name = "upload_file_minidump";
                if (file_no++ > 0) {
                    name = (String)name + file_no;
                }
                builder.addBinaryBody((String)name, attachment.getBytes(), ContentType.APPLICATION_OCTET_STREAM, attachment.getName());
            }
            post.setEntity((HttpEntity)new GzipCompressingEntity(builder.build()));
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Unable to submit error report. Error code: " + response.getStatusLine().getStatusCode());
            }
            this.myCallback.consume((Object)EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (IOException e) {
            this.myErrorCallback.consume((Object)e);
        }
    }
}

