/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseSymbolDirectoryPanel
extends JPanel {
    private final Project myProject;
    private final JBList mySymDirsList;
    private CollectionListModel<String> mySymDirsModel;

    public ChooseSymbolDirectoryPanel(@NotNull Project project) {
        super(new BorderLayout());
        this.myProject = project;
        this.mySymDirsModel = new CollectionListModel((Object[])new String[0]);
        this.mySymDirsList = new JBList(this.mySymDirsModel);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)this.mySymDirsList).setAddAction(button -> {
            String path = this.chooseDirectory();
            if (path != null) {
                this.mySymDirsModel.add((Object)path);
                this.mySymDirsList.setSelectedValue((Object)path, true);
            }
        });
        this.add(decorator.createPanel());
    }

    @Nullable
    private String chooseDirectory() {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)this.mySymDirsList, (Project)this.myProject, (VirtualFile)this.myProject.getBaseDir());
        return file != null ? FileUtil.toSystemDependentName((String)file.getPath()) : null;
    }

    @NotNull
    public List<String> getSymbolDirs() {
        return this.mySymDirsModel.getItems();
    }

    public void setSymbolDirs(@NotNull List<String> symDirs) {
        this.mySymDirsModel = new CollectionListModel(symDirs);
        this.mySymDirsList.setModel(this.mySymDirsModel);
    }
}

