/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.ddmlib.Client;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.execution.common.debug.AndroidDebuggerConfigurable;
import com.android.tools.ndk.run.editor.NativeAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerConfigurable;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.hybrid.AndroidJavaDebugProcess;
import com.android.tools.ndk.run.hybrid.AndroidNativeHybridDebugProcess;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.android.tools.ndk.run.lldb.SessionStarterType;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.content.Content;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.cidr.execution.RunParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HybridAndroidDebugger
extends NativeAndroidDebugger {
    public static final String ID = "Hybrid";
    private static final Logger LOG = Logger.getInstance(HybridAndroidDebugger.class);

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Dual (Java + Native)";
    }

    @Override
    @NotNull
    public AndroidDebuggerConfigurable<NativeAndroidDebuggerState> createConfigurable(@NotNull RunConfiguration runConfiguration) {
        return new NativeAndroidDebuggerConfigurable<NativeAndroidDebuggerState>(runConfiguration.getProject(), true, true);
    }

    @Override
    public XDebugSession getExistingDebugSession(@NotNull Project project, @NotNull Client client) {
        XDebugSession nativeDebugSession = HybridAndroidDebugger.findNativeDebugSession(project, client);
        XDebugSession javaDebugSession = HybridAndroidDebugger.findJdwpDebuggerSession((Project)project, (Client)client);
        if (javaDebugSession == null || nativeDebugSession == null) {
            HybridAndroidDebugger.detachDebugSessions(nativeDebugSession, javaDebugSession);
            return null;
        }
        return nativeDebugSession;
    }

    private static void detachDebugSessions(@Nullable XDebugSession nativeDebugSession, @Nullable XDebugSession javaDebugSession) {
        if (nativeDebugSession != null) {
            HybridAndroidDebugger.detachXDebugSession(nativeDebugSession);
        }
        if (javaDebugSession != null) {
            HybridAndroidDebugger.detachXDebugSession(javaDebugSession);
        }
    }

    @Override
    @NotNull
    public AndroidNativeHybridDebugProcess newAndroidNativeAppDebugProcess(@NotNull String sessionId, @NotNull RunParameters parameters, final @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder2, @NotNull SessionStarter sessionStarter, @NotNull Client client, @Nullable JdwpConnector jdwpConnector, boolean detachOnStop, @NotNull Abi lldbServerAbi) throws ExecutionException {
        if (jdwpConnector == null) {
            throw new IllegalStateException("JDWP connector must not be null for Dual debugger sessions");
        }
        session.addSessionListener((XDebugSessionListener)new FrameContentSwitcher(session));
        final AndroidNativeHybridDebugProcess result = new AndroidNativeHybridDebugProcess(sessionId, parameters, session, consoleBuilder2, sessionStarter, client, detachOnStop, lldbServerAbi);
        jdwpConnector.addSessionListener(new JdwpConnector.SessionListener(){

            @Override
            public void sessionCreated(final @NotNull DebuggerSession debuggerSession) {
                try {
                    XDebugSession javaDebugSession = XDebuggerManager.getInstance((Project)session.getProject()).startSessionAndShowTab(session.getSessionName() + "-java", null, new XDebugProcessStarter(){

                        @NotNull
                        public XDebugProcess start(@NotNull XDebugSession session) {
                            return AndroidJavaDebugProcess.create(session, debuggerSession, result);
                        }
                    });
                    javaDebugSession.addSessionListener((XDebugSessionListener)new FrameContentSwitcher(javaDebugSession));
                }
                catch (ExecutionException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
        return result;
    }

    @Override
    public boolean needsJdwpConnectorOnAttach(@NotNull SessionStarterType sessionStarterType) {
        return true;
    }

    private static class FrameContentSwitcher
    implements XDebugSessionListener {
        private final XDebugSession myDebugSession;
        private boolean myFirstRun = true;

        public FrameContentSwitcher(XDebugSession debugSession) {
            this.myDebugSession = debugSession;
        }

        public void sessionPaused() {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                RunContentDescriptor descriptor = this.myDebugSession.getRunContentDescriptor();
                RunContentManager.getInstance((Project)this.myDebugSession.getProject()).toFrontRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), descriptor);
                if (this.myFirstRun) {
                    RunnerLayoutUi ui = this.myDebugSession.getUI();
                    Content frameContent = ui.findContent("FrameContent");
                    if (frameContent != null) {
                        ui.selectAndFocus(frameContent, true, true);
                    }
                    this.myFirstRun = false;
                }
            }, ModalityState.defaultModalityState());
        }
    }
}

