/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.IDevice;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.run.NativeDebuggerAppContext;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriver;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AndroidLLDBDriverConfiguration
extends LLDBDriverConfiguration {
    @NotNull
    private final NativeAndroidDebuggerState myDebuggerState;
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final List<Abi> myClientABIs;
    @NotNull
    private final SessionStarter mySessionStarter;
    @NotNull
    private final List<String> myStartupCommands;
    @NotNull
    private final List<String> myPostAttachCommands;
    @NotNull
    private final File myFrameworkFile;
    private static final Logger LOG = Logger.getInstance(AndroidLLDBDriverConfiguration.class);
    private final NativeDebuggerAppContext myAppContext;

    public AndroidLLDBDriverConfiguration(@NotNull NativeDebuggerAppContext appContext, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull IDevice device, @NotNull List<Abi> clientABIs, @NotNull SessionStarter sessionStarter, @NotNull List<String> startupCommands, @NotNull List<String> postAttachCommands) {
        this.myAppContext = appContext;
        this.myDebuggerState = debuggerState;
        this.myDevice = device;
        this.myClientABIs = clientABIs;
        this.mySessionStarter = sessionStarter;
        this.myStartupCommands = startupCommands;
        this.myPostAttachCommands = postAttachCommands;
        this.myFrameworkFile = this.findFrameworkFile();
        LOG.info("LLDB framework file: " + this.myFrameworkFile.getAbsolutePath());
    }

    @NotNull
    public Map<File, File> getExplicitModuleSymbolMap(Abi abi) {
        return this.myAppContext.getExplicitModuleSymbolMap(abi);
    }

    @NotNull
    public IDevice getDevice() {
        return this.myDevice;
    }

    @NotNull
    public List<Abi> getClientABIs() {
        return this.myClientABIs;
    }

    @NotNull
    public SessionStarter getSessionStarter() {
        return this.mySessionStarter;
    }

    @NotNull
    public List<String> getStartupCommands() {
        return this.myStartupCommands;
    }

    @NotNull
    public List<String> getPostAttachCommands() {
        return this.myPostAttachCommands;
    }

    @NotNull
    public LLDBDriver createDriver(@NotNull DebuggerDriver.Handler handler, @NotNull ArchitectureType architectureType) throws ExecutionException {
        return new AndroidLLDBDriver(handler, this.myAppContext, this.myDebuggerState, this, architectureType);
    }

    @NotNull
    private static File getLLDBHostFile(@NotNull String relativePath) {
        return ModulePathManager.getLldbHostFile(relativePath);
    }

    @NotNull
    protected File getLLDBBinFile(@NotNull String relativePath) {
        return AndroidLLDBDriverConfiguration.getLLDBHostFile(new File("bin", relativePath).getPath());
    }

    @NotNull
    private static File getLLDBLibDir() {
        return AndroidLLDBDriverConfiguration.getLLDBHostFile(new File(SystemInfo.isMac || SystemInfo.isLinux ? "lib64" : "lib").getPath());
    }

    @NotNull
    private File findFrameworkFile() {
        if (SystemInfo.isWindows) {
            return this.getLLDBBinFile("liblldb.dll");
        }
        File[] libFiles = AndroidLLDBDriverConfiguration.getLLDBLibDir().listFiles(pathname -> pathname.getName().startsWith("liblldb."));
        if (libFiles == null || libFiles.length != 1) {
            throw new RuntimeException("Found broken LLDB configuration");
        }
        return libFiles[0];
    }

    @NotNull
    protected File getLLDBFrameworkFile(@NotNull ArchitectureType architectureType) {
        return this.myFrameworkFile;
    }

    protected void configureDriverCommandLine(@NotNull GeneralCommandLine result) {
        String workingDir = this.myDebuggerState.getWorkingDir();
        if (!workingDir.isEmpty()) {
            result.withWorkDirectory(workingDir);
        }
    }

    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver, @NotNull ArchitectureType architectureType) throws ExecutionException {
        File lldbFrameworkFile = this.getLLDBFrameworkFile(architectureType);
        if (!lldbFrameworkFile.exists()) {
            throw new ExecutionException(lldbFrameworkFile + " not found");
        }
        File frontendExecutable = this.getLLDBBinFile(SystemInfo.isWindows ? "LLDBFrontend.exe" : "LLDBFrontend");
        if (!frontendExecutable.exists()) {
            throw new ExecutionException(frontendExecutable.getAbsolutePath() + " not found");
        }
        GeneralCommandLine result = new GeneralCommandLine();
        result.setExePath(frontendExecutable.getAbsolutePath());
        result.addParameter(String.valueOf(((LLDBDriver)driver).getPort()));
        AndroidLLDBDriverConfiguration.setupCommonParameters((GeneralCommandLine)result);
        Map env = result.getEnvironment();
        if (SystemInfo.isLinux) {
            env.put("LD_LIBRARY_PATH", AndroidLLDBDriverConfiguration.getLLDBLibDir().getAbsolutePath());
        } else if (SystemInfo.isMac) {
            env.put("DYLD_FRAMEWORK_PATH", lldbFrameworkFile.getParent());
        }
        env.put("PYTHONHOME", ModulePathManager.getLldbPythonHome().getAbsolutePath());
        String lldbPythonLibs = ModulePathManager.getLldbHostFile(SystemInfo.isMac ? "lib64/python" : "lib/python").getAbsolutePath();
        Map<String, String> parentEnv = System.getenv();
        String parentPythonPath = parentEnv.get("PYTHONPATH");
        StringBuilder pythonPath = parentPythonPath != null ? new StringBuilder(parentPythonPath + File.pathSeparator + lldbPythonLibs) : new StringBuilder(lldbPythonLibs);
        if (((Boolean)StudioFlags.ENABLE_LLDB_NATVIS.get()).booleanValue()) {
            List<String> lldbCidrHelpers = ModulePathManager.getCidrLldbHelpers();
            for (String lib : lldbCidrHelpers) {
                pythonPath.append(File.pathSeparator).append(lib);
            }
        }
        env.put("PYTHONPATH", pythonPath.toString());
        env.put("PYTHONDONTWRITEBYTECODE", "1");
        this.configureDriverCommandLine(result);
        return result;
    }

    public boolean isStaticVarsLoadingEnabled() {
        return this.myDebuggerState.showStaticVars();
    }

    public boolean isOptimizedWarningEnabled() {
        return this.myDebuggerState.showOptimizedWarning();
    }

    public void disableOptimizedWarning() {
        this.myDebuggerState.setShowOptimizedWarning(false);
    }
}

