/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.Client;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.execution.common.AndroidSessionInfo;
import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.android.tools.ndk.run.ClientShellHelper;
import com.android.tools.ndk.run.NativeDebuggerAppContext;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.RunAsSessionStarterImpl;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.android.tools.ndk.run.lldb.SessionStarterType;
import com.android.tools.ndk.run.lldb.ShellSessionStarterImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a`\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001aJ\u0010\u0016\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001aJ\u0010\u0019\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a*\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u00a8\u0006\u001d"}, d2={"newSessionStarter", "Lcom/android/tools/ndk/run/lldb/SessionStarter;", "jdwpConnector", "Lcom/android/tools/ndk/run/jdwp/JdwpConnector;", "appContext", "Lcom/android/tools/ndk/run/NativeDebuggerAppContext;", "client", "Lcom/android/ddmlib/Client;", "clientShellHelper", "Lcom/android/tools/ndk/run/ClientShellHelper;", "clientABIs", "", "Lcom/android/sdklib/devices/Abi;", "lldbServer", "Ljava/io/File;", "startServerScript", "type", "Lcom/android/tools/ndk/run/lldb/SessionStarterType;", "nativeAndroidDebuggerState", "Lcom/android/tools/ndk/run/editor/NativeAndroidDebuggerState;", "project", "Lcom/intellij/openapi/project/Project;", "newShellSessionStarter", "serverPath", "startScriptPath", "newRunAsSessionStarter", "registerOnSessionStartedListener", "", "sessionStarter", "android-ndk"})
public final class SessionStarterUtilKt {
    @NotNull
    public static final SessionStarter newSessionStarter(@Nullable JdwpConnector jdwpConnector, @NotNull NativeDebuggerAppContext appContext, @NotNull Client client, @NotNull ClientShellHelper clientShellHelper, @NotNull List<? extends Abi> clientABIs, @NotNull File lldbServer, @NotNull File startServerScript, @NotNull SessionStarterType type, @NotNull NativeAndroidDebuggerState nativeAndroidDebuggerState, @NotNull Project project) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clientShellHelper, (String)"clientShellHelper");
        Intrinsics.checkNotNullParameter(clientABIs, (String)"clientABIs");
        Intrinsics.checkNotNullParameter((Object)lldbServer, (String)"lldbServer");
        Intrinsics.checkNotNullParameter((Object)startServerScript, (String)"startServerScript");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)nativeAndroidDebuggerState), (String)"nativeAndroidDebuggerState");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AndroidNativeAppDebugProcess.verifyNativeModel(appContext, clientABIs);
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> SessionStarterUtilKt.newShellSessionStarter(jdwpConnector, appContext, client, clientShellHelper, lldbServer, startServerScript, nativeAndroidDebuggerState, project);
            case 2 -> SessionStarterUtilKt.newRunAsSessionStarter(jdwpConnector, appContext, client, clientShellHelper, lldbServer, startServerScript, nativeAndroidDebuggerState, project);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final SessionStarter newShellSessionStarter(JdwpConnector jdwpConnector, NativeDebuggerAppContext appContext, Client client, ClientShellHelper clientShellHelper, File serverPath, File startScriptPath, NativeAndroidDebuggerState nativeAndroidDebuggerState, Project project) throws ExecutionException {
        SessionStarter sessionStarter = new ShellSessionStarterImpl(client, clientShellHelper, serverPath, startScriptPath, nativeAndroidDebuggerState, project);
        SessionStarterUtilKt.registerOnSessionStartedListener(appContext, client, sessionStarter, jdwpConnector);
        return sessionStarter;
    }

    private static final SessionStarter newRunAsSessionStarter(JdwpConnector jdwpConnector, NativeDebuggerAppContext appContext, Client client, ClientShellHelper clientShellHelper, File serverPath, File startScriptPath, NativeAndroidDebuggerState nativeAndroidDebuggerState, Project project) throws ExecutionException {
        SessionStarter sessionStarter = new RunAsSessionStarterImpl(client, clientShellHelper, serverPath, startScriptPath, nativeAndroidDebuggerState, project);
        SessionStarterUtilKt.registerOnSessionStartedListener(appContext, client, sessionStarter, jdwpConnector);
        return sessionStarter;
    }

    private static final void registerOnSessionStartedListener(NativeDebuggerAppContext appContext, Client client, SessionStarter sessionStarter, JdwpConnector jdwpConnector) {
        sessionStarter.addEventListener(arg_0 -> SessionStarterUtilKt.registerOnSessionStartedListener$lambda$2(jdwpConnector, client, appContext, arg_0));
    }

    private static final void registerOnSessionStartedListener$lambda$2$lambda$1(XDebugSession $nativeDebugSession) {
        $nativeDebugSession.initBreakpoints();
    }

    private static final void registerOnSessionStartedListener$lambda$2(JdwpConnector $jdwpConnector, Client $client, NativeDebuggerAppContext $appContext, XDebugSession nativeDebugSession) {
        Intrinsics.checkNotNullParameter((Object)nativeDebugSession, (String)"nativeDebugSession");
        JdwpConnector jdwpConnector = $jdwpConnector;
        if (jdwpConnector != null && (jdwpConnector = jdwpConnector.Connect()) != null) {
            JdwpConnector javaDebugSession = jdwpConnector;
            boolean bl = false;
            ProcessHandler processHandler = javaDebugSession.getProcess().getProcessHandler();
            Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"getProcessHandler(...)");
            List list = CollectionsKt.listOf((Object)$client.getDevice());
            String string = $appContext.getApplicationId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApplicationId(...)");
            AndroidSessionInfo.Companion.create(processHandler, list, string);
        }
        if (!nativeDebugSession.getDebugProcess().checkCanInitBreakpoints()) {
            ApplicationManager.getApplication().runReadAction(() -> SessionStarterUtilKt.registerOnSessionStartedListener$lambda$2$lambda$1(nativeDebugSession));
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SessionStarterType.values().length];
            try {
                nArray[SessionStarterType.ROOT_SHELL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SessionStarterType.RUN_AS_SHELL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

