/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp;

import com.android.tools.ndk.run.lldb.renderers.TemplateParamsParser;
import com.android.tools.ndk.run.lldb.renderers.TypeNameFormatterCategory;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class SetTypeNameFormatter
implements TypeNameFormatterCategory.TypeNameFormatter {
    private final String myContainerName;

    public SetTypeNameFormatter(@NotNull String containerName) {
        this.myContainerName = containerName;
    }

    @Override
    public String format(@NotNull String input) {
        int numParams;
        ArrayList<String> templateParams = TemplateParamsParser.getTemplateParams(input);
        int n = numParams = templateParams == null ? 0 : templateParams.size();
        if (numParams < 1 || numParams > 3) {
            return input;
        }
        String elementType = templateParams.get(0);
        String elementTypeAngleBracketSpace = TemplateParamsParser.spaceBetweenAngleBracket(elementType);
        if (numParams >= 2 && !templateParams.get(1).contentEquals(String.format("std::less<%s%s>", elementType, elementTypeAngleBracketSpace))) {
            return input;
        }
        if (numParams == 3 && !templateParams.get(2).contentEquals(String.format("std::allocator<%s%s>", elementType, elementTypeAngleBracketSpace))) {
            return input;
        }
        TypeNameFormatterCategory.TypeNameFormatter elementTypeFormatter = TypeNameFormatterCategory.lookupTypeNameFormatter(elementType);
        return String.format("%s<%s%s>", this.myContainerName, elementTypeFormatter != null ? elementTypeFormatter.format(elementType) : elementType, elementTypeAngleBracketSpace);
    }
}

