/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.sync;

import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.ndk.AndroidNdkProjectSettings;
import com.android.tools.ndk.sync.NativeHeaderDirCache;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"BD\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\u0004\b\u000f\u0010\u0010B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0011J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0006\u0010 \u001a\u00020\u0017J\u0016\u0010!\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/ndk/sync/NativeProjectFileFilterService;", "", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/android/tools/ndk/AndroidNdkProjectSettings;", "headerDirCache", "Lcom/android/tools/ndk/sync/NativeHeaderDirCache;", "isModuleUsingCMake", "Lkotlin/Function1;", "Lcom/intellij/openapi/module/Module;", "Lkotlin/ParameterName;", "name", "module", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/ndk/AndroidNdkProjectSettings;Lcom/android/tools/ndk/sync/NativeHeaderDirCache;Lkotlin/jvm/functions/Function1;)V", "(Lcom/intellij/openapi/project/Project;)V", "bloomFilter", "Lcom/google/common/hash/BloomFilter;", "", "dirty", "clear", "", "approximateProjectFileCount", "", "markProjectFile", "file", "Ljava/io/File;", "fileToPath", "Ljava/nio/file/Path;", "path", "refreshProjectViewIfNeeded", "shouldShowInProjectView", "Companion", "android-ndk"})
public final class NativeProjectFileFilterService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AndroidNdkProjectSettings settings;
    @NotNull
    private final NativeHeaderDirCache headerDirCache;
    @NotNull
    private final Function1<Module, Boolean> isModuleUsingCMake;
    @Nullable
    private BloomFilter<String> bloomFilter;
    private boolean dirty;

    @VisibleForTesting
    public NativeProjectFileFilterService(@NotNull Project project, @NotNull AndroidNdkProjectSettings settings, @NotNull NativeHeaderDirCache headerDirCache, @NotNull Function1<? super Module, Boolean> isModuleUsingCMake) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)headerDirCache, (String)"headerDirCache");
        Intrinsics.checkNotNullParameter(isModuleUsingCMake, (String)"isModuleUsingCMake");
        this.project = project;
        this.settings = settings;
        this.headerDirCache = headerDirCache;
        this.isModuleUsingCMake = isModuleUsingCMake;
        this.dirty = true;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, (Object)new BulkFileListener(){

            public void before(List<? extends VFileEvent> events) {
                block1: {
                    Intrinsics.checkNotNullParameter(events, (String)"events");
                    BloomFilter bloomFilter = bloomFilter;
                    if (bloomFilter == null) break block1;
                    BloomFilter bloomFilter2 = bloomFilter;
                    NativeProjectFileFilterService nativeProjectFileFilterService = this;
                    BloomFilter filter = bloomFilter2;
                    boolean bl = false;
                    Iterable $this$forEach$iv = events;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        VFileEvent event = (VFileEvent)element$iv;
                        boolean bl2 = false;
                        if (!event.isFromSave()) continue;
                        Object object = event.getFile();
                        if (object == null || (object = FileExtensions.toIoFile((VirtualFile)object)) == null) continue;
                        Object it = object;
                        boolean bl3 = false;
                        nativeProjectFileFilterService.markProjectFile((File)it);
                    }
                }
            }
        });
    }

    public NativeProjectFileFilterService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AndroidNdkProjectSettings androidNdkProjectSettings = AndroidNdkProjectSettings.Companion.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)androidNdkProjectSettings, (String)"getInstance(...)");
        Object object = project.getService(NativeHeaderDirCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        this(project, androidNdkProjectSettings, (NativeHeaderDirCache)object, (Function1<? super Module, Boolean>)((Function1)NativeProjectFileFilterService::_init_$lambda$0));
    }

    public final void clear(int approximateProjectFileCount) {
        this.dirty = true;
        this.bloomFilter = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)StandardCharsets.UTF_8), (int)(approximateProjectFileCount + 1000), (double)0.001);
    }

    public final void markProjectFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.markProjectFile(this.fileToPath(file));
    }

    private final Path fileToPath(File file) {
        Path path = file.getAbsoluteFile().toPath();
        String string = System.getenv("TEST_SRCDIR");
        if (string == null) {
            Intrinsics.checkNotNull((Object)path);
            return path;
        }
        Path bazelTestRoot = new File(string).toPath();
        if (path.startsWith(bazelTestRoot)) {
            Path path2 = path.relativize(bazelTestRoot);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"relativize(...)");
            return path2;
        }
        Intrinsics.checkNotNull((Object)path);
        return path;
    }

    private final void markProjectFile(Path path) {
        this.dirty = true;
        BloomFilter<String> bloomFilter = this.bloomFilter;
        if (bloomFilter == null) {
            throw new IllegalStateException("You must call clear() first.");
        }
        BloomFilter<String> bloomFilter2 = bloomFilter;
        String pathString = ((Object)path).toString();
        if (bloomFilter2.mightContain((Object)pathString)) {
            return;
        }
        bloomFilter2.put((Object)pathString);
        Path path2 = path.getParent();
        if (path2 == null) {
            return;
        }
        this.markProjectFile(path2);
    }

    public final void refreshProjectViewIfNeeded() {
        if (this.dirty) {
            this.dirty = false;
            ProjectView.getInstance((Project)this.project).refresh();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldShowInProjectView(@NotNull Module module, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.settings.getShowFilesUnknownToCMake()) {
            return true;
        }
        if (!((Boolean)this.isModuleUsingCMake.invoke((Object)module)).booleanValue()) {
            return true;
        }
        if (this.headerDirCache.isUnderSomeNativeHeaderDir(file)) return true;
        BloomFilter<String> bloomFilter = this.bloomFilter;
        if (bloomFilter == null) return false;
        boolean bl = bloomFilter.mightContain((Object)((Object)this.fileToPath(file)).toString());
        if (!bl) return false;
        return true;
    }

    private static final boolean _init_$lambda$0(Module it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = NdkModuleModel.Companion.get(it);
        return object != null && (object = object.getBuildSystems()) != null ? object.contains("cmake") : false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/ndk/sync/NativeProjectFileFilterService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/ndk/sync/NativeProjectFileFilterService;", "project", "Lcom/intellij/openapi/project/Project;", "android-ndk"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NativeProjectFileFilterService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(NativeProjectFileFilterService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (NativeProjectFileFilterService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

