/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBList;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ASGallery<E>
extends JBList {
    private static final Insets DEFAULT_CELL_MARGIN = new Insets(1, 1, 1, 1);
    @NotNull
    private Insets myCellMargin = DEFAULT_CELL_MARGIN;
    @NotNull
    private JBDimension myThumbnailSize;
    @NotNull
    private Function<? super E, String> myLabelProvider;
    @Nullable
    private LoadingCache<E, Optional<Icon>> myIconsCache;
    @NotNull
    private Map<E, CellRenderer> myCellRenderers = Maps.newHashMap();
    @Nullable
    private Action myDefaultAction;

    public ASGallery() {
        this(new DefaultListModel(), Functions.constant(null), Functions.toStringFunction(), new Dimension(0, 0), null);
    }

    public ASGallery(@NotNull ListModel model2, @NotNull Function<? super E, Icon> iconProvider, @NotNull Function<? super E, String> labelProvider, @NotNull Dimension thumbnailSize, @Nullable Action defaultAction) {
        this(model2, iconProvider, labelProvider, thumbnailSize, defaultAction, false);
    }

    public ASGallery(@NotNull ListModel model2, @NotNull Function<? super E, Icon> iconProvider, @NotNull Function<? super E, String> labelProvider, @NotNull Dimension thumbnailSize, @Nullable Action defaultAction, boolean disableSpeedSearch) {
        this.myThumbnailSize = JBDimension.create((Dimension)thumbnailSize);
        this.myLabelProvider = labelProvider;
        this.myDefaultAction = defaultAction;
        Font listFont = UIUtil.getListFont();
        if (listFont != null) {
            this.setFont(listFont);
        }
        this.setIconProvider(iconProvider);
        this.setLabelProvider(labelProvider);
        this.setModel(model2);
        this.setThumbnailSize(thumbnailSize);
        this.setSelectionMode(0);
        this.setLayoutOrientation(2);
        this.setVisibleRowCount(-1);
        this.setOpaque(true);
        this.setFocusable(true);
        this.setCellRenderer(new GalleryCellRenderer());
        this.setBackground(UIUtil.getListBackground());
        this.installListeners();
        this.installKeyboardActions();
        if (!disableSpeedSearch) {
            TreeUIHelper.getInstance().installListSpeedSearch((JList)((Object)this), (Convertor)new Convertor<Object, String>(){

                public String convert(Object o) {
                    return (String)ASGallery.this.myLabelProvider.apply(o);
                }
            });
        }
    }

    private void installListeners() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension cellSize = ASGallery.this.computeCellSize();
                ASGallery.this.setFixedCellWidth(cellSize.width);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = ASGallery.this.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                ASGallery.this.ensureIndexIsVisible(index);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1 && ASGallery.this.myDefaultAction != null) {
                    int index = ASGallery.this.getSelectedIndex();
                    if (index < 0) {
                        return;
                    }
                    Rectangle bounds = ASGallery.this.getCellBounds(index, index);
                    if (bounds.contains(e.getPoint())) {
                        ASGallery.this.myDefaultAction.actionPerformed(new ActionEvent(e.getSource(), 0, null));
                    }
                }
            }
        });
    }

    private void installKeyboardActions() {
        String previousListElementKey;
        String nextListElementKey;
        this.getActionMap().put("nextListElement", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ASGallery.this.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                if (++index >= ASGallery.this.getModel().getSize()) {
                    return;
                }
                ASGallery.this.setSelectedIndex(index);
                ASGallery.this.ensureIndexIsVisible(index);
            }
        });
        this.getActionMap().put("previousListElement", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ASGallery.this.getSelectedIndex();
                if (index <= 0) {
                    return;
                }
                ASGallery.this.setSelectedIndex(--index);
                ASGallery.this.ensureIndexIsVisible(index);
            }
        });
        if (this.getComponentOrientation().isLeftToRight()) {
            nextListElementKey = "RIGHT";
            previousListElementKey = "LEFT";
        } else {
            nextListElementKey = "LEFT";
            previousListElementKey = "RIGHT";
        }
        this.getInputMap(0).put(KeyStroke.getKeyStroke(nextListElementKey), "nextListElement");
        this.getInputMap(0).put(KeyStroke.getKeyStroke("KP_" + nextListElementKey), "nextListElement");
        this.getInputMap(0).put(KeyStroke.getKeyStroke(previousListElementKey), "previousListElement");
        this.getInputMap(0).put(KeyStroke.getKeyStroke("KP_" + previousListElementKey), "previousListElement");
    }

    public void setModel(ListModel model2) {
        int oldSelectIndex = this.getSelectedIndex();
        super.setModel(model2);
        if (this.myIconsCache != null) {
            this.myIconsCache.invalidateAll();
        }
        this.myCellRenderers.clear();
        if (oldSelectIndex >= 0) {
            this.setSelectedIndex(oldSelectIndex);
            this.ensureIndexIsVisible(oldSelectIndex);
        }
    }

    public void setThumbnailSize(Dimension thumbnailSize) {
        this.myThumbnailSize = JBDimension.create((Dimension)thumbnailSize);
        this.recomputeCellSize();
    }

    public void setDefaultAction(@NotNull Action action) {
        this.myDefaultAction = action;
    }

    private void recomputeCellSize() {
        Dimension cellSize = this.computeCellSize();
        this.setFixedCellWidth(cellSize.width);
        this.setFixedCellHeight(cellSize.height);
        this.invalidate();
        this.repaint();
    }

    protected Dimension computeCellSize() {
        int listWidth = this.getSize().width - this.getInsets().left - this.getInsets().right;
        int preferredWidth = this.myThumbnailSize.width + this.myCellMargin.left + this.myCellMargin.right;
        int columnCount = listWidth / preferredWidth;
        int width = columnCount == 0 ? preferredWidth : listWidth / columnCount - 1;
        int textHeight = this.getFont().getSize();
        int height = this.myThumbnailSize.height + this.myCellMargin.top + this.myCellMargin.bottom + 2 * textHeight;
        return new Dimension(width, height);
    }

    public void setCellMargin(@Nullable Insets cellMargin) {
        Insets insets = cellMargin = cellMargin == null ? DEFAULT_CELL_MARGIN : cellMargin;
        if (!Objects.equal((Object)cellMargin, (Object)this.myCellMargin)) {
            Insets oldCellMargin = this.myCellMargin;
            this.myCellMargin = cellMargin;
            this.recomputeCellSize();
            this.firePropertyChange("cellMargin", oldCellMargin, cellMargin);
        }
    }

    public void setIconProvider(@NotNull Function<? super E, Icon> iconProvider) {
        Function scaledIconProvider = input -> {
            Icon icon = (Icon)iconProvider.apply(input);
            if (icon == null) {
                return null;
            }
            return IconUtil.scale((Icon)icon, (Component)((Object)this), (float)((float)this.myThumbnailSize.height / (float)icon.getIconHeight()));
        };
        CacheLoader cacheLoader = CacheLoader.from(ToOptionalFunction.wrap(scaledIconProvider));
        this.myCellRenderers.clear();
        this.myIconsCache = CacheBuilder.newBuilder().weakKeys().build(cacheLoader);
        this.repaint(this.getVisibleRect());
    }

    public void setLabelProvider(@NotNull Function<? super E, String> labelProvider) {
        this.myLabelProvider = labelProvider;
    }

    public void setSelectedElement(E selectedElement) {
        this.setSelectedValue(selectedElement, true);
    }

    @Nullable
    public E getSelectedElement() {
        return (E)this.getSelectedValue();
    }

    @Nullable
    private Icon getCellIcon(E element) {
        try {
            Optional icon = (Optional)this.myIconsCache.get(element);
            return icon.orElse(null);
        }
        catch (ExecutionException e) {
            Logger.getInstance(((Object)((Object)this)).getClass()).error((Throwable)e);
            return null;
        }
    }

    @Nullable
    private String getCellLabel(E element) {
        return (String)this.myLabelProvider.apply(element);
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return JBUI.scale((int)10);
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.computeCellSize().height;
    }

    class GalleryCellRenderer
    implements ListCellRenderer {
        GalleryCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jlist, Object value, int cellIndex, boolean isSelected, boolean cellHasFocus) {
            Object element = value;
            CellRenderer renderer = ASGallery.this.myCellRenderers.get(element);
            if (renderer == null) {
                renderer = this.createCellRendererComponent(element);
                ASGallery.this.myCellRenderers.put(element, renderer);
            }
            renderer.setAppearance(isSelected, cellHasFocus);
            return renderer.getComponent();
        }

        public CellRenderer createCellRendererComponent(E element) {
            Icon icon = ASGallery.this.getCellIcon(element);
            String label2 = ASGallery.this.getCellLabel(element);
            if (icon == null) {
                return new TextOnlyCellRenderer(label2);
            }
            return new TextAndImageCellRenderer(ASGallery.this.getFont(), label2, icon);
        }
    }

    private static final class ToOptionalFunction<P, R>
    implements Function<P, Optional<R>> {
        private final Function<P, R> myFunction;

        public ToOptionalFunction(Function<P, R> function) {
            this.myFunction = function;
        }

        public static <P, R> Function<P, Optional<R>> wrap(Function<P, R> function) {
            return new ToOptionalFunction<P, R>(function);
        }

        public Optional<R> apply(P input) {
            Object result = this.myFunction.apply(input);
            return Optional.ofNullable(result);
        }
    }

    private static class TextAndImageCellRenderer
    extends AbstractCellRenderer {
        private JPanel myPanel;
        private JTextPane myTextPane;

        private TextAndImageCellRenderer(Font font, String label2, Icon icon) {
            JLabel imageLabel = new JLabel(icon);
            imageLabel.getAccessibleContext().setAccessibleDescription(label2);
            imageLabel.setVerticalAlignment(1);
            JTextPane textPane = new JTextPane();
            textPane.getAccessibleContext().setAccessibleName(label2);
            StyledDocument document = textPane.getStyledDocument();
            SimpleAttributeSet centerAttribute = new SimpleAttributeSet();
            StyleConstants.setAlignment(centerAttribute, 1);
            document.setParagraphAttributes(0, document.getLength(), centerAttribute, false);
            textPane.setText(label2);
            textPane.setEditable(false);
            int hPadding = font.getSize() / 3;
            Border padding = BorderFactory.createEmptyBorder(hPadding, 0, hPadding, 0);
            textPane.setBorder(padding);
            JPanel panel = new JPanel(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    d.width = -1;
                    return d;
                }
            };
            panel.setFocusable(true);
            panel.setOpaque(false);
            panel.setLayout(new BorderLayout());
            panel.add(imageLabel);
            panel.add((Component)textPane, "Last");
            panel.getAccessibleContext().setAccessibleName(textPane.getAccessibleContext().getAccessibleName());
            panel.getAccessibleContext().setAccessibleDescription(textPane.getAccessibleContext().getAccessibleDescription());
            this.myPanel = panel;
            this.myTextPane = textPane;
        }

        @Override
        protected void setSelectionBorder(JComponent component2) {
            if (this.myIsSelected) {
                component2.setBorder(new LineBorder(UIUtil.getTreeSelectionBackground((boolean)this.myCellHasFocus)));
            } else {
                component2.setBorder(new LineBorder(UIUtil.getPanelBackground()));
            }
        }

        @Override
        public void updateAppearance() {
            this.setSelectionBorder(this.myPanel);
            this.setTextPaneBackground(this.myTextPane);
            this.setTextPaneForeground(this.myTextPane);
        }

        @Override
        public Component getComponent() {
            return this.myPanel;
        }

        public void setTextPaneBackground(JTextPane textPane) {
            if (this.myIsSelected) {
                textPane.setBackground(UIUtil.getTreeSelectionBackground((boolean)this.myCellHasFocus));
                textPane.setOpaque(true);
            } else {
                textPane.setBackground(null);
                textPane.setOpaque(false);
            }
        }

        public void setTextPaneForeground(JTextPane textPane) {
            textPane.setForeground(UIUtil.getTreeForeground((boolean)this.myIsSelected, (boolean)this.myCellHasFocus));
        }
    }

    private static class TextOnlyCellRenderer
    extends AbstractCellRenderer {
        private JLabel myLabel;

        public TextOnlyCellRenderer(String label2) {
            JLabel jlabel = new JLabel(label2);
            jlabel.setHorizontalAlignment(0);
            jlabel.setForeground(UIUtil.getTreeForeground());
            jlabel.setFocusable(true);
            this.myLabel = jlabel;
        }

        @Override
        public void updateAppearance() {
            this.setSelectionBorder(this.myLabel);
        }

        @Override
        public Component getComponent() {
            return this.myLabel;
        }
    }

    private static abstract class AbstractCellRenderer
    implements CellRenderer {
        private boolean myIsInitialized;
        protected boolean myIsSelected;
        protected boolean myCellHasFocus;

        private AbstractCellRenderer() {
        }

        @Override
        public abstract Component getComponent();

        @Override
        public void setAppearance(boolean isSelected, boolean cellHasFocus) {
            if (this.myIsInitialized && isSelected == this.myIsSelected && cellHasFocus == this.myCellHasFocus) {
                return;
            }
            this.myIsInitialized = true;
            this.myIsSelected = isSelected;
            this.myCellHasFocus = cellHasFocus;
            this.updateAppearance();
        }

        protected abstract void updateAppearance();

        protected void setSelectionBorder(JComponent component2) {
            if (this.myIsSelected) {
                component2.setBorder(new LineBorder(UIUtil.getTreeSelectionBackground((boolean)this.myCellHasFocus)));
            } else {
                component2.setBorder(null);
            }
        }
    }

    private static interface CellRenderer {
        public void setAppearance(boolean var1, boolean var2);

        public Component getComponent();
    }
}

