/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.stdui.CommonButton;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.components.JBViewport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0003\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0005J\b\u0010\u001a\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/adtui/HorizontalScrollView;", "Ljavax/swing/JPanel;", "content", "Ljavax/swing/JComponent;", "scrollSensitivity", "", "leftButton", "Ljavax/swing/AbstractButton;", "rightButton", "<init>", "(Ljavax/swing/JComponent;ILjavax/swing/AbstractButton;Ljavax/swing/AbstractButton;)V", "getLeftButton", "()Ljavax/swing/AbstractButton;", "getRightButton", "main", "Lcom/intellij/ui/components/JBViewport;", "xMax", "getXMax", "()I", "clampX", "x", "scrollBy", "", "dx", "scrollTo", "newX", "refreshButtons", "intellij.android.adt.ui"})
@SourceDebugExtension(value={"SMAP\nHorizontalScrollView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HorizontalScrollView.kt\ncom/android/tools/adtui/HorizontalScrollView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1#2:69\n*E\n"})
public final class HorizontalScrollView
extends JPanel {
    @NotNull
    private final JComponent content;
    @NotNull
    private final AbstractButton leftButton;
    @NotNull
    private final AbstractButton rightButton;
    @NotNull
    private final JBViewport main;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public HorizontalScrollView(@NotNull JComponent content, int scrollSensitivity, @VisibleForTesting @NotNull AbstractButton leftButton, @VisibleForTesting @NotNull AbstractButton rightButton) {
        void $this$main_u24lambda_u240;
        JBViewport jBViewport;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)leftButton, (String)"leftButton");
        Intrinsics.checkNotNullParameter((Object)rightButton, (String)"rightButton");
        super(new BorderLayout());
        this.content = content;
        this.leftButton = leftButton;
        this.rightButton = rightButton;
        JBViewport jBViewport2 = jBViewport = new JBViewport();
        HorizontalScrollView horizontalScrollView = this;
        boolean bl = false;
        $this$main_u24lambda_u240.setView((Component)this.content);
        horizontalScrollView.main = jBViewport;
        this.leftButton.addActionListener(arg_0 -> HorizontalScrollView._init_$lambda$1(this, scrollSensitivity, arg_0));
        this.rightButton.addActionListener(arg_0 -> HorizontalScrollView._init_$lambda$2(this, scrollSensitivity, arg_0));
        ComponentAdapter listener2 = new ComponentAdapter(this){
            final /* synthetic */ HorizontalScrollView this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                HorizontalScrollView.access$refreshButtons(this.this$0);
            }
        };
        this.content.addComponentListener(listener2);
        this.main.addComponentListener((ComponentListener)listener2);
        this.main.addMouseWheelListener(arg_0 -> HorizontalScrollView._init_$lambda$3(this, scrollSensitivity, arg_0));
        this.add((Component)this.main, "Center");
        this.add((Component)this.leftButton, "West");
        this.add((Component)this.rightButton, "East");
        this.refreshButtons();
    }

    public /* synthetic */ HorizontalScrollView(JComponent jComponent, int n, AbstractButton abstractButton, AbstractButton abstractButton2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 30;
        }
        if ((n2 & 4) != 0) {
            abstractButton = new CommonButton("\u2190");
        }
        if ((n2 & 8) != 0) {
            abstractButton2 = new CommonButton("\u2192");
        }
        this(jComponent, n, abstractButton, abstractButton2);
    }

    @NotNull
    public final AbstractButton getLeftButton() {
        return this.leftButton;
    }

    @NotNull
    public final AbstractButton getRightButton() {
        return this.rightButton;
    }

    private final int getXMax() {
        return Math.max(0, this.content.getWidth() - this.main.getWidth());
    }

    private final int clampX(int x) {
        return Math.min(this.getXMax(), Math.max(0, x));
    }

    private final void scrollBy(int dx) {
        this.scrollTo(this.main.getViewPosition().x + dx);
    }

    /*
     * WARNING - void declaration
     */
    public final void scrollTo(int newX) {
        void $this$scrollTo_u24lambda_u244;
        Point point = this.main.getViewPosition();
        JBViewport jBViewport = this.main;
        boolean bl = false;
        jBViewport.setViewPosition(new Point(this.clampX(newX), $this$scrollTo_u24lambda_u244.y));
        this.refreshButtons();
    }

    private final void refreshButtons() {
        boolean contentTooWide = this.content.getWidth() >= this.main.getWidth();
        this.leftButton.setVisible(contentTooWide && this.main.getViewPosition().x > 0);
        this.rightButton.setVisible(contentTooWide && this.main.getViewPosition().x < this.getXMax());
    }

    @JvmOverloads
    public HorizontalScrollView(@NotNull JComponent content, int scrollSensitivity, @VisibleForTesting @NotNull AbstractButton leftButton) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)leftButton, (String)"leftButton");
        this(content, scrollSensitivity, leftButton, null, 8, null);
    }

    @JvmOverloads
    public HorizontalScrollView(@NotNull JComponent content, int scrollSensitivity) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this(content, scrollSensitivity, null, null, 12, null);
    }

    @JvmOverloads
    public HorizontalScrollView(@NotNull JComponent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this(content, 0, null, null, 14, null);
    }

    private static final void _init_$lambda$1(HorizontalScrollView this$0, int $scrollSensitivity, ActionEvent it) {
        this$0.scrollBy(-$scrollSensitivity);
    }

    private static final void _init_$lambda$2(HorizontalScrollView this$0, int $scrollSensitivity, ActionEvent it) {
        this$0.scrollBy($scrollSensitivity);
    }

    private static final void _init_$lambda$3(HorizontalScrollView this$0, int $scrollSensitivity, MouseWheelEvent it) {
        this$0.scrollBy(it.getScrollAmount() * it.getWheelRotation() * $scrollSensitivity / 2);
    }

    public static final /* synthetic */ void access$refreshButtons(HorizontalScrollView $this) {
        $this.refreshButtons();
    }
}

