/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.ui.TextAccessor;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextAccessors {
    private TextAccessors() {
    }

    @Nullable
    public static TextAccessor getTextAccessor(@NotNull JComponent component2) {
        if (component2 instanceof TextAccessor) {
            return (TextAccessor)component2;
        }
        if (component2 instanceof JTextComponent) {
            return new JTextComponentTextAccessor(component2);
        }
        if (component2 instanceof JLabel) {
            return new JLabelTextAccessor((JLabel)component2);
        }
        if (component2 instanceof AbstractButton) {
            return new AbstractButtonTextAccessor((AbstractButton)component2);
        }
        if (component2 instanceof ActionButton) {
            return new ActionButtonTextAccessor((ActionButton)component2);
        }
        return null;
    }

    private static class JTextComponentTextAccessor
    implements TextAccessor {
        private final JComponent myComponent;

        public JTextComponentTextAccessor(JComponent component2) {
            this.myComponent = component2;
        }

        public String getText() {
            return ((JTextComponent)this.myComponent).getText();
        }

        public void setText(String text) {
            ((JTextComponent)this.myComponent).setText(text);
        }
    }

    private static class JLabelTextAccessor
    implements TextAccessor {
        private final JLabel myComponent;

        public JLabelTextAccessor(JLabel component2) {
            this.myComponent = component2;
        }

        public String getText() {
            return this.myComponent.getText();
        }

        public void setText(String text) {
            this.myComponent.setText(text);
        }
    }

    private static class AbstractButtonTextAccessor
    implements TextAccessor {
        private final AbstractButton myComponent;

        public AbstractButtonTextAccessor(AbstractButton component2) {
            this.myComponent = component2;
        }

        public String getText() {
            return this.myComponent.getText();
        }

        public void setText(String text) {
            this.myComponent.setText(text);
        }
    }

    private static class ActionButtonTextAccessor
    implements TextAccessor {
        private final ActionButton myComponent;

        public ActionButtonTextAccessor(ActionButton component2) {
            this.myComponent = component2;
        }

        public String getText() {
            return this.myComponent.getAction().getTemplatePresentation().getText();
        }

        public void setText(String text) {
            throw new UnsupportedOperationException("Setting ActionButton text via TextAccessor isn't supported.");
        }
    }
}

