/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.TreeWalker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.intellij.ui.components.JBLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TooltipLabel
extends JBLabel {
    private static final String PROPERTY_FOCUS_OWNER = "focusOwner";
    @Nullable
    private Container myScope;

    public TooltipLabel() {
        PropertyChangeListener focusListener2 = evt -> {
            if (evt.getNewValue() instanceof Component) {
                Component component2 = (Component)evt.getNewValue();
                super.setText(Strings.nullToEmpty((String)this.getTooltip(component2)));
            }
        };
        this.addHierarchyListener(e -> {
            if ((e.getChangeFlags() & 4L) == 0L) {
                return;
            }
            if (this.isShowing()) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(PROPERTY_FOCUS_OWNER, focusListener2);
            } else {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(PROPERTY_FOCUS_OWNER, focusListener2);
            }
        });
    }

    public void setText(String text) {
    }

    public void setScope(@Nullable Container scope) {
        this.myScope = scope;
    }

    private boolean isInScope(@NotNull Component component2) {
        if (this.myScope == null) {
            return true;
        }
        return TreeWalker.isAncestor(this.myScope, component2);
    }

    @VisibleForTesting
    @Nullable
    String getTooltip(@NotNull Component component2) {
        if (!this.isInScope(component2)) {
            return null;
        }
        String tooltip = null;
        TreeWalker treeWalker = new TreeWalker(component2);
        for (Component c : treeWalker.ancestors()) {
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                tooltip = jc.getToolTipText();
            }
            if (c != this.myScope && tooltip == null) continue;
            break;
        }
        return tooltip;
    }
}

