/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.actions;

import com.intellij.ide.HelpTooltip;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DropDownAction
extends DefaultActionGroup
implements CustomComponentAction {
    private static final Icon BLANK_ICON = new Icon(){

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 0;
        }
    };

    public DropDownAction(@Nullable String title, @Nullable String description, @Nullable Icon icon) {
        super(title, true);
        Presentation presentation = this.getTemplatePresentation();
        presentation.setPerformGroup(true);
        presentation.setDescription(description);
        if (icon != null) {
            presentation.setIcon(icon);
        } else {
            presentation.setIcon(BLANK_ICON);
            presentation.setDisabledIcon(BLANK_ICON);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent eve) {
        ActionButton button = DropDownAction.getActionButton(eve);
        this.updateActions(eve.getDataContext());
        if (this.getChildrenCount() == 0) {
            return;
        }
        if (button == null) {
            if (!this.isPerformableWithoutActionButton()) {
                return;
            }
            this.updateActions(eve.getDataContext());
            JPanel componentPopup = this.createCustomComponentPopup();
            Object popup = componentPopup != null ? JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)componentPopup, (JComponent)componentPopup).createPopup() : JBPopupFactory.getInstance().createActionGroupPopup(eve.getPresentation().getText(), (ActionGroup)this, eve.getDataContext(), false, null, 10);
            Project project = eve.getProject();
            if (project != null) {
                popup.showCenteredInCurrentWindow(project);
            } else {
                popup.showInBestPositionFor(eve.getDataContext());
            }
        } else {
            JPanel componentPopup = this.createCustomComponentPopup();
            if (componentPopup == null) {
                this.showPopupMenu(eve, button);
            } else {
                JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)componentPopup, (JComponent)componentPopup).createPopup();
                Component owner = eve.getInputEvent().getComponent();
                Point location = owner.getLocationOnScreen();
                location.translate(0, owner.getHeight());
                popup.showInScreenCoordinates(owner, location);
                popup.moveToFitScreen();
            }
        }
    }

    protected boolean isPerformableWithoutActionButton() {
        return false;
    }

    protected void showPopupMenu(@NotNull AnActionEvent eve, @NotNull ActionButton button) {
        ActionManagerImpl am = (ActionManagerImpl)ActionManager.getInstance();
        ActionPopupMenu popUpMenu = am.createActionPopupMenu(eve.getPlace(), (ActionGroup)this);
        popUpMenu.setDataContext(() -> ((AnActionEvent)eve).getDataContext());
        JBPopupMenu.showBelow((Component)button, (JPopupMenu)popUpMenu.getComponent());
    }

    private static ActionButton getActionButton(@NotNull AnActionEvent eve) {
        return (ActionButton)eve.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (Boolean.TRUE.equals(presentation.getClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR))) {
            return new ActionButtonWithText((AnAction)this, presentation, "toolbar", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        }
        return new ActionButton((AnAction)this, presentation, "toolbar", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            protected void updateToolTipText() {
                String description = this.myPresentation.getDescription();
                if (UISettings.isIdeHelpTooltipEnabled()) {
                    HelpTooltip.dispose((Component)((Object)this));
                    if (StringUtil.isNotEmpty((String)description)) {
                        new HelpTooltip().setDescription(description).installOn((JComponent)((Object)this));
                    }
                } else {
                    this.setToolTipText(description);
                }
            }
        };
    }

    @Nullable
    protected JPanel createCustomComponentPopup() {
        return null;
    }

    protected boolean updateActions(@NotNull DataContext context) {
        return false;
    }
}

