/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.device;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBFont;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class ScreenDiagram
extends JPanel {
    private static final Font FIGURE_FONT = JBFont.create((Font)new Font("DroidSans", 0, 10));
    private static final Color GRAY = new JBColor((Color)Gray._192, (Color)Gray._96);
    private int width;
    private int height;

    public ScreenDiagram() {
        this(0, 0);
    }

    public ScreenDiagram(int width, int height) {
        this.setDimensions(width, height);
    }

    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
        this.setVisible(width > 0 && height > 0);
        this.repaint();
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        Dimension size = super.getMaximumSize();
        size.height = Math.min(size.height, JBUIScale.scale((int)200));
        return size;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        size.width = Math.max(size.width, JBUIScale.scale((int)120));
        size.height = Math.max(size.height, JBUIScale.scale((int)120));
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(@NotNull Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2d = null;
        try {
            graphics2d = (Graphics2D)graphics.create();
            graphics2d.setFont(FIGURE_FONT);
            GraphicsUtil.setupAAPainting((Graphics)graphics2d);
            GraphicsUtil.setupAntialiasing((Graphics)graphics2d);
            Dimension dimension = this.getScaledDimension(graphics2d);
            this.paintWidth(graphics2d, dimension);
            this.paintScreen(graphics2d, dimension);
            this.paintHeight(graphics2d, dimension);
        }
        finally {
            if (graphics2d != null) {
                graphics2d.dispose();
            }
        }
    }

    @NotNull
    private Dimension getScaledDimension(@NotNull Graphics graphics) {
        int height;
        int width;
        double sideRatio;
        FontMetrics metrics = graphics.getFontMetrics(FIGURE_FONT);
        double maxWidth = (double)(this.getWidth() - metrics.stringWidth("0000 dp") - ScreenDiagram.getFigurePadding()) - (double)ScreenDiagram.getOutlineLineWidth() / 2.0 - (double)ScreenDiagram.getLeftPadding();
        double maxHeight = (double)(this.getHeight() - metrics.getHeight() - ScreenDiagram.getFigurePadding()) - (double)ScreenDiagram.getOutlineLineWidth() / 2.0;
        if (maxHeight * (sideRatio = (double)this.width / (double)this.height) > maxWidth) {
            width = (int)maxWidth;
            height = (int)(maxWidth / sideRatio);
        } else {
            width = (int)(maxHeight * sideRatio);
            height = (int)maxHeight;
        }
        return new Dimension(Math.max(width, 1), Math.max(height, 1));
    }

    private void paintWidth(@NotNull Graphics2D graphics2d, @NotNull Dimension scaledDimension) {
        graphics2d.setColor(GRAY);
        graphics2d.setStroke(new BasicStroke(ScreenDiagram.getDimensionLineWidth()));
        FontMetrics metrics = graphics2d.getFontMetrics(FIGURE_FONT);
        int lineY = metrics.getHeight() / 2;
        graphics2d.drawLine(ScreenDiagram.getLeftPadding(), lineY, ScreenDiagram.round(ScreenDiagram.getLeftPadding() + scaledDimension.width), lineY);
        graphics2d.setColor(this.getBackground());
        String text = this.width + " dp";
        int textWidth = metrics.stringWidth(text);
        int textX = ScreenDiagram.round((double)ScreenDiagram.getLeftPadding() + (double)(scaledDimension.width - textWidth) / 2.0);
        graphics2d.drawLine(textX - ScreenDiagram.getFigurePadding(), lineY, textX + textWidth + ScreenDiagram.getFigurePadding(), lineY);
        graphics2d.setColor(this.getForeground());
        graphics2d.drawString(text, textX, metrics.getHeight() - metrics.getDescent());
    }

    private void paintScreen(@NotNull Graphics2D graphics2d, @NotNull Dimension scaledDimension) {
        graphics2d.setColor(this.getForeground());
        graphics2d.setStroke(new BasicStroke(ScreenDiagram.getOutlineLineWidth()));
        int y = graphics2d.getFontMetrics(FIGURE_FONT).getHeight() + JBUIScale.scale((int)ScreenDiagram.getFigurePadding());
        RoundRectangle2D.Double shape = new RoundRectangle2D.Double(ScreenDiagram.getLeftPadding(), y, scaledDimension.width, scaledDimension.height, JBUIScale.scale((int)10), JBUIScale.scale((int)10));
        graphics2d.draw(shape);
    }

    private void paintHeight(@NotNull Graphics2D graphics2d, @NotNull Dimension scaledDimension) {
        graphics2d.setColor(GRAY);
        graphics2d.setStroke(new BasicStroke(ScreenDiagram.getDimensionLineWidth()));
        FontMetrics metrics = graphics2d.getFontMetrics(FIGURE_FONT);
        int lineX = ScreenDiagram.round(ScreenDiagram.getLeftPadding() + scaledDimension.width + JBUIScale.scale((int)15));
        int rectangleOffsetY = metrics.getHeight() + ScreenDiagram.getFigurePadding();
        graphics2d.drawLine(lineX, JBUIScale.scale((int)rectangleOffsetY), lineX, ScreenDiagram.round(JBUIScale.scale((int)rectangleOffsetY) + scaledDimension.height));
        graphics2d.setColor(this.getBackground());
        int textHeight = metrics.getHeight() - metrics.getDescent();
        int textY = ScreenDiagram.round((double)JBUIScale.scale((int)rectangleOffsetY) + (double)(scaledDimension.height + textHeight) / 2.0);
        graphics2d.drawLine(lineX, textY + ScreenDiagram.getFigurePadding(), lineX, textY - textHeight - ScreenDiagram.getFigurePadding());
        graphics2d.setColor(this.getForeground());
        graphics2d.drawString(this.height + " dp", lineX - JBUIScale.scale((int)10), textY);
    }

    private static int getFigurePadding() {
        return JBUIScale.scale((int)3);
    }

    private static int getOutlineLineWidth() {
        return JBUIScale.scale((int)5);
    }

    private static int getLeftPadding() {
        return JBUIScale.scale((int)3);
    }

    private static int getDimensionLineWidth() {
        return JBUIScale.scale((int)1);
    }

    private static int round(double d) {
        return (int)Math.round(d);
    }
}

