/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.event;

import com.intellij.util.ui.MouseEventHandler;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class DelegateMouseEventHandler
extends MouseEventHandler {
    @NotNull
    private final Component myTargetComponent;

    private DelegateMouseEventHandler(@NotNull Component targetComponent) {
        this.myTargetComponent = targetComponent;
    }

    @NotNull
    public DelegateMouseEventHandler installListenerOn(@NotNull Component sourceComponent) {
        sourceComponent.addMouseListener((MouseListener)((Object)this));
        return this;
    }

    @NotNull
    public DelegateMouseEventHandler installMotionListenerOn(@NotNull Component sourceComponent) {
        sourceComponent.addMouseMotionListener((MouseMotionListener)((Object)this));
        return this;
    }

    @NotNull
    public DelegateMouseEventHandler installMouseWheelListenerOn(@NotNull Component sourceComponent) {
        sourceComponent.addMouseWheelListener((MouseWheelListener)((Object)this));
        return this;
    }

    @NotNull
    public static DelegateMouseEventHandler delegateTo(@NotNull Component targetComponent) {
        return new DelegateMouseEventHandler(targetComponent);
    }

    protected void handle(MouseEvent event) {
        this.myTargetComponent.dispatchEvent(SwingUtilities.convertMouseEvent(event.getComponent(), event, this.myTargetComponent));
    }
}

