/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.filter;

import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Filter {
    public static final Filter EMPTY_FILTER = new Filter();
    @NotNull
    private final String myFilterString;
    private final boolean myIsMatchCase;
    private final boolean myIsRegex;
    @Nullable
    private final Pattern myPattern;

    public Filter() {
        this("");
    }

    public Filter(@NotNull String filterString) {
        this(filterString, false, false);
    }

    public Filter(@NotNull String filterString, boolean isMatchCase, boolean isRegex) {
        this.myFilterString = filterString;
        this.myIsMatchCase = isMatchCase;
        this.myIsRegex = isRegex;
        this.myPattern = this.createFilterPattern();
    }

    @NotNull
    public String getFilterString() {
        return this.myFilterString;
    }

    public boolean isMatchCase() {
        return this.myIsMatchCase;
    }

    public boolean isRegex() {
        return this.myIsRegex;
    }

    public boolean isEmpty() {
        return this.myPattern == null;
    }

    public boolean matches(@NotNull String string) {
        return this.myPattern == null || this.myPattern.matcher(string).matches();
    }

    @Nullable
    private Pattern createFilterPattern() {
        int flags = this.myIsMatchCase ? 0 : 2;
        Pattern pattern = null;
        if (!this.myFilterString.isEmpty()) {
            block5: {
                if (this.myIsRegex) {
                    try {
                        pattern = Pattern.compile("^.*" + this.myFilterString + ".*$", flags);
                    }
                    catch (PatternSyntaxException e) {
                        if ($assertionsDisabled || e.getMessage() != null) break block5;
                        throw new AssertionError();
                    }
                }
            }
            if (pattern == null) {
                pattern = Pattern.compile("^.*" + Pattern.quote(this.myFilterString) + ".*$", flags);
            }
        }
        return pattern;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Filter) {
            Filter filter = (Filter)obj;
            if (this.myPattern == null) {
                return filter.myPattern == null;
            }
            return this.myPattern.pattern().equals(filter.myPattern) && this.myPattern.flags() == filter.myPattern.flags();
        }
        return false;
    }

    public int hashCode() {
        return this.myPattern == null ? 0 : Objects.hash(this.myPattern.pattern(), this.myPattern.flags());
    }
}

