/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.status;

import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.adtui.status.InformationPopup;
import com.android.tools.adtui.status.InformationPopupKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.NewUI;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.AnActionLink;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 82\u00020\u0001:\u00018B5\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010$\u001a\u00020\u0017H\u0016J\u0018\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001fH\u0016J\b\u0010)\u001a\u00020\u000eH\u0016J\b\u0010*\u001a\u00020\u0017H\u0016J\u0018\u0010+\u001a\u00020,2\u0006\u0010(\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.H\u0002J\u0014\u0010/\u001a\u00020\u000e*\u0002002\u0006\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u00020.H\u0002J$\u00104\u001a\u0002052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002JD\u00106\u001a\u00020\u001f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u00107\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002R\u001e\u0010\r\u001a\u00020\u000e8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b \u0010!\u00a8\u00069"}, d2={"Lcom/android/tools/adtui/status/InformationPopupImpl;", "Lcom/android/tools/adtui/status/InformationPopup;", "title", "", "description", "additionalActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "links", "", "Lcom/intellij/ui/components/AnActionLink;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/Collection;)V", "hasEnteredPopup", "", "getHasEnteredPopup$intellij_android_adt_ui", "()Z", "setHasEnteredPopup$intellij_android_adt_ui", "(Z)V", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "onMouseEnteredCallback", "Lkotlin/Function0;", "", "getOnMouseEnteredCallback", "()Lkotlin/jvm/functions/Function0;", "setOnMouseEnteredCallback", "(Lkotlin/jvm/functions/Function0;)V", "hidePopupTimer", "Ljavax/swing/Timer;", "popupComponent", "Ljavax/swing/JComponent;", "getPopupComponent", "()Ljavax/swing/JComponent;", "popupComponent$delegate", "Lkotlin/Lazy;", "hidePopup", "showPopup", "disposableParent", "Lcom/intellij/openapi/Disposable;", "owner", "isVisible", "dispose", "getPointToShowPopupInWindow", "Lcom/intellij/ui/awt/RelativePoint;", "size", "Ljava/awt/Dimension;", "isIntoArea", "Ljava/awt/Point;", "component", "Ljava/awt/Component;", "getPopupPreferredSize", "createLinksBar", "Ljavax/swing/JPanel;", "createContentPanel", "details", "Companion", "intellij.android.adt.ui"})
@SourceDebugExtension(value={"SMAP\nInformationPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InformationPopup.kt\ncom/android/tools/adtui/status/InformationPopupImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 UiUtils.kt\ncom/intellij/openapi/ui/UiUtils\n*L\n1#1,336:1\n1872#2,3:337\n56#3:340\n*S KotlinDebug\n*F\n+ 1 InformationPopup.kt\ncom/android/tools/adtui/status/InformationPopupImpl\n*L\n240#1:337,3\n243#1:340\n*E\n"})
public final class InformationPopupImpl
implements InformationPopup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @VisibleForTesting
    private boolean hasEnteredPopup;
    @Nullable
    private JBPopup popup;
    @NotNull
    private Function0<Unit> onMouseEnteredCallback;
    @NotNull
    private final Timer hidePopupTimer;
    @NotNull
    private final Lazy popupComponent$delegate;
    private static final int POPUP_PADDING = 6;
    private static final int POPUP_MIN_WIDTH = 296;
    private static final int POPUP_CONTENT_PADDING = 10;
    private static final int POPUP_LINK_SEPARATOR_WIDTH = 15;
    private static final int POPUP_LINK_PADDING_TOP_AND_BOTTOM = 4;
    private static final int POPUP_LINK_PADDING_LEFT_AND_RIGHT = 10;
    private static final int POPUP_DESCRIPTION_TOP_AND_BOTTOM_INDENT = 10;
    private static final int POPUP_DESCRIPTION_LEFT_INDENT = 10;
    private static final int POPUP_DESCRIPTION_RIGHT_INDENT = 6;
    private static final int POPUP_DISMISS_TIMEOUT_MS = 400;

    public InformationPopupImpl(@Nullable String title, @NotNull String description, @NotNull List<? extends AnAction> additionalActions, @NotNull Collection<? extends AnActionLink> links) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(additionalActions, (String)"additionalActions");
        Intrinsics.checkNotNullParameter(links, (String)"links");
        this.onMouseEnteredCallback = InformationPopupImpl::onMouseEnteredCallback$lambda$0;
        this.hidePopupTimer = new Timer(400, arg_0 -> InformationPopupImpl.hidePopupTimer$lambda$1(this, arg_0));
        this.popupComponent$delegate = LazyKt.lazy(() -> InformationPopupImpl.popupComponent_delegate$lambda$3(this, title, description, additionalActions, links));
    }

    public final boolean getHasEnteredPopup$intellij_android_adt_ui() {
        return this.hasEnteredPopup;
    }

    public final void setHasEnteredPopup$intellij_android_adt_ui(boolean bl) {
        this.hasEnteredPopup = bl;
    }

    @Override
    @NotNull
    public Function0<Unit> getOnMouseEnteredCallback() {
        return this.onMouseEnteredCallback;
    }

    @Override
    public void setOnMouseEnteredCallback(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.onMouseEnteredCallback = function0;
    }

    @Override
    @NotNull
    public JComponent getPopupComponent() {
        Lazy lazy = this.popupComponent$delegate;
        return (JComponent)lazy.getValue();
    }

    @Override
    public void hidePopup() {
        JBPopup jBPopup = this.popup;
        boolean bl = jBPopup != null ? !jBPopup.isDisposed() : false;
        if (bl) {
            Disposer.dispose((Disposable)this);
        }
        this.hidePopupTimer.stop();
    }

    @Override
    public void showPopup(@NotNull Disposable disposableParent, @NotNull JComponent owner) {
        JBPopup newPopup;
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Dimension size = this.getPopupPreferredSize();
        UIUtil.setFosterParent((JComponent)this.getPopupComponent(), (Component)owner);
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(this.getPopupComponent(), null).setCancelOnClickOutside(true).setCancelOnWindowDeactivation(true).setCancelOnMouseOutCallback(arg_0 -> InformationPopupImpl.showPopup$lambda$5(this, owner, arg_0)).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        this.popup = newPopup = jBPopup;
        Disposer.register((Disposable)disposableParent, (Disposable)((Disposable)newPopup));
        RelativePoint point = this.getPointToShowPopupInWindow(owner, size);
        newPopup.setSize(size);
        newPopup.show(point);
    }

    @Override
    public boolean isVisible() {
        JBPopup jBPopup = this.popup;
        return jBPopup != null ? jBPopup.isVisible() : false;
    }

    public void dispose() {
        JBPopup jBPopup = this.popup;
        if (jBPopup != null) {
            jBPopup.cancel();
        }
        this.popup = null;
    }

    private final RelativePoint getPointToShowPopupInWindow(JComponent owner, Dimension size) {
        return new RelativePoint((Component)owner, new Point(owner.getWidth() - owner.getInsets().right + JBUIScale.scale((int)6) - size.width, owner.getHeight() + JBUIScale.scale((int)6)));
    }

    private final boolean isIntoArea(Point $this$isIntoArea, Component component2) {
        int padding = (int)(JBUIScale.sysScale() * (float)6);
        return new Rectangle(-padding, -padding, component2.getWidth() + 2 * padding, component2.getHeight() + 2 * padding).contains($this$isIntoArea);
    }

    private final Dimension getPopupPreferredSize() {
        Dimension dimension = this.getPopupComponent().getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        Dimension size = dimension;
        size.width = RangesKt.coerceAtLeast((int)size.width, (int)JBUIScale.scale((int)296));
        return size;
    }

    /*
     * WARNING - void declaration
     */
    private final JPanel createLinksBar(Collection<? extends AnActionLink> links, Function0<Unit> hidePopup) {
        JPanel jPanel;
        JPanel $this$createLinksBar_u24lambda_u246 = jPanel = new JPanel();
        boolean bl = false;
        $this$createLinksBar_u24lambda_u246.setLayout(new BoxLayout($this$createLinksBar_u24lambda_u246, 2));
        JPanel panel = jPanel;
        Iterable $this$forEachIndexed$iv = links;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void linkLabel;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AnActionLink anActionLink = (AnActionLink)item$iv;
            int index = n;
            boolean bl2 = false;
            if (index != 0) {
                panel.add(Box.createHorizontalStrut(JBUI.scale((int)15)));
            }
            linkLabel.addActionListener(arg_0 -> InformationPopupImpl.createLinksBar$lambda$9$lambda$8((AnActionLink)linkLabel, hidePopup, arg_0));
            panel.add((Component)linkLabel);
        }
        panel.add(Box.createHorizontalGlue());
        panel.setOpaque(true);
        panel.setBackground(UIUtil.getToolTipActionBackground());
        panel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        return panel;
    }

    private final JComponent createContentPanel(String title, String details, List<? extends AnAction> additionalActions, Collection<? extends AnActionLink> links, Function0<Unit> hidePopup) {
        JPanel jPanel;
        JPanel it = jPanel = new JPanel(new GridBagLayout());
        boolean bl = false;
        it.setOpaque(true);
        it.setBackground(NewUI.isEnabled() ? JBUI.CurrentTheme.Editor.Tooltip.BACKGROUND : UIUtil.getToolTipBackground());
        JPanel content = jPanel;
        GridBag gc = new GridBag();
        if (title != null) {
            gc.nextLine().next().anchor(21).weightx(1.0).fillCellHorizontally().insets(10, 10, 10, 0);
            content.add((Component)new JLabel(XmlStringUtil.wrapInHtml((CharSequence)title)), gc);
        }
        gc.nextLine().next().anchor(21).fillCellHorizontally().weightx(1.0).insets(10, 10, 10, 6);
        content.add((Component)new JLabel(XmlStringUtil.wrapInHtml((CharSequence)details)), gc);
        if (!((Collection)additionalActions).isEmpty()) {
            DropDownAction dropDownAction;
            Presentation presentation = new Presentation();
            presentation.setIcon(AllIcons.Actions.More);
            presentation.putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)true);
            DropDownAction it2 = dropDownAction = new DropDownAction(null, null, AllIcons.Actions.More);
            boolean bl2 = false;
            it2.addAll(additionalActions);
            DropDownAction dropDownAction2 = dropDownAction;
            ActionButton menuButton = new ActionButton((AnAction)dropDownAction2, presentation, "EditorPopup", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            menuButton.getPresentation().putClientProperty(CustomComponentAction.COMPONENT_KEY, (Object)menuButton);
            content.add((Component)menuButton, gc.next().anchor(22).weightx(0.0).insets(10, 6, 10, 6));
        }
        if (!links.isEmpty()) {
            content.add((Component)this.createLinksBar(links, hidePopup), gc.nextLine().next().anchor(21).fillCellHorizontally().coverLine().weightx(1.0));
        }
        return content;
    }

    private static final Unit onMouseEnteredCallback$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final void hidePopupTimer$lambda$1(InformationPopupImpl this$0, ActionEvent it) {
        this$0.hidePopup();
    }

    private static final JComponent popupComponent_delegate$lambda$3(InformationPopupImpl this$0, String $title, String $description, List $additionalActions, Collection $links) {
        JComponent jComponent;
        JComponent $this$popupComponent_delegate_u24lambda_u243_u24lambda_u242 = jComponent = this$0.createContentPanel($title, $description, $additionalActions, $links, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this$0){

            public final void invoke() {
                ((InformationPopupImpl)this.receiver).hidePopup();
            }
        }));
        boolean bl = false;
        $this$popupComponent_delegate_u24lambda_u243_u24lambda_u242.addMouseListener(new MouseAdapter(this$0){
            final /* synthetic */ InformationPopupImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseEntered(MouseEvent e) {
                this.this$0.getOnMouseEnteredCallback().invoke();
                this.this$0.setHasEnteredPopup$intellij_android_adt_ui(true);
                InformationPopupImpl.access$getHidePopupTimer$p(this.this$0).stop();
            }
        });
        return jComponent;
    }

    private static final boolean showPopup$lambda$5(InformationPopupImpl this$0, JComponent $owner, MouseEvent e) {
        if (!this$0.hasEnteredPopup) {
            Point point = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), $owner);
            Intrinsics.checkNotNull((Object)point);
            if (!this$0.isIntoArea(point, $owner)) {
                this$0.hidePopupTimer.start();
            }
            this$0.hasEnteredPopup = false;
            return false;
        }
        JBPopup jBPopup = this$0.popup;
        if (jBPopup != null) {
            JBPopup openPopup = jBPopup;
            boolean bl = false;
            Window popupWindow = SwingUtilities.getWindowAncestor(openPopup.getContent());
            Window currentWindow = SwingUtilities.getWindowAncestor(e.getComponent());
            if (popupWindow != null && currentWindow != null && !Intrinsics.areEqual((Object)currentWindow, (Object)popupWindow)) {
                Window[] windowArray = popupWindow.getOwnedWindows();
                Intrinsics.checkNotNullExpressionValue((Object)windowArray, (String)"getOwnedWindows(...)");
                if (!ArraysKt.contains((Object[])windowArray, (Object)currentWindow)) {
                    this$0.hidePopupTimer.start();
                }
            }
        } else {
            this$0.hidePopupTimer.start();
        }
        return false;
    }

    private static final Unit createLinksBar$lambda$9$lambda$8$lambda$7(Function0 $hidePopup) {
        $hidePopup.invoke();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void createLinksBar$lambda$9$lambda$8(AnActionLink $linkLabel, Function0 $hidePopup, ActionEvent it) {
        void $this$getUserData$iv;
        JComponent jComponent = (JComponent)$linkLabel;
        Key<Boolean> key$iv = InformationPopupKt.getPOPUP_ACTION();
        boolean $i$f$getUserData = false;
        Object object = $this$getUserData$iv.getClientProperty(key$iv);
        if (!(object instanceof Boolean)) {
            object = null;
        }
        if (!Intrinsics.areEqual((Object)((Boolean)object), (Object)true)) {
            ActionsKt.invokeLater$default(null, () -> InformationPopupImpl.createLinksBar$lambda$9$lambda$8$lambda$7($hidePopup), (int)1, null);
        }
    }

    public static final /* synthetic */ Timer access$getHidePopupTimer$p(InformationPopupImpl $this) {
        return $this.hidePopupTimer;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/adtui/status/InformationPopupImpl$Companion;", "", "<init>", "()V", "POPUP_PADDING", "", "POPUP_MIN_WIDTH", "POPUP_CONTENT_PADDING", "POPUP_LINK_SEPARATOR_WIDTH", "POPUP_LINK_PADDING_TOP_AND_BOTTOM", "POPUP_LINK_PADDING_LEFT_AND_RIGHT", "POPUP_DESCRIPTION_TOP_AND_BOTTOM_INDENT", "POPUP_DESCRIPTION_LEFT_INDENT", "POPUP_DESCRIPTION_RIGHT_INDENT", "POPUP_DISMISS_TIMEOUT_MS", "intellij.android.adt.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

