/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.stdui.ContextMenuItem;
import com.intellij.openapi.keymap.KeymapUtil;
import java.awt.event.ActionEvent;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultContextMenuItem
implements ContextMenuItem {
    @NotNull
    private final Supplier<String> myText;
    @NotNull
    private final Runnable myActionRunnable;
    @NotNull
    private final BooleanSupplier myEnableBooleanSupplier;
    @NotNull
    private final KeyStroke[] myKeyStrokes;
    @Nullable
    private final Supplier<Icon> myIcon;

    private DefaultContextMenuItem(Builder builder) {
        this.myText = builder.myText;
        this.myActionRunnable = builder.myActionRunnable;
        this.myEnableBooleanSupplier = builder.myEnableBooleanSupplier;
        this.myKeyStrokes = builder.myKeyStrokes;
        this.myIcon = builder.myIcon;
        JComponent containerComponent = builder.myContainerComponent;
        if (containerComponent == null || this.myKeyStrokes.length == 0) {
            return;
        }
        InputMap inputMap = containerComponent.getInputMap(1);
        ActionMap actionMap = containerComponent.getActionMap();
        String label2 = this.getDefaultToolTipText();
        for (KeyStroke keyStroke : this.myKeyStrokes) {
            inputMap.put(keyStroke, label2);
        }
        actionMap.put(label2, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.isEnabled()) {
                    DefaultContextMenuItem.this.run();
                }
            }
        });
    }

    @Override
    @NotNull
    public String getText() {
        return this.myText.get();
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.myIcon == null ? null : this.myIcon.get();
    }

    @Override
    public boolean isEnabled() {
        return this.myEnableBooleanSupplier.getAsBoolean();
    }

    @Override
    @NotNull
    public KeyStroke[] getKeyStrokes() {
        return this.myKeyStrokes;
    }

    @Override
    public void run() {
        this.myActionRunnable.run();
    }

    public String getDefaultToolTipText() {
        String text = this.myText.get();
        if (this.myKeyStrokes.length != 0) {
            return text + " (" + KeymapUtil.getKeystrokeText((KeyStroke)this.myKeyStrokes[0]) + ")";
        }
        return text;
    }

    public static class Builder {
        @NotNull
        private Runnable myActionRunnable;
        @NotNull
        private BooleanSupplier myEnableBooleanSupplier;
        @NotNull
        private Supplier<String> myText;
        @NotNull
        private KeyStroke[] myKeyStrokes;
        @Nullable
        private Supplier<Icon> myIcon;
        @Nullable
        private JComponent myContainerComponent;

        public Builder(@NotNull String text) {
            this(() -> text);
        }

        public Builder(@NotNull Supplier<String> text) {
            this.myText = text;
            this.myActionRunnable = () -> {};
            this.myEnableBooleanSupplier = () -> true;
            this.myKeyStrokes = new KeyStroke[0];
        }

        public Builder setActionRunnable(@NotNull Runnable actionRunnable) {
            this.myActionRunnable = actionRunnable;
            return this;
        }

        public Builder setEnableBooleanSupplier(@NotNull BooleanSupplier enable) {
            this.myEnableBooleanSupplier = enable;
            return this;
        }

        public Builder setKeyStrokes(KeyStroke ... keyStrokes) {
            this.myKeyStrokes = keyStrokes;
            return this;
        }

        public Builder setIcon(@Nullable Icon icon) {
            return this.setIcon(() -> icon);
        }

        public Builder setIcon(@Nullable Supplier<Icon> icon) {
            this.myIcon = icon;
            return this;
        }

        public Builder setContainerComponent(@Nullable JComponent containerComponent) {
            this.myContainerComponent = containerComponent;
            return this;
        }

        public DefaultContextMenuItem build() {
            return new DefaultContextMenuItem(this);
        }
    }
}

