/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.model.stdui.CommonTextFieldModel;
import com.android.tools.adtui.model.stdui.EditingSupport;
import com.android.tools.adtui.stdui.CommonTextField;
import com.android.tools.adtui.stdui.DefaultLookupUI;
import com.android.tools.adtui.stdui.LookupKt;
import com.android.tools.adtui.stdui.LookupUI;
import com.android.tools.adtui.stdui.Matcher;
import com.intellij.ui.speedSearch.FilteringListModel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u001f\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000eJ\b\u0010#\u001a\u00020!H\u0002J\u0006\u0010&\u001a\u00020!J\u0006\u0010'\u001a\u00020!J\u0006\u0010(\u001a\u00020!J\u0006\u0010)\u001a\u00020!J\u0006\u0010*\u001a\u00020!J\u0006\u0010+\u001a\u00020!J\u0006\u0010,\u001a\u00020\u0016J\u0006\u0010-\u001a\u00020\u0016J\u0006\u0010.\u001a\u00020!J\u001a\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020\u00162\b\u00101\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u00102\u001a\u00020!H\u0002J\b\u00103\u001a\u00020!H\u0002J\b\u00104\u001a\u00020!H\u0002J\b\u00105\u001a\u000206H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u000e0\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u000e0\u000e0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010$\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001f\u00a8\u00067"}, d2={"Lcom/android/tools/adtui/stdui/Lookup;", "M", "Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;", "", "editor", "Lcom/android/tools/adtui/stdui/CommonTextField;", "ui", "Lcom/android/tools/adtui/stdui/LookupUI;", "<init>", "(Lcom/android/tools/adtui/stdui/CommonTextField;Lcom/android/tools/adtui/stdui/LookupUI;)V", "getEditor", "()Lcom/android/tools/adtui/stdui/CommonTextField;", "listModel", "Ljavax/swing/DefaultListModel;", "", "filteredModel", "Lcom/intellij/ui/speedSearch/FilteringListModel;", "kotlin.jvm.PlatformType", "matcher", "Lcom/android/tools/adtui/stdui/Matcher;", "condition", "Lkotlin/Function1;", "", "showBelow", "dataLoading", "dataLoaded", "lookupCancelled", "lastCompletionText", "Ljava/util/concurrent/atomic/AtomicReference;", "currentValueIncluded", "isVisible", "()Z", "showLookup", "", "forText", "updateFilter", "enabled", "getEnabled", "selectFirst", "selectLast", "selectNextPage", "selectPreviousPage", "selectNext", "selectPrevious", "enter", "escape", "close", "restoreSelection", "currentValueSelected", "oldSelectedItem", "hideLookup", "display", "updateFrameBounds", "computeLocation", "Ljava/awt/Point;", "intellij.android.adt.ui"})
@SourceDebugExtension(value={"SMAP\nLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lookup.kt\ncom/android/tools/adtui/stdui/Lookup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,470:1\n774#2:471\n865#2,2:472\n*S KotlinDebug\n*F\n+ 1 Lookup.kt\ncom/android/tools/adtui/stdui/Lookup\n*L\n141#1:471\n141#1:472,2\n*E\n"})
public final class Lookup<M extends CommonTextFieldModel> {
    @NotNull
    private final CommonTextField<M> editor;
    @NotNull
    private final LookupUI ui;
    @NotNull
    private final DefaultListModel<String> listModel;
    @NotNull
    private final FilteringListModel<String> filteredModel;
    @NotNull
    private Matcher matcher;
    @NotNull
    private final Function1<String, Boolean> condition;
    private boolean showBelow;
    private boolean dataLoading;
    private boolean dataLoaded;
    private boolean lookupCancelled;
    @NotNull
    private AtomicReference<String> lastCompletionText;
    private boolean currentValueIncluded;

    public Lookup(@NotNull CommonTextField<? extends M> editor, @NotNull LookupUI ui) {
        Intrinsics.checkNotNullParameter(editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        this.editor = editor;
        this.ui = ui;
        this.listModel = new DefaultListModel();
        this.filteredModel = new FilteringListModel((ListModel)this.listModel);
        this.matcher = new Matcher();
        this.condition = arg_0 -> Lookup.condition$lambda$0(this, arg_0);
        this.showBelow = true;
        this.lastCompletionText = new AtomicReference<String>("");
        FilteringListModel<String> filteringListModel = this.filteredModel;
        Intrinsics.checkNotNull(filteringListModel, (String)"null cannot be cast to non-null type javax.swing.ListModel<kotlin.String>");
        this.ui.createList((ListModel)filteringListModel, this.matcher, (JComponent)((Object)this.editor));
        this.ui.setClickAction((Function0<Unit>)((Function0)() -> Lookup._init_$lambda$1(this)));
        this.filteredModel.setFilter(arg_0 -> Lookup._init_$lambda$2(this.condition, arg_0));
    }

    public /* synthetic */ Lookup(CommonTextField commonTextField, LookupUI lookupUI, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            lookupUI = new DefaultLookupUI();
        }
        this(commonTextField, lookupUI);
    }

    @NotNull
    public final CommonTextField<M> getEditor() {
        return this.editor;
    }

    public final boolean isVisible() {
        return this.ui.getVisible();
    }

    public final void showLookup(@NotNull String forText) {
        Intrinsics.checkNotNullParameter((Object)forText, (String)"forText");
        EditingSupport support = this.editor.getEditorModel().getEditingSupport();
        if (this.dataLoaded && (!support.getAlwaysRefreshCompletions() || Intrinsics.areEqual((Object)forText, (Object)this.lastCompletionText.get()))) {
            this.updateFilter();
        } else {
            this.lookupCancelled = false;
            this.lastCompletionText.set(forText);
            support.getExecution().invoke(() -> Lookup.showLookup$lambda$5(this, support));
        }
    }

    private final void updateFilter() {
        boolean isCurrentValueSelected;
        String text = this.editor.getText();
        String oldSelectedValue = this.ui.getSelectedValue();
        boolean bl = isCurrentValueSelected = this.currentValueIncluded && this.ui.getSelectedIndex() == 0;
        if (this.currentValueIncluded && this.listModel.size() > 0) {
            this.listModel.set(0, text);
        }
        this.matcher.setPattern(text);
        this.filteredModel.refilter();
        int emptyListSize = this.currentValueIncluded ? 1 : 0;
        boolean hasMatchesToShow = this.filteredModel.getSize() > emptyListSize;
        if (hasMatchesToShow && !this.ui.getVisible()) {
            this.display();
        } else if (!hasMatchesToShow && this.ui.getVisible()) {
            this.hideLookup();
        } else if (hasMatchesToShow) {
            this.restoreSelection(isCurrentValueSelected, oldSelectedValue);
            this.updateFrameBounds();
        }
    }

    public final boolean getEnabled() {
        return this.isVisible() && this.filteredModel.getSize() > 0;
    }

    public final void selectFirst() {
        if (this.filteredModel.getSize() > 0) {
            this.ui.setSemiFocused(true);
            this.ui.setSelectedIndex(0);
        }
    }

    public final void selectLast() {
        if (this.filteredModel.getSize() > 0) {
            this.ui.setSemiFocused(true);
            this.ui.setSelectedIndex(this.filteredModel.getSize() - 1);
        }
    }

    public final void selectNextPage() {
        if (this.filteredModel.getSize() > 0) {
            this.ui.setSemiFocused(true);
            this.ui.setSelectedIndex(Math.min(this.ui.getSelectedIndex() + this.ui.getVisibleRowCount(), this.filteredModel.getSize() - 1));
        }
    }

    public final void selectPreviousPage() {
        if (this.filteredModel.getSize() > 0) {
            this.ui.setSemiFocused(true);
            this.ui.setSelectedIndex(Math.max(this.ui.getSelectedIndex() - this.ui.getVisibleRowCount(), 0));
        }
    }

    public final void selectNext() {
        if (this.filteredModel.getSize() > 0) {
            this.ui.setSemiFocused(true);
            this.ui.setSelectedIndex(LookupKt.access$modulo(this.ui.getSelectedIndex() + 1, this.filteredModel.getSize()));
        }
    }

    public final void selectPrevious() {
        if (this.filteredModel.getSize() > 0) {
            this.ui.setSemiFocused(true);
            this.ui.setSelectedIndex(LookupKt.access$modulo(this.ui.getSelectedIndex() - 1, this.filteredModel.getSize()));
        }
    }

    public final boolean enter() {
        if (!this.ui.getVisible()) {
            return false;
        }
        String string = this.ui.getSelectedValue();
        if (string == null) {
            return false;
        }
        String value = string;
        this.editor.setText(value);
        this.hideLookup();
        return true;
    }

    public final boolean escape() {
        if (!this.ui.getVisible()) {
            this.lookupCancelled = true;
            return false;
        }
        this.hideLookup();
        return true;
    }

    public final void close() {
        this.hideLookup();
        this.listModel.clear();
        this.dataLoaded = false;
    }

    private final void restoreSelection(boolean currentValueSelected, String oldSelectedItem) {
        if (oldSelectedItem != null && !currentValueSelected) {
            this.ui.setSelectedValue(oldSelectedItem);
        }
        if (this.ui.getSelectedIndex() < 0 || currentValueSelected) {
            this.ui.setSelectedIndex(0);
        }
    }

    private final void hideLookup() {
        this.lookupCancelled = true;
        this.showBelow = true;
        this.ui.hide();
        this.ui.setSemiFocused(false);
    }

    private final void display() {
        this.ui.updateLocation(this.computeLocation(), (JComponent)((Object)this.editor));
        this.ui.setSelectedIndex(0);
    }

    private final void updateFrameBounds() {
        this.ui.updateLocation(this.computeLocation(), (JComponent)((Object)this.editor));
    }

    private final Point computeLocation() {
        this.ui.setVisibleRowCount(Math.min(this.filteredModel.getSize(), 11));
        Dimension popupSize = this.ui.getPopupSize();
        Rectangle screenBounds = this.ui.screenBounds((JComponent)((Object)this.editor));
        Rectangle editorBounds = this.ui.editorBounds((JComponent)((Object)this.editor));
        int xPos = Math.max(Math.min(editorBounds.x, screenBounds.x + screenBounds.width - popupSize.width), screenBounds.x);
        int yPosAbove = editorBounds.y - popupSize.height;
        int yPosBelow = editorBounds.y + editorBounds.height;
        this.showBelow = !this.showBelow && yPosAbove > screenBounds.y ? false : (yPosBelow + popupSize.height < screenBounds.y + screenBounds.height ? true : yPosAbove <= screenBounds.y);
        Point point = this.showBelow ? new Point(xPos, yPosBelow) : new Point(xPos, yPosAbove);
        point.translate(-editorBounds.x, -editorBounds.y);
        return point;
    }

    private static final boolean condition$lambda$0(Lookup this$0, String element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this$0.matcher.matches(element);
    }

    private static final Unit _init_$lambda$1(Lookup this$0) {
        this$0.enter();
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void showLookup$lambda$5$lambda$4(Lookup this$0, Ref.ObjectRef $values, EditingSupport $support) {
        List updatedContent = new ArrayList();
        this$0.currentValueIncluded = false;
        if (!((Collection)$values.element).isEmpty()) {
            void $this$filterTo$iv$iv;
            String currentValue = this$0.editor.getText();
            if ($support.getAllowCustomValues()) {
                Intrinsics.checkNotNull((Object)currentValue);
                if (((CharSequence)currentValue).length() > 0) {
                    ((Collection)updatedContent).add(currentValue);
                    this$0.currentValueIncluded = true;
                }
            }
            Collection collection = updatedContent;
            Iterable $this$filter$iv = (Iterable)$values.element;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)currentValue))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
        }
        this$0.filteredModel.replaceAll(updatedContent);
        this$0.updateFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void showLookup$lambda$5(Lookup this$0, EditingSupport $support) {
        if (this$0.dataLoading) {
            return;
        }
        this$0.dataLoading = true;
        Ref.ObjectRef values = new Ref.ObjectRef();
        values.element = CollectionsKt.emptyList();
        boolean done = false;
        try {
            while (!done) {
                String lastText = this$0.lastCompletionText.get();
                Function1<String, List<String>> function1 = $support.getCompletion();
                Intrinsics.checkNotNull((Object)lastText);
                values.element = function1.invoke((Object)lastText);
                done = Intrinsics.areEqual((Object)lastText, (Object)this$0.lastCompletionText.get());
            }
        }
        finally {
            this$0.dataLoading = false;
        }
        if (this$0.lookupCancelled) {
            return;
        }
        this$0.dataLoaded = true;
        $support.getUiExecution().invoke(() -> Lookup.showLookup$lambda$5$lambda$4(this$0, values, $support));
    }
}

