/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui.menu;

import com.android.tools.adtui.model.stdui.CommonAction;
import com.android.tools.adtui.stdui.CommonToggleButton;
import com.android.tools.adtui.stdui.menu.CommonDropDownButtonUI;
import com.android.tools.adtui.stdui.menu.CommonMenu;
import com.android.tools.adtui.stdui.menu.CommonMenuItem;
import com.android.tools.adtui.stdui.menu.CommonPopupMenu;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.PopupMenuListenerAdapter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class CommonDropDownButton
extends CommonToggleButton
implements PropertyChangeListener {
    @NotNull
    private final CommonPopupMenu myPopup;
    @NotNull
    private final CommonAction myAction;

    public CommonDropDownButton(@NotNull CommonAction action) {
        super(action.getText(), action.getIcon());
        this.myAction = action;
        this.myPopup = new CommonPopupMenu();
        this.myPopup.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeInvisible(@NotNull PopupMenuEvent event) {
                CommonDropDownButton.this.setSelected(false);
            }

            public void popupMenuCanceled(@NotNull PopupMenuEvent event) {
                CommonDropDownButton.this.setSelected(false);
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent event) {
                CommonDropDownButton menu = CommonDropDownButton.this;
                if (menu.isSelected()) {
                    CommonDropDownButton.this.myAction.actionPerformed(event);
                    CommonDropDownButton.this.populatePopup();
                    JBPopupMenu.showBelow((Component)menu, (JPopupMenu)CommonDropDownButton.this.myPopup);
                }
            }
        });
        this.addPropertyChangeListenerRecursive(this.myAction);
    }

    @VisibleForTesting
    @NotNull
    JPopupMenu getPopup() {
        return this.myPopup;
    }

    @Override
    @NotNull
    public CommonAction getAction() {
        return this.myAction;
    }

    private void populatePopup() {
        this.myPopup.removeAll();
        List<CommonAction> actions = this.myAction.getChildrenActions();
        for (CommonAction action : actions) {
            JMenuItem menu;
            if (action instanceof CommonAction.SeparatorAction) {
                this.myPopup.addSeparator();
                continue;
            }
            if (action.getChildrenActionCount() == 0) {
                menu = new CommonMenuItem(action);
            } else {
                menu = new CommonMenu(action);
                this.populateMenuRecursive((CommonMenu)menu, action.getChildrenActions());
            }
            menu.setFont(this.getFont());
            this.myPopup.add(menu);
        }
        this.myPopup.pack();
    }

    private void populateMenuRecursive(@NotNull JMenu parent, @NotNull List<CommonAction> actions) {
        parent.removeAll();
        for (CommonAction action : actions) {
            JMenuItem menu;
            if (action instanceof CommonAction.SeparatorAction) {
                parent.addSeparator();
                continue;
            }
            if (action.getChildrenActionCount() == 0) {
                menu = new CommonMenuItem(action);
            } else {
                menu = new CommonMenu(action);
                this.populateMenuRecursive((CommonMenu)menu, action.getChildrenActions());
            }
            menu.setFont(this.getFont());
            parent.add(menu);
        }
    }

    @Override
    public void updateUI() {
        this.setUI(new CommonDropDownButtonUI());
        this.revalidate();
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        switch (event.getPropertyName()) {
            case "childrenActions": {
                List oldValues = (List)event.getOldValue();
                oldValues.forEach(action -> this.removePropertyChangeListenerRecursive((CommonAction)action));
                List newValues = (List)event.getNewValue();
                newValues.forEach(action -> this.addPropertyChangeListenerRecursive((CommonAction)action));
                if (!(event.getSource() instanceof CommonAction)) break;
                CommonAction sourceAction = (CommonAction)event.getSource();
                if (sourceAction == this.myAction) {
                    this.populatePopup();
                    break;
                }
                JMenuItem sourceMenuItem = this.findMenuRecursive(this.myPopup, sourceAction);
                if (!(sourceMenuItem instanceof JMenu)) break;
                JMenu sourceMenu = (JMenu)sourceMenuItem;
                this.populateMenuRecursive(sourceMenu, newValues);
                JPopupMenu sourcePopup = sourceMenu.getPopupMenu();
                if (!sourcePopup.isShowing()) break;
                sourcePopup.pack();
                break;
            }
            case "Name": 
            case "SmallIcon": 
            case "showExpandArrow": 
            case "isSelected": {
                break;
            }
        }
    }

    @VisibleForTesting
    @Nullable
    JMenuItem findMenuRecursive(@NotNull JPopupMenu popup, @NotNull CommonAction targetAction) {
        for (Component component2 : popup.getComponents()) {
            JMenuItem matchedChildMenuItem;
            if (!(component2 instanceof JMenuItem)) continue;
            JMenuItem jmenuItem = (JMenuItem)component2;
            if (jmenuItem.getAction() == targetAction) {
                return jmenuItem;
            }
            if (!(jmenuItem instanceof JMenu) || (matchedChildMenuItem = this.findMenuRecursive(((JMenu)jmenuItem).getPopupMenu(), targetAction)) == null) continue;
            return matchedChildMenuItem;
        }
        return null;
    }

    private void addPropertyChangeListenerRecursive(@NotNull CommonAction action) {
        action.addPropertyChangeListener(this);
        action.getChildrenActions().forEach(child -> this.addPropertyChangeListenerRecursive((CommonAction)child));
    }

    private void removePropertyChangeListenerRecursive(@NotNull CommonAction action) {
        action.removePropertyChangeListener(this);
        action.getChildrenActions().forEach(child -> this.removePropertyChangeListenerRecursive((CommonAction)child));
    }
}

