/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.table;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.NewUI;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Tables {
    private Tables() {
    }

    @NotNull
    public static Color getBackground(@NotNull JTable table, boolean selected) {
        if (selected) {
            return table.getSelectionBackground();
        }
        return table.getBackground();
    }

    @Nullable
    public static Border getBorder(boolean selected, boolean focused) {
        return Tables.getBorder(selected, focused, UIManager::getBorder);
    }

    @VisibleForTesting
    @Nullable
    static Border getBorder(boolean selected, boolean focused, @NotNull Function<Object, Border> getBorder) {
        if (!focused) {
            return getBorder.apply("Table.cellNoFocusBorder");
        }
        if (selected) {
            return getBorder.apply("Table.focusSelectedCellHighlightBorder");
        }
        return getBorder.apply("Table.focusCellHighlightBorder");
    }

    @NotNull
    public static Color getForeground(@NotNull JTable table, boolean selected) {
        if (selected) {
            return table.getSelectionForeground();
        }
        return table.getForeground();
    }

    @NotNull
    public static Icon getIcon(@NotNull JTable table, boolean selected, @NotNull Icon icon) {
        if (selected && !NewUI.isEnabled()) {
            return ColoredIconGenerator.INSTANCE.generateColoredIcon(icon, table.getSelectionForeground());
        }
        return icon;
    }

    public static void setWidths(@NotNull TableColumn column, int width) {
        column.setMinWidth(width);
        column.setMaxWidth(width);
        column.setPreferredWidth(width);
    }

    public static void setWidths(@NotNull TableColumn column, int width, int minWidth) {
        column.setMinWidth(minWidth);
        column.setMaxWidth(width);
        column.setPreferredWidth(width);
    }

    public static int getPreferredColumnWidth(@NotNull JTable table, int viewColumnIndex, int minPreferredWidth) {
        OptionalInt width = IntStream.range(-1, table.getRowCount()).map(viewRowIndex -> Tables.getPreferredCellWidth(table, viewRowIndex, viewColumnIndex)).max();
        if (!width.isPresent()) {
            return minPreferredWidth;
        }
        return Math.max(width.getAsInt(), minPreferredWidth);
    }

    private static int getPreferredCellWidth(@NotNull JTable table, int viewRowIndex, int viewColumnIndex) {
        Component component2;
        if (viewRowIndex == -1) {
            TableCellRenderer renderer = table.getTableHeader().getDefaultRenderer();
            Object value = table.getColumnModel().getColumn(viewColumnIndex).getHeaderValue();
            component2 = renderer.getTableCellRendererComponent(table, value, false, false, -1, viewColumnIndex);
        } else {
            component2 = table.prepareRenderer(table.getCellRenderer(viewRowIndex, viewColumnIndex), viewRowIndex, viewColumnIndex);
        }
        return component2.getPreferredSize().width + JBUI.scale((int)8);
    }
}

