/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.ui;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0002 !B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0006\u0010\u001a\u001a\u00020\u000bJ\u0012\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0019H\u0002J\b\u0010\u001d\u001a\u00020\u000bH\u0002J\b\u0010\u001e\u001a\u00020\u000bH\u0002J\b\u0010\u001f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/adtui/ui/NotificationHolderPanel;", "Lcom/intellij/ui/components/JBLayeredPane;", "contentPanel", "Ljava/awt/Component;", "<init>", "(Ljava/awt/Component;)V", "fadeOutNotificationPopup", "Lcom/android/tools/adtui/ui/NotificationHolderPanel$NotificationPopup;", "animator", "Lcom/intellij/util/ui/Animator;", "doLayout", "", "getPreferredSize", "Ljava/awt/Dimension;", "paintChildren", "g", "Ljava/awt/Graphics;", "addNotification", "notificationPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "removeNotification", "showFadeOutNotification", "text", "", "status", "Lcom/intellij/ui/EditorNotificationPanel$Status;", "hideFadeOutNotification", "createFadeOutNotificationPopup", "severity", "hideFadeOutNotificationPopup", "startFadeOutAnimation", "stopFadeOutAnimation", "NotificationPopup", "FadeOutAnimator", "intellij.android.adt.ui"})
@SourceDebugExtension(value={"SMAP\nNotificationHolderPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationHolderPanel.kt\ncom/android/tools/adtui/ui/NotificationHolderPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n1#2:220\n*E\n"})
public final class NotificationHolderPanel
extends JBLayeredPane {
    @NotNull
    private final Component contentPanel;
    @Nullable
    private NotificationPopup fadeOutNotificationPopup;
    @Nullable
    private Animator animator;

    public NotificationHolderPanel(@NotNull Component contentPanel) {
        Intrinsics.checkNotNullParameter((Object)contentPanel, (String)"contentPanel");
        this.contentPanel = contentPanel;
        this.setBorder((Border)JBUI.Borders.empty());
        Integer n = JBLayeredPane.DEFAULT_LAYER;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"DEFAULT_LAYER");
        this.setLayer(this.contentPanel, ((Number)n).intValue());
        this.add(this.contentPanel);
    }

    public void doLayout() {
        int y = 0;
        Iterator iterator = ArrayIteratorKt.iterator((Object[])this.getComponents());
        while (iterator.hasNext()) {
            Component child = (Component)iterator.next();
            if (child == this.contentPanel) {
                child.setBounds(0, 0, this.getWidth(), this.getHeight());
                continue;
            }
            int childHeight = child.getPreferredSize().height;
            child.setBounds(0, y, this.getWidth(), childHeight);
            y += childHeight;
        }
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension = this.contentPanel.getPreferredSize();
        if (dimension == null) {
            Dimension dimension2 = super.getPreferredSize();
            dimension = dimension2;
            Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getPreferredSize(...)");
        }
        return dimension;
    }

    protected void paintChildren(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.getComponentCount() > 1) {
            BufferedImage bufferedImage = ImageUtil.createImage((Graphics)g, (int)this.getWidth(), (int)this.getHeight(), (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
            BufferedImage image = bufferedImage;
            Graphics2D graphics2D = image.createGraphics();
            Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"createGraphics(...)");
            Graphics2D g2d = graphics2D;
            super.paintChildren((Graphics)g2d);
            g2d.dispose();
            Rectangle rect = new Rectangle(image.getWidth(null), image.getHeight(null));
            UIUtil.drawImage((Graphics)g, (Image)image, (Rectangle)rect, (Rectangle)rect, null);
        } else {
            super.paintChildren(g);
        }
    }

    public final void addNotification(@NotNull EditorNotificationPanel notificationPanel) {
        Intrinsics.checkNotNullParameter((Object)notificationPanel, (String)"notificationPanel");
        Component component2 = (Component)notificationPanel;
        Integer n = JBLayeredPane.POPUP_LAYER;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"POPUP_LAYER");
        this.setLayer(component2, ((Number)n).intValue());
        this.add((Component)notificationPanel);
        this.revalidate();
    }

    public final void removeNotification(@NotNull EditorNotificationPanel notificationPanel) {
        Intrinsics.checkNotNullParameter((Object)notificationPanel, (String)"notificationPanel");
        this.remove((Component)notificationPanel);
        this.revalidate();
        this.repaint();
    }

    public final void showFadeOutNotification(@NotNull String text, @Nullable EditorNotificationPanel.Status status) {
        NotificationPopup notificationPopup;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.hideFadeOutNotification();
        this.fadeOutNotificationPopup = notificationPopup = this.createFadeOutNotificationPopup(status);
        notificationPopup.getNotificationPanel().setText(text);
        this.startFadeOutAnimation();
        this.revalidate();
    }

    public static /* synthetic */ void showFadeOutNotification$default(NotificationHolderPanel notificationHolderPanel, String string, EditorNotificationPanel.Status status, int n, Object object) {
        if ((n & 2) != 0) {
            status = null;
        }
        notificationHolderPanel.showFadeOutNotification(string, status);
    }

    public final void hideFadeOutNotification() {
        this.stopFadeOutAnimation();
        this.hideFadeOutNotificationPopup();
    }

    private final NotificationPopup createFadeOutNotificationPopup(EditorNotificationPanel.Status severity) {
        EditorNotificationPanel editorNotificationPanel;
        EditorNotificationPanel.Status status = severity;
        if (status != null) {
            EditorNotificationPanel.Status it = status;
            boolean bl = false;
            editorNotificationPanel = new EditorNotificationPanel(it);
        } else {
            editorNotificationPanel = new EditorNotificationPanel(HintUtil.INFORMATION_COLOR_KEY);
        }
        EditorNotificationPanel notificationPanel = editorNotificationPanel;
        NotificationPopup popup = new NotificationPopup(notificationPanel);
        Component component2 = (Component)((Object)popup);
        Integer n = JBLayeredPane.POPUP_LAYER;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"POPUP_LAYER");
        this.setLayer(component2, ((Number)n).intValue());
        this.addImpl((Component)((Object)popup), null, 0);
        return popup;
    }

    private final void hideFadeOutNotificationPopup() {
        block0: {
            NotificationPopup notificationPopup = this.fadeOutNotificationPopup;
            if (notificationPopup == null) break block0;
            NotificationPopup it = notificationPopup;
            boolean bl = false;
            this.remove((Component)((Object)it));
            this.fadeOutNotificationPopup = null;
            this.revalidate();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void startFadeOutAnimation() {
        void $this$startFadeOutAnimation_u24lambda_u242;
        FadeOutAnimator fadeOutAnimator;
        Animator animator = this.animator;
        if (animator != null) {
            animator.dispose();
        }
        NotificationPopup notificationPopup = this.fadeOutNotificationPopup;
        if (notificationPopup != null) {
            notificationPopup.setAlpha(1.0f);
        }
        FadeOutAnimator fadeOutAnimator2 = fadeOutAnimator = new FadeOutAnimator();
        NotificationHolderPanel notificationHolderPanel = this;
        boolean bl = false;
        $this$startFadeOutAnimation_u24lambda_u242.resume();
        notificationHolderPanel.animator = fadeOutAnimator;
    }

    private final void stopFadeOutAnimation() {
        Animator animator = this.animator;
        if (animator != null) {
            animator.dispose();
        }
        this.animator = null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0014J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/adtui/ui/NotificationHolderPanel$FadeOutAnimator;", "Lcom/intellij/util/ui/Animator;", "<init>", "(Lcom/android/tools/adtui/ui/NotificationHolderPanel;)V", "paintNow", "", "frame", "", "totalFrames", "cycle", "paintCycleEnd", "dispose", "skipAnimation", "", "intellij.android.adt.ui"})
    private final class FadeOutAnimator
    extends Animator {
        public FadeOutAnimator() {
            super("FadeOutAnimator", 150, 5000, false, false, null, 48, null);
        }

        public void paintNow(int frame, int totalFrames, int cycle) {
            NotificationPopup notificationPopup = NotificationHolderPanel.this.fadeOutNotificationPopup;
            if (notificationPopup == null) {
                return;
            }
            NotificationPopup popup = notificationPopup;
            float alpha = (float)Math.cos(1.5707963267948966 * (double)frame / (double)totalFrames);
            if ((double)Math.abs(alpha - popup.getAlpha()) >= 0.005) {
                popup.setAlpha(alpha);
                popup.paintImmediately(0, 0, popup.getWidth(), popup.getHeight());
            }
        }

        protected void paintCycleEnd() {
            if (!this.skipAnimation()) {
                NotificationHolderPanel.this.hideFadeOutNotificationPopup();
            }
            this.dispose();
        }

        public void dispose() {
            super.dispose();
            NotificationHolderPanel.this.animator = null;
        }

        private final boolean skipAnimation() {
            if (GraphicsEnvironment.isHeadless()) {
                return true;
            }
            Application app = ApplicationManager.getApplication();
            return app != null && app.isUnitTestMode();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/adtui/ui/NotificationHolderPanel$NotificationPopup;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "notificationPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "<init>", "(Lcom/intellij/ui/EditorNotificationPanel;)V", "getNotificationPanel", "()Lcom/intellij/ui/EditorNotificationPanel;", "alpha", "", "getAlpha", "()F", "setAlpha", "(F)V", "paint", "", "g", "Ljava/awt/Graphics;", "intellij.android.adt.ui"})
    private static final class NotificationPopup
    extends BorderLayoutPanel {
        @NotNull
        private final EditorNotificationPanel notificationPanel;
        private float alpha;

        public NotificationPopup(@NotNull EditorNotificationPanel notificationPanel) {
            Intrinsics.checkNotNullParameter((Object)notificationPanel, (String)"notificationPanel");
            this.notificationPanel = notificationPanel;
            this.alpha = 1.0f;
            this.setBorder(IdeBorderFactory.createBorder((Color)JBColor.border(), (int)8));
            this.setOpaque(false);
            this.addToCenter((Component)this.notificationPanel);
        }

        @NotNull
        public final EditorNotificationPanel getNotificationPanel() {
            return this.notificationPanel;
        }

        public final float getAlpha() {
            return this.alpha;
        }

        public final void setAlpha(float f) {
            this.alpha = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (this.alpha == 1.0f) {
                super.paint(g);
            } else {
                Graphics graphics = g.create();
                Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D g2d = (Graphics2D)graphics;
                try {
                    g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                    super.paint((Graphics)g2d);
                }
                finally {
                    g2d.dispose();
                }
            }
        }
    }
}

