/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.util;

import java.text.DecimalFormat;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"getHumanizedSize", "", "sizeInBytes", "", "KILO", "MEGA", "GIGA", "intellij.android.adt.ui"})
@JvmName(name="HumanReadableUtil")
public final class HumanReadableUtil {
    private static final long KILO = 1024L;
    private static final long MEGA = 0x100000L;
    private static final long GIGA = 0x40000000L;

    @NotNull
    public static final String getHumanizedSize(long sizeInBytes) {
        DecimalFormat formatter = new DecimalFormat("#.#");
        long range = Math.abs(sizeInBytes);
        return range > 0x40000000L ? formatter.format((double)sizeInBytes / 1.073741824E9) + " GB" : (range > 0x100000L ? formatter.format((double)sizeInBytes / 1048576.0) + " MB" : (range > 1024L ? formatter.format((double)sizeInBytes / 1024.0) + " KB" : sizeInBytes + " B"));
    }
}

