/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.SideModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LayeredPanel<T>
extends JBLayeredPane
implements SideModel.Listener<T>,
Disposable {
    private final String myBenchName;
    private final PropertiesComponent myPropertiesComponent;
    private final ThreeComponentsSplitter mySplitter;
    private final JPanel myContainer;
    private String myToolName;
    private Side mySide;

    LayeredPanel(@NotNull String benchName, @NotNull JComponent defaultLayer, @NotNull SideModel<T> model2) {
        this(benchName, defaultLayer, model2, PropertiesComponent.getInstance());
    }

    LayeredPanel(@NotNull String benchName, @NotNull JComponent defaultLayer, @NotNull SideModel<T> model2, @NotNull PropertiesComponent propertiesComponent) {
        this.myBenchName = benchName;
        this.myPropertiesComponent = propertiesComponent;
        this.myContainer = new JPanel();
        this.myContainer.setOpaque(false);
        this.myContainer.addComponentListener(this.createWidthUpdater());
        this.mySplitter = new ThreeComponentsSplitter();
        this.mySplitter.setOpaque(false);
        this.mySplitter.setInnerComponent((JComponent)this.myContainer);
        this.mySplitter.setDividerWidth(JBUI.scale((int)0));
        this.mySplitter.setFocusCycleRoot(false);
        this.mySplitter.setFocusTraversalPolicyProvider(true);
        this.mySplitter.setFocusTraversalPolicy((FocusTraversalPolicy)new LayoutFocusTraversalPolicy());
        this.mySide = Side.LEFT;
        this.add(defaultLayer, DEFAULT_LAYER);
        this.add((Component)this.mySplitter, PALETTE_LAYER);
        model2.addListener(this);
        this.setFullOverlayLayout(true);
    }

    @VisibleForTesting
    ThreeComponentsSplitter getSplitter() {
        return this.mySplitter;
    }

    @Override
    public void modelChanged(@NotNull SideModel<T> model2, @NotNull SideModel.EventType unused) {
        model2.getHiddenSliders().forEach(this::addHiddenTool);
        this.addVisibleTool(model2.getVisibleAutoHideTool());
        this.revalidate();
        this.repaint();
    }

    private void addVisibleTool(@Nullable AttachedToolWindow<T> tool) {
        if (tool == null) {
            this.mySplitter.setVisible(false);
            this.mySplitter.setFirstComponent(null);
            this.mySplitter.setLastComponent(null);
            this.myToolName = null;
        } else {
            JComponent component2 = tool.getComponent();
            component2.setVisible(true);
            this.mySplitter.setVisible(true);
            this.myToolName = tool.getToolName();
            if (tool.isLeft()) {
                this.mySide = Side.LEFT;
                this.mySplitter.setFirstComponent(component2);
                this.mySplitter.setFirstSize(this.getToolWidth(tool));
                this.mySplitter.setLastComponent(null);
                this.myContainer.setBorder(IdeBorderFactory.createBorder((int)1));
            } else {
                this.mySide = Side.RIGHT;
                this.mySplitter.setFirstComponent(null);
                this.mySplitter.setLastComponent(component2);
                this.mySplitter.setLastSize(this.getToolWidth(tool));
                this.myContainer.setBorder(IdeBorderFactory.createBorder((int)4));
            }
        }
    }

    private void addHiddenTool(@NotNull AttachedToolWindow<T> tool) {
        JComponent component2 = tool.getComponent();
        component2.setVisible(false);
        this.myContainer.add((Component)component2, PALETTE_LAYER);
    }

    public void dispose() {
    }

    @NotNull
    private ComponentListener createWidthUpdater() {
        return new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                int width;
                int n = width = LayeredPanel.this.mySide.isLeft() ? LayeredPanel.this.mySplitter.getFirstSize() : LayeredPanel.this.mySplitter.getLastSize();
                if (LayeredPanel.this.myToolName != null && width > 0) {
                    LayeredPanel.this.setToolWidth(width);
                }
            }
        };
    }

    @NotNull
    private String getUnscaledWidthPropertyName() {
        return "ATTACHED_TOOL_WINDOW." + this.myBenchName + "." + this.myToolName + ".UNSCALED.WIDTH";
    }

    @NotNull
    private String getScaledWidthPropertyName() {
        return "ATTACHED_TOOL_WINDOW." + this.myBenchName + "." + this.myToolName + ".WIDTH";
    }

    private int getToolWidth(@NotNull AttachedToolWindow<T> tool) {
        int width = this.myPropertiesComponent.getInt(this.getUnscaledWidthPropertyName(), -1);
        if (width != -1) {
            return JBUI.scale((int)width);
        }
        int scaledWidth = this.myPropertiesComponent.getInt(this.getScaledWidthPropertyName(), -1);
        if (scaledWidth == -1) {
            return tool.getDefinition().getInitialMinimumWidth();
        }
        this.myPropertiesComponent.unsetValue(this.getScaledWidthPropertyName());
        this.setToolWidth(scaledWidth);
        return scaledWidth;
    }

    private void setToolWidth(int width) {
        this.myPropertiesComponent.setValue(this.getUnscaledWidthPropertyName(), AdtUiUtils.unscale(width), -1);
    }
}

