/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.WorkBench;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.NewUI;
import com.intellij.util.ui.FocusUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.Collection;
import java.util.Optional;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class WorkBenchManager
implements Disposable {
    private final Multimap<String, WorkBench<?>> myWorkBenches = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private WorkBench<?> myActiveWorkBench = null;
    private AttachedToolWindow.AttachedToolWindowPanel myActiveToolWindow = null;

    public static WorkBenchManager getInstance() {
        return (WorkBenchManager)ApplicationManager.getApplication().getService(WorkBenchManager.class);
    }

    public WorkBenchManager() {
        if (NewUI.isEnabled()) {
            FocusUtil.addFocusOwnerListener((Disposable)this, evt -> this.findActiveToolWindow());
        }
    }

    public void dispose() {
        this.myWorkBenches.clear();
        this.myActiveWorkBench = null;
        this.myActiveToolWindow = null;
    }

    public void register(@NotNull WorkBench<?> workBench) {
        this.myWorkBenches.put((Object)workBench.getName(), workBench);
    }

    public void unregister(@NotNull WorkBench<?> workBench) {
        this.myWorkBenches.remove((Object)workBench.getName(), workBench);
        if (this.myActiveWorkBench == workBench) {
            this.resetActiveToolWindow();
        }
    }

    public void storeDefaultLayout() {
        for (String name : this.myWorkBenches.keySet()) {
            Optional workbench = this.myWorkBenches.get((Object)name).stream().findFirst();
            if (!workbench.isPresent()) continue;
            ((WorkBench)((Object)workbench.get())).storeDefaultLayout();
            this.updateOtherWorkBenches((WorkBench)((Object)workbench.get()));
        }
    }

    public void restoreDefaultLayout() {
        for (String name : this.myWorkBenches.keySet()) {
            Optional workbench = this.myWorkBenches.get((Object)name).stream().findFirst();
            if (!workbench.isPresent()) continue;
            ((WorkBench)((Object)workbench.get())).restoreDefaultLayout();
            this.updateOtherWorkBenches((WorkBench)((Object)workbench.get()));
        }
    }

    public void updateOtherWorkBenches(@NotNull WorkBench<?> workBench) {
        Collection workBenches = this.myWorkBenches.get((Object)workBench.getName());
        workBenches.stream().filter(bench -> bench != workBench).forEach(WorkBench::updateModel);
    }

    @TestOnly
    public AttachedToolWindow<?> getActiveToolWindow() {
        return this.myActiveToolWindow != null ? this.myActiveToolWindow.getToolWindow() : null;
    }

    void findActiveToolWindow() {
        if (this.myWorkBenches.isEmpty()) {
            this.resetActiveToolWindow();
            return;
        }
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component2 == null) {
            this.resetActiveToolWindow();
            return;
        }
        AttachedToolWindow.AttachedToolWindowPanel panel = (AttachedToolWindow.AttachedToolWindowPanel)SwingUtilities.getAncestorOfClass(AttachedToolWindow.AttachedToolWindowPanel.class, component2);
        if (panel == null) {
            this.resetActiveToolWindow();
            return;
        }
        WorkBench workBench = (WorkBench)((Object)SwingUtilities.getAncestorOfClass(WorkBench.class, component2));
        if (workBench == null || !this.myWorkBenches.containsValue((Object)workBench)) {
            this.resetActiveToolWindow();
            return;
        }
        if (this.myActiveToolWindow != panel) {
            this.resetActiveToolWindow();
        }
        this.myActiveWorkBench = workBench;
        this.myActiveToolWindow = panel;
        panel.setActive(true);
    }

    private void resetActiveToolWindow() {
        if (this.myActiveToolWindow != null) {
            this.myActiveToolWindow.setActive(false);
        }
        this.myActiveWorkBench = null;
        this.myActiveToolWindow = null;
    }
}

