/*
 * Decompiled with CFR 0.152.
 */
package com.android.testing.utils;

import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u0018\u0010\u0004\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\u000b"}, d2={"setupDeviceIdRegex", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "androidTestDeviceIdRegex", "isGradleManagedDevice", "", "deviceId", "", "createSetupDeviceId", "avdName", "android.sdktools.common"})
public final class ManagedDeviceUtilsKt {
    private static final Pattern setupDeviceIdRegex = Pattern.compile("dev[0-9]+[_\\-0-9a-zA-Z]*_snapshot$");
    private static final Pattern androidTestDeviceIdRegex = Pattern.compile("[^:]+:[^:]+AndroidTest(_[0-9]+)?$");

    public static final boolean isGradleManagedDevice(@NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        return setupDeviceIdRegex.matcher(deviceId).find() || androidTestDeviceIdRegex.matcher(deviceId).find();
    }

    @NotNull
    public static final String createSetupDeviceId(@NotNull String avdName) {
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        return avdName + "_snapshot";
    }
}

