/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0012\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001dJ#\u0010\u001e\u001a\u00020\n\"\u000e\b\u0000\u0010\u001f*\b\u0012\u0004\u0012\u0002H\u001f0 2\u0006\u0010\u000b\u001a\u0002H\u001f\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\fH\u0017\u00a8\u0006$"}, d2={"Lcom/android/utils/Base128OutputStream;", "Ljava/io/BufferedOutputStream;", "stream", "Ljava/io/OutputStream;", "<init>", "(Ljava/io/OutputStream;)V", "file", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "writeInt", "", "value", "", "writeLong", "", "writeFloat", "", "writeFixed32", "writeString", "str", "", "writeChar", "", "writeByte", "", "writeBytes", "bytes", "", "writeBoolean", "", "writeEnum", "T", "", "(Ljava/lang/Enum;)V", "write", "b", "android.sdktools.common"})
public final class Base128OutputStream
extends BufferedOutputStream {
    public Base128OutputStream(@NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        super(stream);
    }

    public Base128OutputStream(@NotNull Path file) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        this(outputStream);
    }

    public final void writeInt(int value) throws IOException {
        int value2 = value;
        do {
            int b = value2 & 0x7F;
            if ((value2 >>>= 7) != 0) {
                b |= 0x80;
            }
            super.write(b);
        } while (value2 != 0);
    }

    public final void writeLong(long value) throws IOException {
        long value2 = value;
        do {
            int b = (int)value2 & 0x7F;
            if ((value2 >>>= 7) != 0L) {
                b |= 0x80;
            }
            super.write(b);
        } while (value2 != 0L);
    }

    public final void writeFloat(float value) throws IOException {
        this.writeFixed32(Float.floatToIntBits(value));
    }

    public final void writeFixed32(int value) throws IOException {
        for (int shift = 0; shift < 32; shift += 8) {
            super.write(value >>> shift & 0xFF);
        }
    }

    public final void writeString(@Nullable String str) throws IOException {
        if (str == null) {
            this.writeInt(0);
        } else {
            int len = str.length();
            this.writeInt(len + 1);
            for (int i = 0; i < len; ++i) {
                this.writeChar(str.charAt(i));
            }
        }
    }

    public final void writeChar(char value) throws IOException {
        this.writeInt(value & 0xFFFF);
    }

    public final void writeByte(byte value) throws IOException {
        super.write(value);
    }

    public final void writeBytes(@NotNull byte[] bytes) throws IOException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.writeInt(bytes.length);
        for (byte b : bytes) {
            this.writeByte(b);
        }
    }

    public final void writeBoolean(boolean value) throws IOException {
        this.writeInt(value ? 1 : 0);
    }

    public final <T extends Enum<T>> void writeEnum(@NotNull T value) throws IOException {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.writeInt(value.ordinal());
    }

    @Override
    @Deprecated(message="Use writeByte or writeInt instead.")
    public void write(int b) {
        throw new UnsupportedOperationException("This method is disabled to prevent unintended accidental use. Please use writeByte or writeInt instead.");
    }
}

