/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.SdkConstants;
import com.android.utils.TokenizedCommandLine;
import com.android.utils.TokenizedCommandLineKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002BS\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00128\b\u0002\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\u0004\b\u0010\u0010\u0011J/\u0010#\u001a\u00028\u00002\u0006\u0010$\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\u001b\u00a2\u0006\u0002\u0010&J\u0006\u0010'\u001a\u00020\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015RA\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR&\u0010 \u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u00000!0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/utils/TokenizedCommandLineMap;", "T", "", "raw", "", "platform", "", "normalize", "Lkotlin/Function2;", "Lcom/android/utils/TokenizedCommandLine;", "Lkotlin/ParameterName;", "name", "tokens", "", "sourceFile", "", "<init>", "(ZILkotlin/jvm/functions/Function2;)V", "getRaw", "()Z", "getPlatform", "()I", "getNormalize", "()Lkotlin/jvm/functions/Function2;", "indexes", "", "hashFunction", "Lkotlin/Function1;", "getHashFunction", "()Lkotlin/jvm/functions/Function1;", "setHashFunction", "(Lkotlin/jvm/functions/Function1;)V", "map", "", "hashCodeMap", "computeIfAbsent", "commandLine", "compute", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "size", "android.sdktools.common"})
@SourceDebugExtension(value={"SMAP\nTokenizedCommandLineMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenizedCommandLineMap.kt\ncom/android/utils/TokenizedCommandLineMap\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,87:1\n126#2:88\n153#2,3:89\n*S KotlinDebug\n*F\n+ 1 TokenizedCommandLineMap.kt\ncom/android/utils/TokenizedCommandLineMap\n*L\n86#1:88\n86#1:89,3\n*E\n"})
public final class TokenizedCommandLineMap<T> {
    private final boolean raw;
    private final int platform;
    @NotNull
    private final Function2<TokenizedCommandLine, String, Unit> normalize;
    @NotNull
    private int[] indexes;
    @NotNull
    private Function1<? super TokenizedCommandLine, Integer> hashFunction;
    @NotNull
    private final Map<Integer, Map<String, T>> map;
    @NotNull
    private final Map<String, Integer> hashCodeMap;

    public TokenizedCommandLineMap(boolean raw, int platform, @NotNull Function2<? super TokenizedCommandLine, ? super String, Unit> normalize) {
        Intrinsics.checkNotNullParameter(normalize, (String)"normalize");
        this.raw = raw;
        this.platform = platform;
        this.normalize = normalize;
        this.indexes = new int[0];
        this.hashFunction = TokenizedCommandLineMap::hashFunction$lambda$1;
        this.map = new LinkedHashMap();
        this.hashCodeMap = new LinkedHashMap();
    }

    public /* synthetic */ TokenizedCommandLineMap(boolean bl, int n, Function2 function2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = SdkConstants.currentPlatform();
        }
        if ((n2 & 4) != 0) {
            function2 = TokenizedCommandLineMap::_init_$lambda$0;
        }
        this(bl, n, (Function2<? super TokenizedCommandLine, ? super String, Unit>)function2);
    }

    public final boolean getRaw() {
        return this.raw;
    }

    public final int getPlatform() {
        return this.platform;
    }

    @NotNull
    public final Function2<TokenizedCommandLine, String, Unit> getNormalize() {
        return this.normalize;
    }

    @NotNull
    public final Function1<TokenizedCommandLine, Integer> getHashFunction() {
        return this.hashFunction;
    }

    public final void setHashFunction(@NotNull Function1<? super TokenizedCommandLine, Integer> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.hashFunction = function1;
    }

    public final T computeIfAbsent(@NotNull String commandLine, @NotNull String sourceFile, @NotNull Function1<? super TokenizedCommandLine, ? extends T> compute) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter(compute, (String)"compute");
        if (this.indexes.length <= TokenizedCommandLineKt.minimumSizeOfTokenizeCommandLineBuffer(commandLine)) {
            this.indexes = TokenizedCommandLineKt.allocateTokenizeCommandLineBuffer(commandLine);
        }
        TokenizedCommandLine tokens = new TokenizedCommandLine(commandLine, this.raw, this.platform, this.indexes);
        this.normalize.invoke((Object)tokens, (Object)sourceFile);
        int hashCode = ((Number)this.hashFunction.invoke((Object)tokens)).intValue();
        Map map = this.map.computeIfAbsent(hashCode, arg_0 -> TokenizedCommandLineMap.computeIfAbsent$lambda$3(TokenizedCommandLineMap::computeIfAbsent$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"computeIfAbsent(...)");
        Map submap = map;
        for (Map.Entry entry : submap.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!tokens.normalizedCommandLineEquals(key)) continue;
            return (T)value;
        }
        String normalizedCommandLine = tokens.toString();
        boolean bl2 = bl = !submap.containsKey(normalizedCommandLine);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Object value = compute.invoke((Object)tokens);
        submap.put(normalizedCommandLine, value);
        Integer n = hashCode;
        this.hashCodeMap.put(normalizedCommandLine, n);
        return (T)value;
    }

    /*
     * WARNING - void declaration
     */
    public final int size() {
        void $this$mapTo$iv$iv;
        Map<Integer, Map<String, T>> $this$map$iv = this.map;
        boolean $i$f$map = false;
        Map<Integer, Map<String, T>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Map)it.getValue()).size());
        }
        return CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
    }

    private static final Unit _init_$lambda$0(TokenizedCommandLine tokenizedCommandLine, String string) {
        Intrinsics.checkNotNullParameter((Object)tokenizedCommandLine, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final int hashFunction$lambda$1(TokenizedCommandLine tokens) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        return tokens.computeNormalizedCommandLineHashCode();
    }

    private static final Map computeIfAbsent$lambda$2(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashMap();
    }

    private static final Map computeIfAbsent$lambda$3(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }
}

