/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.concurrency;

import com.android.tools.idea.concurrency.ComputationResult;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0002J\u0013\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0012J\u0019\u0010\u0018\u001a\u0012\u0012\u000e\u0012\f\b\u0002 \u000e*\u0004\u0018\u00018\u00008\u00000\u0019\u00f8\u0001\u0000J\u000b\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\f\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00018\u00008\u0000 \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/concurrency/Computation;", "V", "", "modificationCountWhenScheduled", "", "<init>", "(J)V", "getModificationCountWhenScheduled", "()J", "result", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/android/tools/idea/concurrency/ComputationResult;", "future", "Lcom/google/common/util/concurrent/SettableFuture;", "kotlin.jvm.PlatformType", "Lcom/google/common/util/concurrent/SettableFuture;", "getResultAndCheckComplete", "complete", "", "(Ljava/lang/Object;)V", "completeExceptionally", "error", "", "broadcastResult", "getResult", "Lcom/google/common/util/concurrent/ListenableFuture;", "getResultNow", "()Ljava/lang/Object;", "getCompletionTimestamp", "intellij.android.common"})
@SourceDebugExtension(value={"SMAP\nThrottlingAsyncSupplier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThrottlingAsyncSupplier.kt\ncom/android/tools/idea/concurrency/Computation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
final class Computation<V> {
    private final long modificationCountWhenScheduled;
    @NotNull
    private final AtomicReference<ComputationResult<V>> result;
    private final SettableFuture<V> future;

    public Computation(long modificationCountWhenScheduled) {
        this.modificationCountWhenScheduled = modificationCountWhenScheduled;
        this.result = new AtomicReference<Object>(null);
        this.future = SettableFuture.create();
    }

    public final long getModificationCountWhenScheduled() {
        return this.modificationCountWhenScheduled;
    }

    private final ComputationResult<V> getResultAndCheckComplete() {
        ComputationResult<V> computationResult = this.result.get();
        if (computationResult == null) {
            throw new IllegalStateException("This Computation hasn't been executed yet.");
        }
        return computationResult;
    }

    private final void complete(ComputationResult<V> result) {
        if (!this.result.compareAndSet(null, result)) {
            boolean bl = false;
            String string = "This Computation has already been executed.";
            throw new IllegalStateException(string.toString());
        }
    }

    public final void complete(V result) {
        this.complete((V)new ComputationResult.Value<V>(result));
    }

    public final void completeExceptionally(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.complete((V)new ComputationResult.Error(error));
    }

    public final void broadcastResult() {
        ComputationResult<V> result = this.getResultAndCheckComplete();
        if (result instanceof ComputationResult.Value) {
            v0 = this.future.set(((ComputationResult.Value)result).getValue());
        } else {
            Intrinsics.checkNotNull(result, (String)"null cannot be cast to non-null type com.android.tools.idea.concurrency.ComputationResult.Error<V of com.android.tools.idea.concurrency.Computation>");
            v0 = this.future.setException(((ComputationResult.Error)result).getError());
        }
    }

    @NotNull
    public final ListenableFuture<V> getResult() {
        ListenableFuture listenableFuture = Futures.nonCancellationPropagating((ListenableFuture)((ListenableFuture)this.future));
        Intrinsics.checkNotNull((Object)listenableFuture);
        return listenableFuture;
    }

    public final V getResultNow() {
        ComputationResult<V> result = this.getResultAndCheckComplete();
        if (result instanceof ComputationResult.Value) {
            return ((ComputationResult.Value)result).getValue();
        }
        Intrinsics.checkNotNull(result, (String)"null cannot be cast to non-null type com.android.tools.idea.concurrency.ComputationResult.Error<V of com.android.tools.idea.concurrency.Computation>");
        throw new IllegalStateException("This Computation completed exceptionally.", ((ComputationResult.Error)result).getError());
    }

    public final long getCompletionTimestamp() {
        return this.getResultAndCheckComplete().getTimestampMs();
    }
}

