/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.downloads;

import com.android.tools.idea.downloads.UrlFileCacheKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.HttpRequests;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.YieldKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJI\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0016\b\u0002\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001dJ:\u0010\u001e\u001a\u00020\f2\b\u0010\u001f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aH\u0002J,\u0010\u0019\u001a\u00020\f*\u00020\f2\b\u0010 \u001a\u0004\u0018\u00010\f2\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aH\u0002J\b\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/downloads/UrlFileCache;", "Lcom/intellij/openapi/Disposable;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "ioDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/CoroutineDispatcher;)V", "(Lkotlinx/coroutines/CoroutineScope;)V", "files", "", "", "Ljava/nio/file/Path;", "lastModified", "eTags", "tmpDir", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "get", "Lkotlinx/coroutines/Deferred;", "url", "maxFileAge", "Lkotlin/time/Duration;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "transform", "Lkotlin/Function1;", "Ljava/io/InputStream;", "get-dWUq8MI", "(Ljava/lang/String;JLcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function1;)Lkotlinx/coroutines/Deferred;", "fetchAndFilterUrlLocked", "existing", "cachedPath", "dispose", "", "Companion", "intellij.android.common"})
@SourceDebugExtension(value={"SMAP\nUrlFileCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlFileCache.kt\ncom/android/tools/idea/downloads/UrlFileCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n1#2:173\n*E\n"})
public final class UrlFileCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final CoroutineDispatcher ioDispatcher;
    @NotNull
    private final Map<String, Path> files;
    @NotNull
    private final Map<String, String> lastModified;
    @NotNull
    private final Map<String, String> eTags;
    @NotNull
    private final Path tmpDir;
    @NotNull
    private final Mutex mutex;

    @TestOnly
    public UrlFileCache(@NotNull CoroutineScope coroutineScope, @NotNull CoroutineDispatcher ioDispatcher) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)ioDispatcher, (String)"ioDispatcher");
        this.coroutineScope = coroutineScope;
        this.ioDispatcher = ioDispatcher;
        this.files = new LinkedHashMap();
        this.lastModified = new LinkedHashMap();
        this.eTags = new LinkedHashMap();
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempDirectory(null, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        this.tmpDir = path;
        this.mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    public UrlFileCache(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this(coroutineScope, Dispatchers.getIO());
    }

    @NotNull
    public final Deferred<Path> get-dWUq8MI(@NotNull String url, long maxFileAge, @Nullable ProgressIndicator indicator, @Nullable Function1<? super InputStream, ? extends InputStream> transform) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            ProgressIndicator progressIndicator = indicator;
            if (progressIndicator != null) {
                progressIndicator.setIndeterminate(true);
            }
            ProgressIndicator progressIndicator2 = indicator;
            if (progressIndicator2 == null) break block1;
            progressIndicator2.setText("Checking cached downloads");
        }
        return BuildersKt.async((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)this.ioDispatcher), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(this, url, indicator, transform, maxFileAge, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            long J$0;
            int label;
            final /* synthetic */ UrlFileCache this$0;
            final /* synthetic */ String $url;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ Function1<InputStream, InputStream> $transform;
            final /* synthetic */ long $maxFileAge;
            {
                this.this$0 = $receiver;
                this.$url = $url;
                this.$indicator = $indicator;
                this.$transform = $transform;
                this.$maxFileAge = $maxFileAge;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var18_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = UrlFileCache.access$getMutex$p(this.this$0);
                        var4_4 = this.this$0;
                        var5_5 = this.$url;
                        var6_6 = this.$indicator;
                        var7_7 = this.$transform;
                        var8_8 = this.$maxFileAge;
                        owner$iv = null;
                        $i$f$withLock = false;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = var4_4;
                        this.L$2 = var5_5;
                        this.L$3 = var6_6;
                        this.L$4 = var7_7;
                        this.J$0 = var8_8;
                        this.label = 1;
                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                        if (v0 == var18_2) {
                            return var18_2;
                        }
                        ** GOTO lbl37
                    }
                    case 1: {
                        $i$f$withLock = false;
                        var8_8 = this.J$0;
                        var7_7 = (Function1<InputStream, InputStream>)this.L$4;
                        var6_6 = (ProgressIndicator)this.L$3;
                        var5_5 = (String)this.L$2;
                        var4_4 = (UrlFileCache)this.L$1;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl37:
                        // 3 sources

                        $i$a$-withLock$default-UrlFileCache$get$1$1 = false;
                        v1 = (Path)UrlFileCache.access$getFiles$p(var4_4).get(var5_5);
                        if (v1 == null) ** GOTO lbl48
                        it = var12_12 = v1;
                        $i$a$-also-UrlFileCache$get$1$1$existing$1 = false;
                        if (!UrlFileCacheKt.access$isFresh-HG0u8IE(it, var8_8)) ** GOTO lbl46
                        v2 = it;
                        ** GOTO lbl76
lbl46:
                        // 1 sources

                        v3 = var12_12;
                        ** GOTO lbl49
lbl48:
                        // 1 sources

                        v3 = null;
lbl49:
                        // 2 sources

                        existing = v3;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = var4_4;
                        this.L$2 = var5_5;
                        this.L$3 = var6_6;
                        this.L$4 = var7_7;
                        this.L$5 = existing;
                        this.label = 2;
                        v4 = YieldKt.yield((Continuation)this);
                        ** if (v4 != var18_2) goto lbl60
lbl59:
                        // 1 sources

                        return var18_2;
lbl60:
                        // 1 sources

                        ** GOTO lbl75
                    }
                    case 2: {
                        $i$f$withLock = false;
                        $i$a$-withLock$default-UrlFileCache$get$1$1 = false;
                        existing = (Path)this.L$5;
                        var7_7 = (Function1)this.L$4;
                        var6_6 = (ProgressIndicator)this.L$3;
                        var5_5 = (String)this.L$2;
                        var4_4 = (UrlFileCache)this.L$1;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl75:
                            // 2 sources

                            v2 = UrlFileCache.access$fetchAndFilterUrlLocked(var4_4, existing, var5_5, var6_6, var7_7);
lbl76:
                            // 2 sources

                            var16_16 = v2;
                        }
                        catch (Throwable var17_17) {
                            throw var17_17;
                        }
                        finally {
                            $this$withLock_u24default$iv.unlock(owner$iv);
                        }
                        return var16_16;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static /* synthetic */ Deferred get-dWUq8MI$default(UrlFileCache urlFileCache, String string, long l, ProgressIndicator progressIndicator, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            l = Duration.Companion.getZERO-UwyO8pc();
        }
        if ((n & 4) != 0) {
            progressIndicator = null;
        }
        if ((n & 8) != 0) {
            function1 = null;
        }
        return urlFileCache.get-dWUq8MI(string, l, progressIndicator, (Function1<? super InputStream, ? extends InputStream>)function1);
    }

    private final Path fetchAndFilterUrlLocked(Path existing, String url, ProgressIndicator indicator, Function1<? super InputStream, ? extends InputStream> transform) {
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setText("Downloading from " + new URL(url).getHost());
        }
        Object object = HttpRequests.request((String)url).connectTimeout((int)Duration.getInWholeMilliseconds-impl((long)UrlFileCacheKt.access$getCONNECT_TIMEOUT$p())).readTimeout((int)Duration.getInWholeMilliseconds-impl((long)UrlFileCacheKt.access$getREAD_TIMEOUT$p())).tuner(arg_0 -> UrlFileCache.fetchAndFilterUrlLocked$lambda$2(this, url, arg_0)).connect(arg_0 -> UrlFileCache.fetchAndFilterUrlLocked$lambda$5(existing, url, this, indicator, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connect(...)");
        Path file = this.transform((Path)object, this.files.get(url), transform);
        if (!Intrinsics.areEqual((Object)existing, (Object)file)) {
            Path path = existing;
            if (path != null) {
                Files.deleteIfExists(path);
            }
            this.files.put(url, file);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path transform(Path $this$transform, Path cachedPath, Function1<? super InputStream, ? extends InputStream> transform) {
        if (transform == null || Intrinsics.areEqual((Object)cachedPath, (Object)$this$transform)) {
            return $this$transform;
        }
        Path transformedPath = PathsKt.createTempFile$default((Path)this.tmpDir, null, null, (FileAttribute[])new FileAttribute[0], (int)6, null);
        try {
            Closeable closeable = Files.newInputStream($this$transform, new OpenOption[0]);
            Throwable throwable = null;
            try {
                InputStream it22 = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it22);
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                long it22 = Files.copy((InputStream)transform.invoke((Object)it22), transformedPath, copyOptionArray);
            }
            catch (Throwable it22) {
                throwable = it22;
                throw it22;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            Files.deleteIfExists(transformedPath);
            throw e;
        }
        Path path = cachedPath;
        if (path != null) {
            Files.deleteIfExists(path);
        }
        Files.deleteIfExists($this$transform);
        return transformedPath;
    }

    public void dispose() {
        File file = this.tmpDir.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        FilesKt.deleteRecursively((File)file);
    }

    private static final void fetchAndFilterUrlLocked$lambda$2(UrlFileCache this$0, String $url, URLConnection connection) {
        block1: {
            String it;
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            String string = this$0.lastModified.get($url);
            if (string != null) {
                it = string;
                boolean bl = false;
                connection.setRequestProperty("If-Modified-Since", it);
            }
            String string2 = this$0.eTags.get($url);
            if (string2 == null) break block1;
            it = string2;
            boolean bl = false;
            connection.setRequestProperty("If-None-Match", it);
        }
    }

    private static final Path fetchAndFilterUrlLocked$lambda$5(Path $existing, String $url, UrlFileCache this$0, ProgressIndicator $indicator, HttpRequests.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        URLConnection uRLConnection = request.getConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        int responseCode = ((HttpURLConnection)uRLConnection).getResponseCode();
        if (responseCode == 304) {
            if ($existing != null) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists($existing, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    return $existing;
                }
            }
            throw new HttpRequests.HttpStatusException("Received NOT_MODIFIED (304) but nothing in the cache.", 304, $url);
        }
        Path newFile = PathsKt.createTempFile$default((Path)this$0.tmpDir, null, null, (FileAttribute[])new FileAttribute[0], (int)6, null);
        try {
            request.saveToFile(newFile, $indicator);
        }
        catch (IOException e) {
            Files.deleteIfExists(newFile);
            throw e;
        }
        String it = request.getConnection().getHeaderField("Last-Modified");
        boolean bl = false;
        if (it != null) {
            this$0.lastModified.put($url, it);
        } else {
            this$0.lastModified.remove($url);
        }
        it = request.getConnection().getHeaderField("ETag");
        boolean bl2 = false;
        if (it != null) {
            this$0.eTags.put($url, it);
        } else {
            this$0.eTags.remove($url);
        }
        return newFile;
    }

    @JvmStatic
    @NotNull
    public static final UrlFileCache getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Mutex access$getMutex$p(UrlFileCache $this) {
        return $this.mutex;
    }

    public static final /* synthetic */ Map access$getFiles$p(UrlFileCache $this) {
        return $this.files;
    }

    public static final /* synthetic */ Path access$fetchAndFilterUrlLocked(UrlFileCache $this, Path existing, String url, ProgressIndicator indicator, Function1 transform) {
        return $this.fetchAndFilterUrlLocked(existing, url, indicator, (Function1<? super InputStream, ? extends InputStream>)transform);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/downloads/UrlFileCache$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/downloads/UrlFileCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.common"})
    @SourceDebugExtension(value={"SMAP\nUrlFileCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlFileCache.kt\ncom/android/tools/idea/downloads/UrlFileCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,172:1\n31#2,2:173\n*S KotlinDebug\n*F\n+ 1 UrlFileCache.kt\ncom/android/tools/idea/downloads/UrlFileCache$Companion\n*L\n169#1:173,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final UrlFileCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<UrlFileCache> serviceClass$iv = UrlFileCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (UrlFileCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

