/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gservices;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gservices.DevServicesCompatibilityProvider;
import com.android.tools.idea.gservices.DevServicesKt;
import com.android.tools.idea.gservices.DevServicesSupportStatus;
import com.intellij.openapi.application.ApplicationInfo;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/gservices/FlagBasedDevServicesCompatibilityProvider;", "Lcom/android/tools/idea/gservices/DevServicesCompatibilityProvider;", "clock", "Ljava/time/Clock;", "<init>", "(Ljava/time/Clock;)V", "currentSupportStatus", "Lcom/android/tools/idea/gservices/DevServicesSupportStatus;", "intellij.android.common"})
public final class FlagBasedDevServicesCompatibilityProvider
implements DevServicesCompatibilityProvider {
    @NotNull
    private final Clock clock;

    public FlagBasedDevServicesCompatibilityProvider(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
    }

    public /* synthetic */ FlagBasedDevServicesCompatibilityProvider(Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            clock = Clock.systemUTC();
        }
        this(clock);
    }

    @Override
    @NotNull
    public DevServicesSupportStatus currentSupportStatus() {
        Boolean supportedFlag = (Boolean)StudioFlags.DEV_SERVICES_SUPPORTED_V1.get();
        Boolean deprecatedFlag = (Boolean)StudioFlags.DEV_SERVICES_DEPRECATED_V1.get();
        LocalDateTime twoYearsAgo = LocalDateTime.now(this.clock).minusYears(2L);
        Calendar calendar = ApplicationInfo.getInstance().getBuildDate();
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"getBuildDate(...)");
        LocalDateTime buildDate = DevServicesKt.access$toLocalDateTime(calendar);
        boolean buildWayTooOld = buildDate.isBefore(twoYearsAgo);
        return buildWayTooOld || supportedFlag == false ? DevServicesSupportStatus.UNSUPPORTED : (deprecatedFlag != false ? DevServicesSupportStatus.DEPRECATED : DevServicesSupportStatus.SUPPORTED);
    }

    public FlagBasedDevServicesCompatibilityProvider() {
        this(null, 1, null);
    }
}

