/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u0000 \u001e*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001eB\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bJ\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00028\u00000\nj\b\u0012\u0004\u0012\u00028\u0000`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/util/ListenerCollection;", "T", "", "myExecutor", "Ljava/util/concurrent/Executor;", "<init>", "(Ljava/util/concurrent/Executor;)V", "myLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "myListenersSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "myListenerSetCopy", "Lcom/google/common/collect/ImmutableSet;", "add", "", "listener", "(Ljava/lang/Object;)Z", "remove", "clear", "", "size", "", "forEach", "Lcom/google/common/util/concurrent/ListenableFuture;", "Ljava/lang/Void;", "runOnListener", "Ljava/util/function/Consumer;", "getUpToDateListeners", "", "Companion", "intellij.android.common"})
public final class ListenerCollection<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Executor myExecutor;
    @NotNull
    private final ReentrantReadWriteLock myLock;
    @NotNull
    private final HashSet<T> myListenersSet;
    @Nullable
    private ImmutableSet<T> myListenerSetCopy;

    private ListenerCollection(Executor myExecutor) {
        this.myExecutor = myExecutor;
        this.myLock = new ReentrantReadWriteLock();
        this.myListenersSet = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean add(T listener) {
        boolean bl;
        ReentrantReadWriteLock reentrantReadWriteLock = this.myLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl2 = false;
            this.myListenerSetCopy = null;
            bl = this.myListenersSet.add(listener);
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(T listener) {
        boolean bl;
        ReentrantReadWriteLock reentrantReadWriteLock = this.myLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl2 = false;
            this.myListenerSetCopy = null;
            bl = this.myListenersSet.remove(listener);
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.myLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.myListenerSetCopy = ImmutableSet.of();
            this.myListenersSet.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final int size() {
        ReentrantReadWriteLock.ReadLock readLock = this.myLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            int n = this.getUpToDateListeners().size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    @NotNull
    public final ListenableFuture<Void> forEach(@NotNull Consumer<T> runOnListener) {
        Intrinsics.checkNotNullParameter(runOnListener, (String)"runOnListener");
        Set<T> listeners = this.getUpToDateListeners();
        if (listeners.isEmpty()) {
            ListenableFuture listenableFuture = Futures.immediateFuture(null);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
            return listenableFuture;
        }
        SettableFuture future = SettableFuture.create();
        this.myExecutor.execute(() -> ListenerCollection.forEach$lambda$4(listeners, runOnListener, future));
        Intrinsics.checkNotNull((Object)future);
        return (ListenableFuture)future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<T> getUpToDateListeners() {
        ImmutableSet<T> immutableSet;
        ReentrantReadWriteLock.ReadLock readLock = this.myLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            if (this.myListenerSetCopy == null) {
                ReentrantReadWriteLock reentrantReadWriteLock = this.myLock;
                ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock.readLock();
                int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                for (int i = 0; i < n; ++i) {
                    readLock2.unlock();
                }
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                writeLock.lock();
                try {
                    boolean bl2 = false;
                    if (this.myListenerSetCopy == null) {
                        this.myListenerSetCopy = ImmutableSet.copyOf((Collection)this.myListenersSet);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    for (int i = 0; i < n; ++i) {
                        readLock2.lock();
                    }
                    writeLock.unlock();
                }
            }
            ImmutableSet<T> immutableSet2 = this.myListenerSetCopy;
            Intrinsics.checkNotNull(immutableSet2);
            immutableSet = immutableSet2;
        }
        finally {
            readLock.unlock();
        }
        return (Set)immutableSet;
    }

    private static final void forEach$lambda$4(Set $listeners, Consumer $runOnListener, SettableFuture $future) {
        $listeners.forEach($runOnListener);
        $future.set(null);
    }

    @JvmStatic
    @NotNull
    public static final <T> ListenerCollection<T> createWithDirectExecutor() {
        return Companion.createWithDirectExecutor();
    }

    @JvmStatic
    @NotNull
    public static final <T> ListenerCollection<T> createWithExecutor(@NotNull Executor executor) {
        return Companion.createWithExecutor(executor);
    }

    public /* synthetic */ ListenerCollection(Executor myExecutor, DefaultConstructorMarker $constructor_marker) {
        this(myExecutor);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u0006H\u0007J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/util/ListenerCollection$Companion;", "", "<init>", "()V", "createWithDirectExecutor", "Lcom/android/tools/idea/util/ListenerCollection;", "T", "createWithExecutor", "executor", "Ljava/util/concurrent/Executor;", "intellij.android.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <T> ListenerCollection<T> createWithDirectExecutor() {
            Executor executor = MoreExecutors.directExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"directExecutor(...)");
            return this.createWithExecutor(executor);
        }

        @JvmStatic
        @NotNull
        public final <T> ListenerCollection<T> createWithExecutor(@NotNull Executor executor) {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            return new ListenerCollection(executor, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

